/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.util;

import com.necro.raid.dens.common.structure.RaidDenPool;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class RaidDenRegistry {
    public static final ResourceKey<Registry<RaidDenPool>> DEN_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"raid", (String)"den_pool"));
    private static final Map<ResourceLocation, RaidDenPool> DEN_POOL = new HashMap<ResourceLocation, RaidDenPool>();
    private static final Map<ResourceLocation, RaidStructureData> TEMPLATES = new HashMap<ResourceLocation, RaidStructureData>();
    public static final ResourceLocation DEFAULT = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raid_den/basic");

    public static void register(RaidDenPool pool) {
        if (DEN_POOL.containsKey(pool.getId())) {
            DEN_POOL.get(pool.getId()).addDens(pool);
        } else {
            DEN_POOL.put(pool.getId(), pool);
        }
    }

    public static void register(ResourceLocation structure, CompoundTag tag) {
        TEMPLATES.put(structure, new RaidStructureData(tag));
    }

    public static List<ResourceLocation> getStructures(ResourceLocation pool) {
        if (!DEN_POOL.containsKey(pool)) {
            return List.of();
        }
        return DEN_POOL.get(pool).getDens();
    }

    public static boolean isNotValidStructure(ResourceLocation structure) {
        return !TEMPLATES.containsKey(structure);
    }

    public static Vec3 getOffset(ResourceLocation structure) {
        if (!TEMPLATES.containsKey(structure)) {
            return RaidDenRegistry.TEMPLATES.get((Object)RaidDenRegistry.DEFAULT).offset;
        }
        return RaidDenRegistry.TEMPLATES.get((Object)structure).offset;
    }

    public static Vec3 getPlayerPos(ResourceLocation structure) {
        if (!TEMPLATES.containsKey(structure)) {
            return RaidDenRegistry.TEMPLATES.get((Object)RaidDenRegistry.DEFAULT).playerPos;
        }
        return RaidDenRegistry.TEMPLATES.get((Object)structure).playerPos;
    }

    public static Vec3 getBossPos(ResourceLocation structure) {
        if (!TEMPLATES.containsKey(structure)) {
            return RaidDenRegistry.TEMPLATES.get((Object)RaidDenRegistry.DEFAULT).bossPos;
        }
        return RaidDenRegistry.TEMPLATES.get((Object)structure).bossPos;
    }

    public static void clear() {
        TEMPLATES.clear();
    }

    private static class RaidStructureData {
        private final Vec3 offset;
        private final Vec3 playerPos;
        private final Vec3 bossPos;

        private RaidStructureData(CompoundTag tag) {
            this.offset = new Vec3(tag.getDouble("offset_x"), tag.getDouble("offset_y"), tag.getDouble("offset_z"));
            this.playerPos = new Vec3(tag.getDouble("player_x"), tag.getDouble("player_y"), tag.getDouble("player_z"));
            this.bossPos = new Vec3(tag.getDouble("boss_x"), tag.getDouble("boss_y"), tag.getDouble("boss_z"));
        }
    }
}

