/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.mixins.ai;

import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.MoveActionResponse;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.ai.RandomBattleAI;
import com.necro.raid.dens.common.raids.RaidAI;
import com.necro.raid.dens.common.util.IRaidBattle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RandomBattleAI.class})
public abstract class RandomBattleAIMixin {
    @Inject(method={"choose(Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;Lcom/cobblemon/mod/common/battles/ShowdownMoveset;Z)Lcom/cobblemon/mod/common/battles/ShowdownActionResponse;"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void chooseInject(ActiveBattlePokemon pokemon, ShowdownMoveset moveset, boolean forceSwitch, CallbackInfoReturnable<ShowdownActionResponse> cir) {
        ArrayList<Targetable> target;
        if (!((IRaidBattle)pokemon.getBattle()).isRaidBattle()) {
            return;
        }
        if (moveset == null) {
            cir.setReturnValue((Object)PassActionResponse.INSTANCE);
            return;
        }
        ArrayList<InBattleMove> filteredMoves = new ArrayList<InBattleMove>(moveset.getMoves().stream().filter(InBattleMove::canBeUsed).filter(move -> move.mustBeUsed() || move.getTarget().getTargetList().invoke((Object)pokemon) != null && !((List)move.getTarget().getTargetList().invoke((Object)pokemon)).isEmpty()).filter(move -> !RaidAI.BLOCKED_MOVES.contains(move.id)).toList());
        if (filteredMoves.isEmpty()) {
            cir.setReturnValue((Object)PassActionResponse.INSTANCE);
            return;
        }
        Collections.shuffle(filteredMoves);
        InBattleMove bestMove = (InBattleMove)filteredMoves.getFirst();
        ArrayList<Targetable> arrayList = target = bestMove.mustBeUsed() ? null : new ArrayList<Targetable>(((List)bestMove.getTarget().getTargetList().invoke((Object)pokemon)).stream().filter(t -> !t.isAllied((Targetable)pokemon)).toList());
        if (target == null) {
            cir.setReturnValue((Object)new MoveActionResponse(bestMove.id, null, null));
        } else {
            Collections.shuffle(target);
            ActiveBattlePokemon chosenTarget = (ActiveBattlePokemon)target.getFirst();
            cir.setReturnValue((Object)new MoveActionResponse(bestMove.id, chosenTarget.getPNX(), null));
        }
    }
}

