/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.RequestHandler;
import com.necro.raid.dens.common.raids.RewardHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RaidHelper
extends SavedData {
    public static RaidHelper INSTANCE;
    public static final Map<Player, JoinRequestInstance> JOIN_QUEUE;
    public static final Map<UUID, RaidInstance> ACTIVE_RAIDS;
    public static final Map<UUID, RequestHandler> REQUEST_QUEUE;
    public static final Map<Player, RewardHandler> REWARD_QUEUE;
    public final Set<UUID> RAID_HOSTS = new HashSet<UUID>();
    public final Set<UUID> RAID_PARTICIPANTS = new HashSet<UUID>();
    public final Map<UUID, Set<UUID>> CLEARED_RAIDS = new HashMap<UUID, Set<UUID>>();

    public static boolean isInQueue(Player player) {
        return JOIN_QUEUE.containsKey(player);
    }

    public static void addToQueue(Player player, @Nullable ItemStack key) {
        JOIN_QUEUE.put(player, new JoinRequestInstance(player, key));
    }

    public static void initRequest(ServerPlayer host, RaidCrystalBlockEntity blockEntity) {
        if (REQUEST_QUEUE.containsKey(host.getUUID())) {
            return;
        }
        REQUEST_QUEUE.put(host.getUUID(), new RequestHandler(blockEntity));
    }

    public static void addRequest(ServerPlayer host, Player player) {
        UUID uuid = host.getUUID();
        if (!REQUEST_QUEUE.containsKey(uuid)) {
            return;
        }
        REQUEST_QUEUE.get(uuid).addPlayer(player);
    }

    public static RequestHandler getRequest(ServerPlayer host) {
        if (!REQUEST_QUEUE.containsKey(host.getUUID())) {
            return null;
        }
        return REQUEST_QUEUE.get(host.getUUID());
    }

    public static void removeRequests(UUID host) {
        REQUEST_QUEUE.remove(host);
    }

    public static void addHost(Player player) {
        RaidHelper.INSTANCE.RAID_HOSTS.add(player.getUUID());
        INSTANCE.setDirty();
    }

    public static void addParticipant(Player player) {
        RaidHelper.INSTANCE.RAID_PARTICIPANTS.add(player.getUUID());
        INSTANCE.setDirty();
    }

    public static boolean hasClearedRaid(UUID uuid, Player player) {
        Set cleared = RaidHelper.INSTANCE.CLEARED_RAIDS.getOrDefault(uuid, new HashSet());
        return cleared.contains(player.getUUID());
    }

    public static void clearRaid(UUID uuid, Collection<UUID> players) {
        if (!RaidHelper.INSTANCE.CLEARED_RAIDS.containsKey(uuid)) {
            RaidHelper.INSTANCE.CLEARED_RAIDS.put(uuid, new HashSet());
        }
        RaidHelper.INSTANCE.CLEARED_RAIDS.get(uuid).addAll(players);
        INSTANCE.setDirty();
    }

    public static void resetClearedRaids(UUID uuid) {
        if (INSTANCE == null) {
            return;
        }
        RaidHelper.INSTANCE.CLEARED_RAIDS.remove(uuid);
        INSTANCE.setDirty();
    }

    public static void resetPlayerClearedRaid(UUID uuid, UUID player) {
        if (!RaidHelper.INSTANCE.CLEARED_RAIDS.containsKey(uuid)) {
            return;
        }
        RaidHelper.INSTANCE.CLEARED_RAIDS.get(uuid).remove(player);
        INSTANCE.setDirty();
    }

    public static void resetPlayerAllClearedRaids(UUID player) {
        RaidHelper.INSTANCE.CLEARED_RAIDS.values().forEach(playerSet -> playerSet.remove(player));
        INSTANCE.setDirty();
    }

    public static boolean isAlreadyHosting(Player player) {
        return RaidHelper.isAlreadyHosting(player.getUUID());
    }

    public static boolean isAlreadyHosting(UUID player) {
        return RaidHelper.INSTANCE.RAID_HOSTS.contains(player);
    }

    public static boolean isAlreadyParticipating(Player player) {
        return RaidHelper.isAlreadyParticipating(player.getUUID());
    }

    public static boolean isAlreadyParticipating(UUID player) {
        return RaidHelper.INSTANCE.RAID_PARTICIPANTS.contains(player);
    }

    public static void removeHost(UUID player) {
        RaidHelper.INSTANCE.RAID_HOSTS.remove(player);
        INSTANCE.setDirty();
    }

    public static void removeParticipant(UUID player) {
        RaidHelper.INSTANCE.RAID_PARTICIPANTS.remove(player);
        INSTANCE.setDirty();
    }

    public static void finishRaid(Set<UUID> players) {
        RaidHelper.INSTANCE.RAID_PARTICIPANTS.removeAll(players);
        INSTANCE.setDirty();
    }

    public static void onPlayerDisconnect(Player player) {
        if (!JOIN_QUEUE.containsKey(player)) {
            return;
        }
        JOIN_QUEUE.get(player).refundItem();
        JOIN_QUEUE.remove(player);
    }

    public static void onServerClose() {
        JOIN_QUEUE.forEach((player, instance) -> instance.refundItem());
        JOIN_QUEUE.clear();
    }

    public static void serverTick() {
        JOIN_QUEUE.values().removeIf(instance -> !instance.tick());
    }

    public static void commonTick() {
        ArrayList<RaidInstance> raids = new ArrayList<RaidInstance>(ACTIVE_RAIDS.values());
        raids.forEach(RaidInstance::tick);
    }

    public static Component getSystemMessage(String translatable) {
        return RaidHelper.getSystemMessage(Component.translatable((String)translatable));
    }

    public static Component getSystemMessage(MutableComponent component) {
        return component.withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC);
    }

    public static RaidHelper create() {
        return new RaidHelper();
    }

    public static RaidHelper load(CompoundTag compoundTag, HolderLookup.Provider provider) {
        RaidHelper data = RaidHelper.create();
        if (compoundTag.contains("raid_hosts")) {
            compoundTag.getList("raid_hosts", 8).forEach(host -> data.RAID_HOSTS.add(UUID.fromString(host.getAsString())));
        }
        if (compoundTag.contains("raid_participants")) {
            compoundTag.getList("raid_participants", 8).forEach(p -> data.RAID_PARTICIPANTS.add(UUID.fromString(p.getAsString())));
        }
        ListTag clearedRaids = compoundTag.getList("cleared_raids", 10);
        for (Tag t : clearedRaids) {
            CompoundTag entry = (CompoundTag)t;
            String uuid = entry.getString("uuid");
            if (uuid.isEmpty()) continue;
            HashSet<UUID> players = new HashSet<UUID>();
            ListTag uuidList = entry.getList("players", 11);
            for (Tag uuidTag : uuidList) {
                players.add(NbtUtils.loadUUID((Tag)uuidTag));
            }
            data.CLEARED_RAIDS.put(UUID.fromString(uuid), players);
        }
        return data;
    }

    public static void initHelper(MinecraftServer server) {
        INSTANCE = (RaidHelper)server.overworld().getDataStorage().computeIfAbsent(RaidHelper.type(), "cobblemonraiddens");
        INSTANCE.setDirty();
    }

    @NotNull
    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        ListTag raidHostsTag = new ListTag();
        this.RAID_HOSTS.forEach(uuid -> raidHostsTag.add((Object)StringTag.valueOf((String)uuid.toString())));
        compoundTag.put("raid_hosts", (Tag)raidHostsTag);
        ListTag raidParticipantsTag = new ListTag();
        this.RAID_PARTICIPANTS.forEach(uuid -> raidParticipantsTag.add((Object)StringTag.valueOf((String)uuid.toString())));
        compoundTag.put("raid_participants", (Tag)raidParticipantsTag);
        ListTag clearedRaidsTag = new ListTag();
        for (Map.Entry<UUID, Set<UUID>> entry : this.CLEARED_RAIDS.entrySet()) {
            CompoundTag e = new CompoundTag();
            e.putString("uuid", entry.getKey().toString());
            ListTag uuidList = new ListTag();
            for (UUID uuid2 : entry.getValue()) {
                uuidList.add((Object)NbtUtils.createUUID((UUID)uuid2));
            }
            e.put("players", (Tag)uuidList);
            clearedRaidsTag.add((Object)e);
        }
        compoundTag.put("cleared_raids", (Tag)clearedRaidsTag);
        return compoundTag;
    }

    public static SavedData.Factory<RaidHelper> type() {
        return new SavedData.Factory(RaidHelper::create, RaidHelper::load, null);
    }

    static {
        JOIN_QUEUE = new HashMap<Player, JoinRequestInstance>();
        ACTIVE_RAIDS = new HashMap<UUID, RaidInstance>();
        REQUEST_QUEUE = new HashMap<UUID, RequestHandler>();
        REWARD_QUEUE = new HashMap<Player, RewardHandler>();
    }

    public static class JoinRequestInstance {
        private final Player player;
        private final ItemStack itemStack;
        private int tick;

        public JoinRequestInstance(Player player, @Nullable ItemStack itemStack) {
            this.player = player;
            if (itemStack == null) {
                this.itemStack = null;
            } else {
                this.itemStack = itemStack.copy();
                this.itemStack.setCount(1);
            }
            this.tick = 0;
        }

        public void refundItem() {
            if (this.itemStack != null) {
                this.player.addItem(this.itemStack);
            }
        }

        public boolean tick() {
            if (++this.tick > 1200) {
                this.player.sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.request_time_out"));
                return false;
            }
            return true;
        }
    }
}

