/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.blocks.entity;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.dimensions.DimensionHelper;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.events.RaidDenSpawnEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidCycleMode;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.RaidBucket;
import com.necro.raid.dens.common.util.RaidBucketRegistry;
import com.necro.raid.dens.common.util.RaidDenRegistry;
import com.necro.raid.dens.common.util.RaidRegistry;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class RaidCrystalBlockEntity
extends class_2586
implements GeoBlockEntity {
    private UUID raidHost;
    private final Set<UUID> playerQueue;
    private int clears;
    private int inactiveTicks;
    private int soundTicks = 0;
    private UUID uuid;
    private class_2960 raidBucket;
    private class_2960 raidBoss;
    private class_2960 raidStructure;
    private class_5321<class_1937> dimensionKey;
    private class_3218 dimensionLevel;
    private boolean queueFindDimension = false;
    private int queueTimeout = 0;
    private boolean queueClose = false;
    private long lastReset;
    private boolean isOpen = false;
    private Consumer<class_3222> aspectSync;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RaidCrystalBlockEntity(class_2591<? extends RaidCrystalBlockEntity> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
        this.playerQueue = new HashSet<UUID>();
        this.uuid = UUID.randomUUID();
    }

    public void tick(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        if (this.queueFindDimension && this.raidHost != null && level.method_8503() != null) {
            class_5321<class_1937> key = ModDimensions.createLevelKey(this.raidHost.toString());
            if (level.method_8503().method_3847(key) != null) {
                this.setDimension(level.method_8503().method_3847(key));
                this.queueFindDimension = false;
            } else {
                ++this.queueTimeout;
            }
            if (this.queueTimeout > 200) {
                RaidHelper.removeHost(this.raidHost);
                RaidHelper.finishRaid(this.playerQueue);
                this.raidHost = null;
                this.playerQueue.clear();
                this.queueFindDimension = false;
            }
        } else if (this.queueClose && (this.getDimension() == null || this.getDimension().method_18456().isEmpty())) {
            this.closeRaid(blockPos);
            if (this.isAtMaxClears()) {
                level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
            }
            this.queueClose = false;
        }
        if (level.method_8608()) {
            return;
        }
        if (this.canGenerateBoss(blockState) && (this.raidBoss == null || !RaidRegistry.exists(this.raidBoss))) {
            this.generateRaidBoss(level, blockPos, blockState);
        }
        if (this.raidHost != null && this.hasDimension() && this.getDimension().method_18456().isEmpty()) {
            if (++this.inactiveTicks > 2400) {
                this.closeRaid(blockPos);
            }
        } else {
            this.inactiveTicks = 0;
        }
        if (!((Boolean)blockState.method_11654((class_2769)RaidCrystalBlock.CAN_RESET)).booleanValue()) {
            return;
        }
        if (CobblemonRaidDens.CONFIG.reset_time <= 0) {
            return;
        }
        if (this.isInProgress()) {
            return;
        }
        long gameTime = level.method_8510();
        if (this.lastReset == 0L) {
            this.lastReset = gameTime;
        } else if (gameTime - this.lastReset > (long)CobblemonRaidDens.CONFIG.reset_time * 20L) {
            this.playerQueue.clear();
            this.generateRaidBoss(level, blockPos, blockState);
        }
        if (!this.isActive(blockState)) {
            return;
        }
        if (++this.soundTicks % 60 == 0) {
            level.method_8396(null, blockPos, class_3417.field_26980, class_3419.field_15245, 1.0f, 1.0f);
            this.soundTicks = 0;
        }
    }

    public void generateRaidBoss(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        RaidCycleMode cycleMode = (RaidCycleMode)((Object)blockState.method_11654(RaidCrystalBlock.CYCLE_MODE));
        class_2960 bossLocation = null;
        if (cycleMode == RaidCycleMode.NONE) {
            return;
        }
        if (this.raidBucket != null) {
            bossLocation = RaidBucketRegistry.getBucket(this.raidBucket).getRandomRaidBoss(level.method_8409(), level);
        }
        if (bossLocation == null) {
            RaidTier tier = cycleMode.canCycleTier() ? RaidTier.getWeightedRandom(level.method_8409(), level) : (RaidTier)((Object)blockState.method_11654(RaidCrystalBlock.RAID_TIER));
            RaidType type = cycleMode.canCycleType() ? null : (RaidType)((Object)blockState.method_11654(RaidCrystalBlock.RAID_TYPE));
            bossLocation = RaidRegistry.getRandomRaidBoss(level.method_8409(), level, tier, type, null);
        }
        RaidBoss raidBoss = RaidRegistry.getRaidBoss(bossLocation);
        if (bossLocation == null || raidBoss == null) {
            return;
        }
        this.setRaidBoss(bossLocation, level.method_8409(), level.method_8510());
        level.method_8652(blockPos, (class_2680)((class_2680)((class_2680)blockState.method_11657(RaidCrystalBlock.RAID_TIER, (Comparable)((Object)raidBoss.getTier()))).method_11657(RaidCrystalBlock.RAID_TYPE, (Comparable)((Object)raidBoss.getType()))).method_11657((class_2769)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        RaidEvents.RAID_DEN_SPAWN.emit((Object[])new RaidDenSpawnEvent[]{new RaidDenSpawnEvent((class_3218)level, blockPos, raidBoss)});
    }

    public boolean spawnRaidBoss() {
        if (this.getDimension() == null) {
            return false;
        }
        RaidBoss raidBoss = this.getRaidBoss();
        if (raidBoss == null) {
            CobblemonRaidDens.LOGGER.error("Could not load Raid Boss {}", (Object)this.raidBoss);
            this.setRaidBoss(null, null, 0L);
            return false;
        }
        PokemonEntity pokemonEntity = raidBoss.getBossEntity(this.getDimension());
        pokemonEntity.method_29495(RaidDenRegistry.getBossPos(this.getRaidStructure()));
        this.getDimension().method_8649((class_1297)pokemonEntity);
        if (pokemonEntity.getPokemon().getAbility().getName().equals("imposter") || pokemonEntity.getPokemon().getMoveSet().getMoves().stream().anyMatch(move -> move.getName().equals("transform"))) {
            this.setAspectSync(player -> RaidDenNetworkMessages.RAID_ASPECT.accept((class_3222)player, (class_1297)pokemonEntity));
        }
        return true;
    }

    public void clearRaid() {
        ++this.clears;
        if (this.isAtMaxClears()) {
            RaidHelper.resetClearedRaids(this.getUuid());
        } else {
            RaidHelper.clearRaid(this.getUuid(), this.playerQueue);
        }
        this.setQueueClose();
    }

    public void closeRaid(class_2338 blockPos) {
        this.removeChunkTicket();
        RaidHelper.removeHost(this.raidHost);
        RaidHelper.finishRaid(this.playerQueue);
        RaidHelper.removeRequests(this.raidHost);
        if (this.method_10997() == null || !this.hasDimension()) {
            return;
        }
        this.getDimension().method_18456().forEach(player -> player.method_14251((class_3218)this.method_10997(), (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() - 0.5, 0.0f, 0.0f));
        this.getDimension().method_8390(PokemonEntity.class, new class_238(class_2338.field_10980).method_1014(32.0), p1 -> ((IRaidAccessor)p1).isRaidBoss()).forEach(p1 -> {
            RaidInstance raidInstance = RaidHelper.ACTIVE_RAIDS.remove(((IRaidAccessor)p1).getRaidId());
            if (raidInstance != null) {
                raidInstance.stopRaid(false);
                if (CobblemonRaidDens.CONFIG.max_clears_include_fails) {
                    ++this.clears;
                }
            }
        });
        this.removeDimension();
        this.setDimension(null);
        this.raidHost = null;
        this.playerQueue.clear();
        this.inactiveTicks = 0;
        this.method_10997().method_8500(blockPos).method_12008(true);
        this.method_5431();
        this.isOpen = false;
        this.setAspectSync(null);
    }

    protected void removeDimension() {
        if (CobblemonRaidDens.CONFIG.cache_dimensions) {
            DimensionHelper.addToCache(this.getDimension());
        } else {
            class_5321<class_1937> levelKey = ModDimensions.createLevelKey(this.raidHost.toString());
            DimensionHelper.queueForRemoval(levelKey, this.getDimension());
            if (this.method_10997() != null) {
                DimensionHelper.SYNC_DIMENSIONS.accept((Object)this.method_10997().method_8503(), levelKey, (Object)false);
            }
        }
    }

    public void addChunkTicket() {
        if (this.method_10997() == null) {
            return;
        }
        class_1923 chunkPos = new class_1923(this.method_11016());
        ((class_3218)this.method_10997()).method_14178().method_17297(class_3230.field_19347, chunkPos, 2, (Object)"raid".hashCode());
    }

    private void removeChunkTicket() {
        if (this.method_10997() == null) {
            return;
        }
        class_1923 chunkPos = new class_1923(this.method_11016());
        ((class_3218)this.method_10997()).method_14178().method_17300(class_3230.field_19347, chunkPos, 2, (Object)"raid".hashCode());
    }

    public UUID getRaidHost() {
        return this.raidHost;
    }

    public boolean canSetRaidHost() {
        return this.getRaidHost() == null;
    }

    public void setRaidHost(class_1657 player) {
        this.raidHost = player.method_5667();
        this.playerQueue.add(player.method_5667());
        this.method_5431();
    }

    public void clearRaidHost() {
        this.playerQueue.remove(this.raidHost);
        this.raidHost = null;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public RaidBucket getRaidBucket() {
        return RaidBucketRegistry.getBucket(this.raidBucket);
    }

    public RaidBoss getRaidBoss() {
        return RaidRegistry.getRaidBoss(this.raidBoss);
    }

    public class_2960 getRaidBossLocation() {
        return this.raidBoss;
    }

    public class_2960 getRaidStructure() {
        return this.raidStructure;
    }

    public void addPlayer(class_1657 player) {
        this.playerQueue.add(player.method_5667());
        this.method_5431();
    }

    public int getPlayerCount() {
        return this.playerQueue.size();
    }

    public long getTicksUntilNextReset() {
        if (this.method_10997() == null) {
            return 0L;
        }
        if (!((Boolean)this.method_11010().method_11654((class_2769)RaidCrystalBlock.CAN_RESET)).booleanValue()) {
            return 0L;
        }
        if (CobblemonRaidDens.CONFIG.reset_time <= 0) {
            return 0L;
        }
        return (long)CobblemonRaidDens.CONFIG.reset_time * 20L - (this.method_10997().method_8510() - this.lastReset);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen() {
        this.isOpen = true;
    }

    public boolean isPlayerParticipating(class_1657 player) {
        return this.playerQueue.contains(player.method_5667());
    }

    public boolean isInProgress() {
        return !this.playerQueue.isEmpty() && this.getDimension() != null && !this.getDimension().method_18456().isEmpty();
    }

    public boolean isActive(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)RaidCrystalBlock.ACTIVE) != false && blockState.method_11654(RaidCrystalBlock.RAID_TYPE) != RaidType.NONE && this.raidBoss != null;
    }

    public boolean canGenerateBoss(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)RaidCrystalBlock.ACTIVE) != false && blockState.method_11654(RaidCrystalBlock.RAID_TYPE) != RaidType.NONE;
    }

    public boolean renderBeacon(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)RaidCrystalBlock.ACTIVE) != false && blockState.method_11654(RaidCrystalBlock.RAID_TYPE) != RaidType.NONE;
    }

    public void resetClears() {
        this.clears = 0;
    }

    public boolean isAtMaxClears() {
        RaidBoss boss = this.getRaidBoss();
        if (boss == null) {
            return true;
        }
        int maxClears = CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier()).maxClears();
        return maxClears != -1 && this.clears >= maxClears;
    }

    public class_3218 getDimension() {
        if (this.dimensionLevel != null) {
            return this.dimensionLevel;
        }
        if (this.method_10997() == null || this.method_10997().method_8503() == null) {
            return null;
        }
        this.dimensionLevel = this.method_10997().method_8503().method_3847(this.dimensionKey);
        return this.dimensionLevel;
    }

    public void setDimension(class_3218 level) {
        this.dimensionKey = level == null ? null : level.method_27983();
        this.dimensionLevel = level;
    }

    public boolean hasDimension() {
        return this.getDimension() != null;
    }

    public boolean isFull() {
        RaidBoss boss = this.getRaidBoss();
        if (boss == null) {
            return true;
        }
        int maxPlayers = CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier()).maxPlayers();
        return maxPlayers != -1 && this.playerQueue.size() >= maxPlayers;
    }

    public boolean isBusy() {
        return this.queueClose || this.queueFindDimension;
    }

    public void setQueueClose() {
        this.queueClose = true;
    }

    public void setRaidBucket(class_2960 bucket) {
        this.raidBucket = bucket;
    }

    public void syncAspects(class_3222 player) {
        if (this.aspectSync == null) {
            return;
        }
        CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS).execute(() -> this.aspectSync.accept(player));
    }

    public void setAspectSync(Consumer<class_3222> sync) {
        this.aspectSync = sync;
    }

    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        if (compoundTag.method_10545("raid_host_uuid")) {
            this.raidHost = UUID.fromString(compoundTag.method_10558("raid_host_uuid"));
            this.queueFindDimension = true;
        }
        if (compoundTag.method_10545("raid_player_queue")) {
            compoundTag.method_10554("raid_player_queue", 8).forEach(tag -> this.playerQueue.add(UUID.fromString(tag.method_10714())));
        }
        this.clears = compoundTag.method_10550("raid_cleared");
        this.lastReset = compoundTag.method_10537("last_reset");
        this.inactiveTicks = compoundTag.method_10550("raid_inactive_for");
        this.uuid = compoundTag.method_10545("uuid") ? UUID.fromString(compoundTag.method_10558("uuid")) : UUID.randomUUID();
        if (compoundTag.method_10545("raid_bucket")) {
            this.raidBucket = class_2960.method_60654((String)compoundTag.method_10558("raid_bucket"));
        }
        if (compoundTag.method_10545("raid_boss")) {
            this.raidBoss = class_2960.method_60654((String)compoundTag.method_10558("raid_boss"));
        }
        this.raidStructure = compoundTag.method_10545("raid_structure") ? class_2960.method_60654((String)compoundTag.method_10558("raid_structure")) : RaidDenRegistry.DEFAULT;
        if (compoundTag.method_10545("is_open")) {
            this.isOpen = true;
        }
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        if (this.raidHost != null) {
            compoundTag.method_10582("raid_host_uuid", this.raidHost.toString());
        } else if (this.getDimension() != null) {
            compoundTag.method_10582("raid_host_uuid", this.dimensionKey.method_29177().method_12832());
        }
        class_2499 playerQueueTag = new class_2499();
        this.playerQueue.forEach(uuid -> playerQueueTag.add((Object)class_2519.method_23256((String)uuid.toString())));
        compoundTag.method_10566("raid_player_queue", (class_2520)playerQueueTag);
        compoundTag.method_10569("raid_cleared", this.clears);
        compoundTag.method_10544("last_reset", this.lastReset);
        compoundTag.method_10569("raid_inactive_for", this.inactiveTicks);
        if (this.uuid != null) {
            compoundTag.method_10582("uuid", this.uuid.toString());
        }
        if (this.raidBucket != null) {
            compoundTag.method_10582("raid_bucket", this.raidBucket.toString());
        }
        if (this.raidBoss != null) {
            compoundTag.method_10582("raid_boss", this.raidBoss.toString());
        }
        if (this.raidStructure != null) {
            compoundTag.method_10582("raid_structure", this.raidStructure.toString());
        }
        if (this.isOpen) {
            compoundTag.method_10556("is_open", true);
        }
    }

    public void setRaidBoss(class_2960 raidBoss, class_5819 random, long gameTime) {
        RaidHelper.resetClearedRaids(this.getUuid());
        this.resetClears();
        this.inactiveTicks = 0;
        this.lastReset = gameTime;
        this.raidBoss = raidBoss;
        this.raidStructure = raidBoss == null ? null : this.getRaidBoss().getRandomDen(random);
        this.method_5431();
    }

    public void setRaidStructure(class_2960 structure) {
        this.raidStructure = structure;
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = super.method_16887(provider);
        if (this.raidBoss != null) {
            tag.method_10582("raid_boss", this.raidBoss.toString());
        }
        return tag;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

