/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.BattleStartError;
import com.cobblemon.mod.common.battles.BattleStartResult;
import com.cobblemon.mod.common.battles.ErroredBattleStart;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.actor.PokemonBattleActor;
import com.cobblemon.mod.common.battles.ai.RandomBattleAI;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.util.RaidUtils;
import java.util.List;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class RaidBuilder {
    public static BattleStartResult build(class_3222 player, PokemonEntity pokemonEntity, @Nullable UUID leadingPokemon, int raidPartySize) {
        List<BattlePokemon> battleTeam = PlayerExtensionsKt.party((class_3222)player).toBattleTeam(false, false, leadingPokemon).stream().filter(p -> !p.getEffectedPokemon().isFainted() && !RaidUtils.isPokemonBlacklisted(p.getEffectedPokemon()) && !RaidUtils.isAbilityBlacklisted(p.getEffectedPokemon().getAbility())).toList();
        if (!battleTeam.isEmpty()) {
            battleTeam = battleTeam.subList(0, class_3532.method_15340((int)battleTeam.size(), (int)1, (int)raidPartySize));
        }
        PlayerBattleActor playerActor = new PlayerBattleActor(player.method_5667(), battleTeam);
        PokemonBattleActor wildActor = new PokemonBattleActor(pokemonEntity.getPokemon().getUuid(), new BattlePokemon(pokemonEntity.getPokemon(), pokemonEntity.getPokemon(), p -> Unit.INSTANCE), Cobblemon.config.getDefaultFleeDistance(), (BattleAI)new RandomBattleAI());
        BattleFormat battleFormat = BattleFormat.Companion.getGEN_9_SINGLES();
        ErroredBattleStart errors = new ErroredBattleStart();
        if (!battleTeam.isEmpty() && battleTeam.getFirst().getHealth() <= 0) {
            errors.getParticipantErrors().get((BattleActor)playerActor).add(BattleStartError.Companion.insufficientPokemon((class_1297)player, battleFormat.getBattleType().getSlotsPerActor(), playerActor.getPokemonList().size()));
        }
        if (playerActor.getPokemonList().stream().anyMatch(battlePokemon -> battlePokemon.getEntity() != null && battlePokemon.getEntity().isBusy())) {
            player.method_5476();
            errors.getParticipantErrors().get((BattleActor)playerActor).add(BattleStartError.Companion.targetIsBusy(player.method_5476()));
        }
        if (BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(player) != null) {
            errors.getParticipantErrors().get((BattleActor)playerActor).add(BattleStartError.Companion.alreadyInBattle((BattleActor)playerActor));
        }
        playerActor.setBattleTheme(pokemonEntity.getBattleTheme());
        if (errors.isEmpty()) {
            return BattleRegistry.INSTANCE.startBattle(battleFormat, new BattleSide(new BattleActor[]{playerActor}), new BattleSide(new BattleActor[]{wildActor}), true);
        }
        return errors;
    }
}

