/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.net.messages.client.battle.BattleApplyPassResponsePacket;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.config.TierConfig;
import com.necro.raid.dens.common.events.RaidEndEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RewardHandler;
import com.necro.raid.dens.common.showdown.RaidBagItems;
import com.necro.raid.dens.common.showdown.bagitems.CheerBagItem;
import com.necro.raid.dens.common.showdown.bagitems.PlayerJoinBagItem;
import com.necro.raid.dens.common.showdown.bagitems.StatChangeBagItem;
import com.necro.raid.dens.common.util.IHealthSetter;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IRaidBattle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class RaidInstance {
    private static final Map<String, BiConsumer<RaidInstance, PokemonBattle>> INSTRUCTION_MAP = new HashMap<String, BiConsumer<RaidInstance, PokemonBattle>>();
    private final PokemonEntity bossEntity;
    private final RaidBoss raidBoss;
    private final class_3213 bossEvent;
    private final List<PokemonBattle> battles;
    private final Map<UUID, Float> damageCache;
    private final List<class_3222> activePlayers;
    private final List<UUID> failedPlayers;
    private float currentHealth;
    private float maxHealth;
    private final float initMaxHealth;
    private final Map<Integer, String> scriptByTurn;
    private final NavigableMap<Double, String> scriptByHp;
    private final Map<UUID, Integer> cheersLeft;
    private final List<DelayedRunnable> runQueue;

    public RaidInstance(PokemonEntity entity) {
        this.bossEntity = entity;
        this.raidBoss = ((IRaidAccessor)entity).getRaidBoss();
        this.bossEvent = new class_3213((class_2561)((class_5250)entity.method_5477()).method_27692(class_124.field_1067).method_27692(class_124.field_1068), class_1259.class_1260.field_5786, class_1259.class_1261.field_5791);
        this.battles = new ArrayList<PokemonBattle>();
        this.damageCache = new HashMap<UUID, Float>();
        this.activePlayers = new ArrayList<class_3222>();
        this.failedPlayers = new ArrayList<UUID>();
        this.currentHealth = entity.getPokemon().getCurrentHealth();
        this.initMaxHealth = this.maxHealth = (float)entity.getPokemon().getMaxHealth();
        this.scriptByTurn = new HashMap<Integer, String>();
        this.scriptByHp = new TreeMap<Double, String>();
        this.raidBoss.getScript().forEach((key, func) -> {
            if (!INSTRUCTION_MAP.containsKey(func)) {
                return;
            }
            try {
                if (key.startsWith("turn:")) {
                    this.scriptByTurn.put(Integer.parseInt(key.split(":")[1]), (String)func);
                } else if (key.startsWith("hp:")) {
                    double threshold = Double.parseDouble(key.split(":")[1]);
                    if ((double)(this.currentHealth / this.maxHealth) < threshold) {
                        return;
                    }
                    this.scriptByHp.put(threshold, (String)func);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.cheersLeft = new HashMap<UUID, Integer>();
        this.runQueue = new ArrayList<DelayedRunnable>();
        this.runQueue.add(new DelayedRunnable(() -> {
            if (this.bossEntity.method_29504()) {
                return;
            }
            for (class_3222 player : this.activePlayers) {
                if (player.method_37908() == this.bossEntity.method_37908()) continue;
                this.removePlayer(player);
            }
        }, 20, true));
    }

    public void addPlayer(class_3222 player, PokemonBattle battle) {
        TierConfig tierConfig = CobblemonRaidDens.TIER_CONFIG.get((Object)this.raidBoss.getTier());
        ((IRaidBattle)battle).setRaidBattle(this);
        this.battles.add(battle);
        this.bossEvent.method_14088(player);
        this.damageCache.put(player.method_5667(), Float.valueOf(this.currentHealth));
        if (!this.activePlayers.isEmpty() && tierConfig.multiplayerHealthMultiplier() > 1.0f) {
            this.applyHealthMulti(player);
        }
        if (this.scriptByTurn.containsKey(0)) {
            ((IRaidBattle)battle).addToQueue(INSTRUCTION_MAP.get(this.scriptByTurn.get(0)));
        }
        this.cheersLeft.put(player.method_5667(), tierConfig.maxCheers());
        this.activePlayers.add(player);
        RaidDenNetworkMessages.SYNC_HEALTH.accept(player, Float.valueOf(this.currentHealth / this.maxHealth));
    }

    private void applyHealthMulti(class_3222 newPlayer) {
        float bonusHealth = this.initMaxHealth * (CobblemonRaidDens.TIER_CONFIG.get((Object)this.raidBoss.getTier()).multiplayerHealthMultiplier() - 1.0f) * (float)this.activePlayers.size();
        float currentRatio = this.currentHealth / this.maxHealth;
        this.maxHealth = this.initMaxHealth + bonusHealth;
        this.currentHealth = this.maxHealth * currentRatio;
        ((IHealthSetter)this.bossEntity.getPokemon()).setMaxHealth((int)this.maxHealth, false);
        this.bossEntity.getPokemon().setCurrentHealth((int)this.currentHealth);
        this.battles.forEach(b -> {
            class_3222 player = (class_3222)b.getPlayers().getFirst();
            ((IRaidBattle)b).addToQueue((raid, battle) -> raid.playerJoin((PokemonBattle)battle, player, (class_1657)newPlayer));
        });
    }

    public void addPlayer(PokemonBattle battle) {
        this.addPlayer((class_3222)battle.getPlayers().getFirst(), battle);
    }

    public void removePlayer(class_3222 player, PokemonBattle battle) {
        this.battles.remove(battle);
        ((IRaidBattle)battle).setRaidBattle(null);
        this.bossEvent.method_14089(player);
        this.damageCache.remove(player.method_5667());
        this.failedPlayers.add(player.method_5667());
    }

    public void removePlayer(PokemonBattle battle) {
        this.removePlayer((class_3222)battle.getPlayers().getFirst(), battle);
    }

    public void removePlayer(class_3222 player) {
        this.bossEvent.method_14089(player);
        this.damageCache.remove(player.method_5667());
    }

    public void syncHealth(class_3222 player, PokemonBattle battle, float remainingHealth) {
        if (!this.activePlayers.contains(player) && ((IRaidBattle)battle).isRaidBattle()) {
            this.addPlayer(player, battle);
        }
        float damage = this.damageCache.get(player.method_5667()).floatValue() - remainingHealth;
        this.damageCache.put(player.method_5667(), Float.valueOf(remainingHealth));
        this.currentHealth = Math.clamp(this.currentHealth - damage, 0.0f, this.maxHealth);
        this.activePlayers.forEach(p -> RaidDenNetworkMessages.SYNC_HEALTH.accept((class_3222)p, Float.valueOf(this.currentHealth / this.maxHealth)));
        if (this.currentHealth == 0.0f) {
            this.bossEvent.method_5408(this.currentHealth / this.maxHealth);
            this.queueStopRaid();
        } else {
            this.runQueue.add(new DelayedRunnable(() -> {
                this.bossEvent.method_5408(this.currentHealth / this.maxHealth);
                this.runScriptByHp((double)this.currentHealth / (double)this.maxHealth);
            }, 20));
        }
    }

    public List<class_3222> getPlayers() {
        return this.activePlayers;
    }

    public float getRemainingHealth() {
        return this.currentHealth;
    }

    public boolean hasFailed(class_3222 player) {
        return this.failedPlayers.contains(player.method_5667());
    }

    public void tick() {
        this.runQueue.removeIf(DelayedRunnable::tick);
    }

    public void queueStopRaid() {
        this.queueStopRaid(true);
    }

    public void queueStopRaid(boolean raidSuccess) {
        this.runQueue.add(new DelayedRunnable(() -> this.stopRaid(raidSuccess), 60));
    }

    public void stopRaid(boolean raidSuccess) {
        this.bossEvent.method_14091(false);
        this.bossEvent.method_14094();
        if (raidSuccess) {
            this.bossEntity.method_6033(0.0f);
        }
        RaidHelper.ACTIVE_RAIDS.remove(((IRaidAccessor)this.bossEntity).getRaidId());
        this.battles.forEach(PokemonBattle::stop);
        if (this.raidBoss == null) {
            return;
        }
        if (raidSuccess) {
            this.handleSuccess();
        } else {
            this.handleFailed();
        }
    }

    private void handleSuccess() {
        List<Object> failed;
        List<Object> success;
        int catches = this.raidBoss.getMaxCatches();
        if (catches < 0 || this.activePlayers.size() < catches) {
            success = this.activePlayers;
            failed = List.of();
        } else if (catches == 0) {
            success = List.of();
            failed = this.activePlayers;
        } else {
            Collections.shuffle(this.activePlayers);
            success = this.activePlayers.subList(0, catches);
            failed = this.activePlayers.subList(catches, this.activePlayers.size());
        }
        success.forEach(player -> {
            new RewardHandler(this.raidBoss, (class_3222)player, true).sendRewardMessage();
            RaidEvents.RAID_END.emit((Object[])new RaidEndEvent[]{new RaidEndEvent((class_3222)player, this.raidBoss, true)});
        });
        failed.forEach(player -> {
            new RewardHandler(this.raidBoss, (class_3222)player, false).sendRewardMessage();
            RaidEvents.RAID_END.emit((Object[])new RaidEndEvent[]{new RaidEndEvent((class_3222)player, this.raidBoss, true)});
        });
    }

    private void handleFailed() {
        this.activePlayers.forEach(player -> {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.cobblemonraiddens.raid.raid_fail"));
            RaidEvents.RAID_END.emit((Object[])new RaidEndEvent[]{new RaidEndEvent((class_3222)player, this.raidBoss, false)});
        });
    }

    public RaidBoss getRaidBoss() {
        return this.raidBoss;
    }

    public void runScriptByTurn(PokemonBattle battle, int turn) {
        String func = this.scriptByTurn.remove(turn);
        if (func == null) {
            return;
        }
        ((IRaidBattle)battle).addToQueue(INSTRUCTION_MAP.get(func));
    }

    public void runScriptByHp(double hpRatio) {
        this.scriptByHp.tailMap(hpRatio, true).values().forEach(func -> this.battles.forEach(battle -> ((IRaidBattle)battle).addToQueue(INSTRUCTION_MAP.get(func))));
        this.scriptByHp.keySet().removeIf(hp -> hp >= hpRatio);
    }

    public boolean runCheer(class_3222 player, PokemonBattle oBattle, BagItem bagItem, String data) {
        int cheersLeft = this.cheersLeft.getOrDefault(player.method_5667(), 0);
        if (cheersLeft <= 0) {
            return false;
        }
        this.cheersLeft.put(player.method_5667(), --cheersLeft);
        this.cheer(oBattle, bagItem, data, false);
        for (PokemonBattle b : this.battles) {
            if (b == oBattle) continue;
            ((IRaidBattle)b).addToQueue((raid, battle) -> raid.cheer((PokemonBattle)battle, bagItem, data, true));
        }
        return true;
    }

    public void playerJoin(PokemonBattle battle, class_3222 player, class_1657 newPlayer) {
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side2.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null) {
            return;
        }
        if (target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        BattlePokemon bp = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon();
        String data = String.format("%s %s", (int)this.currentHealth, newPlayer.method_5477().getString());
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse((BagItem)new PlayerJoinBagItem(), bp, data));
        this.damageCache.put(player.method_5667(), Float.valueOf((float)Math.floor(this.currentHealth)));
    }

    public void cheer(PokemonBattle battle, BagItem bagItem, String data, boolean skipEnemyAction) {
        PokemonEntity pokemonEntity;
        CheerBagItem cheerBagItem;
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side1.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null || target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        if (bagItem instanceof CheerBagItem && (cheerBagItem = (CheerBagItem)bagItem).cheerType() == CheerBagItem.CheerType.HEAL && (pokemonEntity = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon().getEntity()) instanceof PokemonEntity) {
            PokemonEntity entity = pokemonEntity;
            entity.method_5783(CobblemonSounds.MEDICINE_HERB_USE, 1.0f, 1.0f);
        }
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse(bagItem, ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon(), data), skipEnemyAction);
    }

    private void changeBossStat(@NotNull PokemonBattle battle, Stat stat, int stages) {
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side2.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null) {
            return;
        }
        if (target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        BattlePokemon bp = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon();
        String key = bp.getUuid().toString();
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse((BagItem)new StatChangeBagItem(stat, stages), bp, key));
    }

    private void changePlayerStat(@NotNull PokemonBattle battle, Stat stat, int stages) {
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side1.getActivePokemon();
        List origin = side2.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null) {
            return;
        }
        if (target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        if (origin.isEmpty() || ((ActiveBattlePokemon)origin.getFirst()).getBattlePokemon() == null) {
            return;
        }
        BattlePokemon bp = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon();
        String key = ((ActiveBattlePokemon)origin.getFirst()).getBattlePokemon().getUuid().toString();
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse((BagItem)new StatChangeBagItem(stat, stages), bp, key));
    }

    private void clearBossStats(@NotNull PokemonBattle battle) {
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side2.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null) {
            return;
        }
        if (target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        BattlePokemon bp = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon();
        String key = bp.getUuid().toString();
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse(RaidBagItems.CLEAR_BOSS, bp, key));
    }

    private void clearPlayerStats(@NotNull PokemonBattle battle) {
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side1.getActivePokemon();
        List origin = side2.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null) {
            return;
        }
        if (target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        if (origin.isEmpty() || ((ActiveBattlePokemon)origin.getFirst()).getBattlePokemon() == null) {
            return;
        }
        BattlePokemon bp = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon();
        String key = ((ActiveBattlePokemon)origin.getFirst()).getBattlePokemon().getUuid().toString();
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse(RaidBagItems.CLEAR_PLAYER, bp, key));
    }

    private void useSimpleBagItem(@NotNull PokemonBattle battle, BagItem item) {
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side2.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null) {
            return;
        }
        if (target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        BattlePokemon bp = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon();
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse(item, bp, null));
    }

    private void sendAction(BattleActor side1, BattleActor side2, ShowdownActionResponse response) {
        this.sendAction(side1, side2, response, true);
    }

    private void sendAction(BattleActor side1, BattleActor side2, ShowdownActionResponse response, boolean skipEnemyAction) {
        side1.getResponses().add(response);
        side1.setMustChoose(false);
        if (skipEnemyAction) {
            side2.getResponses().addFirst(PassActionResponse.INSTANCE);
            side2.setMustChoose(false);
        }
        side1.getBattle().checkForInputDispatch();
        side1.sendUpdate((NetworkPacket)new BattleApplyPassResponsePacket());
    }

    static {
        INSTRUCTION_MAP.put("RESET_BOSS", RaidInstance::clearBossStats);
        INSTRUCTION_MAP.put("RESET_PLAYER", RaidInstance::clearPlayerStats);
        INSTRUCTION_MAP.put("BOSS_ATK_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.ATTACK, 1));
        INSTRUCTION_MAP.put("BOSS_ATK_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.ATTACK, 2));
        INSTRUCTION_MAP.put("BOSS_DEF_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.DEFENCE, 1));
        INSTRUCTION_MAP.put("BOSS_DEF_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.DEFENCE, 2));
        INSTRUCTION_MAP.put("BOSS_SPA_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.SPECIAL_ATTACK, 1));
        INSTRUCTION_MAP.put("BOSS_SPA_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.SPECIAL_ATTACK, 2));
        INSTRUCTION_MAP.put("BOSS_SPD_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.SPECIAL_DEFENCE, 1));
        INSTRUCTION_MAP.put("BOSS_SPD_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.SPECIAL_DEFENCE, 2));
        INSTRUCTION_MAP.put("BOSS_SPE_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.SPEED, 1));
        INSTRUCTION_MAP.put("BOSS_SPE_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.SPEED, 2));
        INSTRUCTION_MAP.put("BOSS_ACC_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.ACCURACY, 1));
        INSTRUCTION_MAP.put("BOSS_ACC_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.ACCURACY, 2));
        INSTRUCTION_MAP.put("BOSS_EVA_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.EVASION, 1));
        INSTRUCTION_MAP.put("BOSS_EVA_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.EVASION, 2));
        INSTRUCTION_MAP.put("PLAYER_ATK_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.ATTACK, -1));
        INSTRUCTION_MAP.put("PLAYER_ATK_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.ATTACK, -2));
        INSTRUCTION_MAP.put("PLAYER_DEF_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.DEFENCE, -1));
        INSTRUCTION_MAP.put("PLAYER_DEF_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.DEFENCE, -2));
        INSTRUCTION_MAP.put("PLAYER_SPA_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.SPECIAL_ATTACK, -1));
        INSTRUCTION_MAP.put("PLAYER_SPA_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.SPECIAL_ATTACK, -2));
        INSTRUCTION_MAP.put("PLAYER_SPD_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.SPECIAL_DEFENCE, -1));
        INSTRUCTION_MAP.put("PLAYER_SPD_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.SPECIAL_DEFENCE, -2));
        INSTRUCTION_MAP.put("PLAYER_SPE_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.SPEED, -1));
        INSTRUCTION_MAP.put("PLAYER_SPE_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.SPEED, -2));
        INSTRUCTION_MAP.put("PLAYER_ACC_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.ACCURACY, -1));
        INSTRUCTION_MAP.put("PLAYER_ACC_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.ACCURACY, -2));
        INSTRUCTION_MAP.put("PLAYER_EVA_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.EVASION, -1));
        INSTRUCTION_MAP.put("PLAYER_EVA_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.EVASION, -2));
        INSTRUCTION_MAP.put("SET_RAIN", (r, b) -> r.useSimpleBagItem((PokemonBattle)b, RaidBagItems.SET_RAIN));
        INSTRUCTION_MAP.put("SET_SANDSTORM", (r, b) -> r.useSimpleBagItem((PokemonBattle)b, RaidBagItems.SET_SANDSTORM));
        INSTRUCTION_MAP.put("SET_SNOW", (r, b) -> r.useSimpleBagItem((PokemonBattle)b, RaidBagItems.SET_SNOW));
        INSTRUCTION_MAP.put("SET_SUN", (r, b) -> r.useSimpleBagItem((PokemonBattle)b, RaidBagItems.SET_SUN));
        INSTRUCTION_MAP.put("SET_ELECTRIC_TERRAIN", (r, b) -> r.useSimpleBagItem((PokemonBattle)b, RaidBagItems.SET_ELECTRIC_TERRAIN));
        INSTRUCTION_MAP.put("SET_GRASSY_TERRAIN", (r, b) -> r.useSimpleBagItem((PokemonBattle)b, RaidBagItems.SET_GRASSY_TERRAIN));
        INSTRUCTION_MAP.put("SET_MISTY_TERRAIN", (r, b) -> r.useSimpleBagItem((PokemonBattle)b, RaidBagItems.SET_MISTY_TERRAIN));
        INSTRUCTION_MAP.put("SET_PSYCHIC_TERRAIN", (r, b) -> r.useSimpleBagItem((PokemonBattle)b, RaidBagItems.SET_PSYCHIC_TERRAIN));
    }

    private static class DelayedRunnable {
        private final Runnable runnable;
        private final int delay;
        private int tick;
        private final boolean repeat;

        public DelayedRunnable(Runnable runnable, int delay, boolean repeat) {
            this.runnable = runnable;
            this.delay = delay;
            this.tick = 0;
            this.repeat = repeat;
        }

        public DelayedRunnable(Runnable runnable, int delay) {
            this(runnable, delay, false);
        }

        public boolean tick() {
            if (++this.tick < this.delay) {
                return false;
            }
            this.runnable.run();
            if (this.repeat) {
                this.tick = 0;
            }
            return !this.repeat;
        }
    }
}

