/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class LogComponent {
    private static final ResourceLocation LOG = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"textures/gui/raid/log.png");
    private static final int LOG_WIDTH = 90;
    private static final int LOG_HEIGHT = 16;
    private final Component log;
    private int tick;

    public LogComponent(Component log) {
        this.log = ((MutableComponent)log).withStyle(ChatFormatting.ITALIC);
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTick) {
        Font font = Minecraft.getInstance().font;
        float rate = Math.min(((float)this.tick + partialTick) / 6.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.getOpacity(0.5, partialTick)));
        guiGraphics.blit(LOG, (int)(-90.0f + rate * (float)(x + 90)), y, 0.0f, 0.0f, 90, 16, 90, 16);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x - (1.0f - rate) * 90.0f, (float)y, 0.0f);
        guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
        List wrapped = font.split((FormattedText)this.log, 150);
        int textY = wrapped.size() > 1 ? 7 : 12;
        for (FormattedCharSequence text : wrapped) {
            guiGraphics.drawString(font, text, 6, textY, this.getTextColor(partialTick));
            Objects.requireNonNull(font);
            textY += 9 + 1;
        }
        guiGraphics.pose().popPose();
    }

    private int getTextColor(float partialTick) {
        double opacity = this.getOpacity(1.0, partialTick);
        if (opacity == 0.0) {
            return 0;
        }
        int alpha = (int)Math.round(opacity * 255.0);
        return alpha << 24 | 0xFFFFFF;
    }

    private double getOpacity(double baseOpacity, float partialTick) {
        double opacity;
        double tick = (float)this.tick + partialTick;
        if (tick == 0.0) {
            return 0.0;
        }
        if (tick < 300.0) {
            opacity = baseOpacity;
        } else if (tick <= 310.0) {
            double fadeProgress = (tick - 300.0) / 10.0;
            opacity = baseOpacity * (1.0 - fadeProgress);
        } else {
            return 0.0;
        }
        opacity = Mth.clamp((double)opacity, (double)0.0, (double)1.0);
        return opacity;
    }

    public boolean tick() {
        return this.tick++ > 310;
    }
}

