/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.mixins;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.necro.raid.dens.common.util.IHealthSetter;
import com.necro.raid.dens.common.util.IShinyRate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Pokemon.class})
public abstract class PokemonMixin
implements IHealthSetter,
IShinyRate {
    @Unique
    private Integer maxHealthBuffer;
    @Unique
    private Float raidShinyRate;

    @Shadow(remap=false)
    public abstract void setCurrentHealth(int var1);

    @Override
    public void setMaxHealth(int maxHealth) {
        this.maxHealthBuffer = maxHealth;
        this.setCurrentHealth(maxHealth);
    }

    @Override
    public Float getRaidShinyRate() {
        return this.raidShinyRate;
    }

    @Override
    public void setRaidShinyRate(float raidShinyRate) {
        this.raidShinyRate = Float.valueOf(raidShinyRate);
    }

    @Inject(method={"getMaxHealth()I"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getMaxHealthInject(CallbackInfoReturnable<Integer> cir) {
        if (this.maxHealthBuffer != null) {
            cir.setReturnValue((Object)this.maxHealthBuffer);
        }
    }

    @Inject(method={"saveToNBT(Lnet/minecraft/core/RegistryAccess;Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="HEAD")}, remap=false)
    private void saveToNBTInject(RegistryAccess registryAccess, CompoundTag nbt, CallbackInfoReturnable<CompoundTag> cir) {
        if (this.maxHealthBuffer != null) {
            nbt.putInt("max_health_buffer", this.maxHealthBuffer.intValue());
        }
    }
}

