/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.IntSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.properties.CustomPokemonProperty;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.pokemon.abilities.HiddenAbility;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.compat.ModCompat;
import com.necro.raid.dens.common.compat.megashowdown.RaidDensMSDCompat;
import com.necro.raid.dens.common.raids.RaidFeature;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import com.necro.raid.dens.common.util.IHealthSetter;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IShinyRate;
import com.necro.raid.dens.common.util.RaidDenRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;

public class RaidBoss {
    private final PokemonProperties baseProperties;
    private Species displaySpecies;
    private Set<String> displayAspects;
    private final RaidTier raidTier;
    private final RaidFeature raidFeature;
    private final List<SpeciesFeature> raidForm;
    private final List<SpeciesFeature> baseForm;
    private final RaidType raidType;
    private final String lootTableId;
    private LootTable lootTable;
    private final double weight;
    private final boolean isCatchable;
    private final int healthMulti;
    private final float shinyRate;
    private final Map<String, String> script;
    private List<ResourceLocation> dens;
    private final List<String> densInner;
    private ResourceLocation id;

    public RaidBoss(PokemonProperties properties, RaidTier tier, RaidType raidType, RaidFeature raidFeature, List<SpeciesFeature> raidForm, List<SpeciesFeature> baseForm, String lootTableId, double weight, boolean isCatchable, int healthMulti, float shinyRate, Map<String, String> script, List<String> dens) {
        this.baseProperties = properties;
        this.raidTier = tier;
        this.raidType = raidType;
        this.raidFeature = raidFeature;
        this.raidForm = raidForm;
        this.baseForm = baseForm;
        this.lootTableId = lootTableId;
        this.weight = weight;
        this.isCatchable = isCatchable;
        this.healthMulti = healthMulti;
        this.shinyRate = shinyRate;
        this.script = script;
        this.dens = new ArrayList<ResourceLocation>();
        this.densInner = dens;
        this.id = null;
    }

    public PokemonEntity getBossEntity(ServerLevel level) {
        PokemonProperties properties = PokemonProperties.Companion.parse(this.baseProperties.asString(" ") + " aspect=raid uncatchable");
        if (properties.getShiny() == null) {
            properties.setShiny(Boolean.valueOf(false));
        }
        if (properties.getLevel() == null) {
            properties.setLevel(Integer.valueOf(this.raidTier.getLevel()));
        }
        Pokemon pokemon = properties.create();
        int healthMulti = this.healthMulti > 0 ? this.healthMulti : this.raidTier.getHealth();
        ((IHealthSetter)pokemon).setMaxHealth(healthMulti * pokemon.getMaxHealth());
        for (SpeciesFeature form : this.raidForm) {
            ((CustomPokemonProperty)form).apply(pokemon);
        }
        this.setMoveSet(properties, pokemon, true);
        PokemonEntity pokemonEntity = new PokemonEntity((Level)level, pokemon, CobblemonEntities.POKEMON);
        pokemonEntity.setNoAi(true);
        pokemonEntity.setInvulnerable(true);
        pokemonEntity.setDrops(new DropTable());
        if (this.isTera() && ModCompat.MEGA_SHOWDOWN.isLoaded()) {
            RaidDensMSDCompat.INSTANCE.setupTera(pokemonEntity, pokemon);
        } else if (this.isDynamax() && ModCompat.MEGA_SHOWDOWN.isLoaded()) {
            RaidDensMSDCompat.INSTANCE.setupDmax(pokemonEntity);
        }
        ((IRaidAccessor)pokemonEntity).setRaidBoss(this.id);
        float scale = Mth.clamp((float)(80.0f / pokemonEntity.getExposedSpecies().getHeight()), (float)1.0f, (float)5.0f);
        pokemonEntity.getPokemon().setScaleModifier(scale);
        pokemonEntity.refreshDimensions();
        return pokemonEntity;
    }

    public void createDisplayAspects() {
        Pokemon displayPokemon = this.baseProperties.create();
        displayPokemon.setShiny(this.shinyRate == 1.0f);
        for (SpeciesFeature form : this.raidForm) {
            ((CustomPokemonProperty)form).apply(displayPokemon);
        }
        this.displaySpecies = displayPokemon.getSpecies();
        this.displayAspects = displayPokemon.getAspects();
    }

    public Pokemon getRewardPokemon(ServerPlayer player) {
        PokemonProperties properties = this.baseProperties.copy();
        if (properties.getLevel() == null) {
            properties.setLevel(Integer.valueOf(this.raidTier.getRewardLevel()));
        }
        Pokemon pokemon = new Pokemon();
        properties.apply(pokemon);
        pokemon.initialize();
        ((IShinyRate)pokemon).setRaidShinyRate(this.shinyRate);
        properties.roll(pokemon, player);
        if (properties.getAbility() == null && player.getRandom().nextDouble() < CobblemonRaidDens.CONFIG.ha_rate) {
            pokemon.getForm().getAbilities().getMapping().values().forEach(abilities -> {
                List<HiddenAbility> hidden = abilities.stream().filter(a -> a instanceof HiddenAbility).map(a -> (HiddenAbility)a).toList();
                if (hidden.isEmpty()) {
                    return;
                }
                HiddenAbility chosen = hidden.get(player.getRandom().nextInt(hidden.size()));
                pokemon.setAbility$common(chosen.getTemplate().create(false, chosen.getPriority()));
            });
        }
        for (SpeciesFeature form2 : this.baseForm) {
            ((CustomPokemonProperty)form2).apply(pokemon);
        }
        if (this.isDynamax()) {
            pokemon.setDmaxLevel(Cobblemon.config.getMaxDynamaxLevel());
        }
        if (this.raidForm.stream().anyMatch(form -> {
            StringSpeciesFeature ssf;
            return form instanceof StringSpeciesFeature && (ssf = (StringSpeciesFeature)form).getValue().equals("gmax");
        })) {
            pokemon.setGmaxFactor(true);
        }
        this.setMoveSet(properties, pokemon, false);
        return pokemon;
    }

    private void setMoveSet(PokemonProperties properties, Pokemon pokemon, boolean isRaidBoss) {
        List moves = properties.getMoves();
        if (moves != null) {
            MoveSet moveSet = pokemon.getMoveSet();
            moveSet.clear();
            List<MoveTemplate> moveTemplates = moves.stream().map(arg_0 -> ((Moves)Moves.INSTANCE).getByName(arg_0)).toList();
            moveSet.doWithoutEmitting(() -> {
                for (int i = 0; i < moves.size(); ++i) {
                    MoveTemplate mt = (MoveTemplate)moveTemplates.get(i);
                    moveSet.setMove(i, mt.create());
                    Move move = moveSet.get(i);
                    assert (move != null);
                    if (isRaidBoss) {
                        move.setCurrentPp(99);
                        continue;
                    }
                    move.update();
                }
                return Unit.INSTANCE;
            });
            moveSet.update();
        }
    }

    public PokemonProperties getProperties() {
        return this.baseProperties;
    }

    public Species getDisplaySpecies() {
        return this.displaySpecies;
    }

    public Set<String> getDisplayAspects() {
        return this.displayAspects;
    }

    public RaidTier getTier() {
        return this.raidTier;
    }

    public RaidType getType() {
        return this.raidType;
    }

    public RaidFeature getFeature() {
        return this.raidFeature;
    }

    public List<SpeciesFeature> getRaidForm() {
        return this.raidForm;
    }

    public List<SpeciesFeature> getBaseForm() {
        return this.baseForm;
    }

    public String getLootTableId() {
        return this.lootTableId;
    }

    public List<ItemStack> getRandomRewards(ServerLevel level) {
        if (this.lootTable == null) {
            this.lootTable = level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)this.lootTableId)));
        }
        return this.lootTable.getRandomItems(new LootParams.Builder(level).create(LootContextParamSet.builder().build()));
    }

    public double getWeight() {
        return this.weight;
    }

    public boolean isCatchable() {
        return this.isCatchable;
    }

    public int getHealthMulti() {
        return this.healthMulti;
    }

    public float getShinyRate() {
        return this.shinyRate;
    }

    public Map<String, String> getScript() {
        return this.script;
    }

    public List<String> getDens() {
        return this.densInner;
    }

    public ResourceLocation getRandomDen(RandomSource random) {
        if (this.dens.isEmpty()) {
            this.resolveDens();
        }
        if (this.dens.size() == 1) {
            return this.dens.getFirst();
        }
        return this.dens.get(random.nextInt(this.dens.size()));
    }

    private void resolveDens() {
        ArrayList<ResourceLocation> validDens = new ArrayList<ResourceLocation>();
        for (String value : this.densInner) {
            if (value.startsWith("#")) {
                validDens.addAll(RaidDenRegistry.getStructures(ResourceLocation.parse((String)value.substring(1))));
                continue;
            }
            validDens.add(ResourceLocation.parse((String)value));
        }
        validDens.removeIf(RaidDenRegistry::isNotValidStructure);
        if (validDens.isEmpty()) {
            validDens.add(RaidDenRegistry.DEFAULT);
        }
        this.dens = validDens;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public boolean isMega() {
        return this.raidFeature == RaidFeature.MEGA;
    }

    public boolean isTera() {
        return this.raidFeature == RaidFeature.TERA;
    }

    public boolean isDynamax() {
        return this.raidFeature == RaidFeature.DYNAMAX;
    }

    public static String getGender(PokemonProperties properties) {
        if (properties.getGender() == null) {
            return "";
        }
        return properties.getGender().getSerializedName();
    }

    public static String getFormName(SpeciesFeature raidForm) {
        if (raidForm == null) {
            return "";
        }
        return raidForm.getName();
    }

    public static String getFormValue(StringSpeciesFeature raidForm) {
        if (raidForm == null) {
            return "";
        }
        return raidForm.getValue();
    }

    public static Boolean getFormValue(FlagSpeciesFeature raidForm) {
        if (raidForm == null) {
            return false;
        }
        return raidForm.getEnabled();
    }

    public static Integer getFormValue(IntSpeciesFeature raidForm) {
        if (raidForm == null) {
            return 0;
        }
        return raidForm.getValue();
    }

    public static Codec<PokemonProperties> propertiesCodec() {
        return RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("species").forGetter(PokemonProperties::getSpecies), (App)Codec.STRING.optionalFieldOf("gender", (Object)"").forGetter(RaidBoss::getGender), (App)Codec.STRING.optionalFieldOf("ability", (Object)"").forGetter(PokemonProperties::getAbility), (App)Codec.STRING.optionalFieldOf("nature", (Object)"").forGetter(PokemonProperties::getNature), (App)Codec.INT.optionalFieldOf("level", (Object)-1).forGetter(PokemonProperties::getLevel), (App)Codec.STRING.listOf().optionalFieldOf("moves", new ArrayList()).forGetter(PokemonProperties::getMoves)).apply((Applicative)inst, (species, gender, ability, nature, level, moves) -> {
            PokemonProperties properties = PokemonProperties.Companion.parse("");
            properties.setSpecies(species);
            try {
                if (!gender.isBlank()) {
                    properties.setGender(Gender.valueOf((String)gender));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!ability.isBlank()) {
                properties.setAbility(ability);
            }
            if (!nature.isBlank()) {
                properties.setNature(nature);
            }
            if (level > 0) {
                properties.setLevel(level);
            }
            if (!moves.isEmpty()) {
                properties.setMoves(moves);
            }
            return properties;
        }));
    }

    public static Codec<SpeciesFeature> raidFormCodec() {
        return RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("name").forGetter(RaidBoss::getFormName), (App)Codec.either((Codec)Codec.STRING, (Codec)Codec.either((Codec)Codec.BOOL, (Codec)Codec.INT)).fieldOf("value").forGetter(form -> {
            if (form instanceof StringSpeciesFeature) {
                return Either.left((Object)RaidBoss.getFormValue((StringSpeciesFeature)form));
            }
            if (form instanceof FlagSpeciesFeature) {
                return Either.right((Object)Either.left((Object)RaidBoss.getFormValue((FlagSpeciesFeature)form)));
            }
            return Either.right((Object)Either.right((Object)RaidBoss.getFormValue((IntSpeciesFeature)form)));
        })).apply((Applicative)inst, (name, either) -> {
            if (either.left().isPresent()) {
                return new StringSpeciesFeature(name, (String)either.left().get());
            }
            assert (either.right().isPresent());
            Either inner = (Either)either.right().get();
            if (inner.left().isPresent()) {
                return new FlagSpeciesFeature(name, ((Boolean)inner.left().get()).booleanValue());
            }
            assert (inner.right().isPresent());
            return new IntSpeciesFeature(name, ((Integer)inner.right().get()).intValue());
        }));
    }

    public static Codec<RaidBoss> codec() {
        return RecordCodecBuilder.create(inst -> inst.group((App)RaidBoss.propertiesCodec().fieldOf("pokemon").forGetter(RaidBoss::getProperties), (App)RaidTier.codec().fieldOf("raid_tier").forGetter(RaidBoss::getTier), (App)RaidType.codec().fieldOf("raid_type").forGetter(RaidBoss::getType), (App)RaidFeature.codec().optionalFieldOf("raid_feature", (Object)RaidFeature.DEFAULT).forGetter(RaidBoss::getFeature), (App)RaidBoss.raidFormCodec().listOf().optionalFieldOf("raid_form", new ArrayList()).forGetter(RaidBoss::getRaidForm), (App)RaidBoss.raidFormCodec().listOf().optionalFieldOf("base_form", new ArrayList()).forGetter(RaidBoss::getBaseForm), (App)Codec.STRING.optionalFieldOf("loot_table", (Object)"").forGetter(RaidBoss::getLootTableId), (App)Codec.DOUBLE.optionalFieldOf("weight", (Object)20.0).forGetter(RaidBoss::getWeight), (App)Codec.BOOL.optionalFieldOf("is_catchable", (Object)true).forGetter(RaidBoss::isCatchable), (App)Codec.INT.optionalFieldOf("health_multi", (Object)0).forGetter(RaidBoss::getHealthMulti), (App)Codec.FLOAT.optionalFieldOf("shiny_rate", (Object)Float.valueOf(CobblemonRaidDens.CONFIG.shiny_rate)).forGetter(RaidBoss::getShinyRate), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("script", new HashMap()).forGetter(RaidBoss::getScript), (App)Codec.STRING.listOf().optionalFieldOf("den", List.of("#cobblemonraiddens:default")).forGetter(RaidBoss::getDens)).apply((Applicative)inst, (properties, tier, type, feature, raidForm, baseForm, bonusItems, weight, isCatchable, healthMulti, shinyRate, script, dens) -> {
            properties.setTeraType(type.getSerializedName());
            properties.setIvs(IVs.createRandomIVs((int)tier.getMaxIvs()));
            if (shinyRate.floatValue() == 1.0f) {
                properties.setShiny(Boolean.valueOf(true));
            } else if (shinyRate.floatValue() == 0.0f) {
                properties.setShiny(Boolean.valueOf(false));
            }
            raidForm = new ArrayList<SpeciesFeature>((Collection<SpeciesFeature>)raidForm);
            raidForm.addAll(baseForm);
            if (feature == RaidFeature.DYNAMAX && raidForm.stream().noneMatch(form -> form.getName().equals("dynamax_form"))) {
                raidForm.add((SpeciesFeature)new StringSpeciesFeature("dynamax_form", "none"));
            } else if (feature == RaidFeature.MEGA && raidForm.stream().noneMatch(form -> form.getName().equals("mega_evolution"))) {
                raidForm.add((SpeciesFeature)new StringSpeciesFeature("mega_evolution", "mega"));
            }
            return new RaidBoss((PokemonProperties)properties, (RaidTier)((Object)((Object)tier)), (RaidType)((Object)((Object)type)), (RaidFeature)((Object)((Object)feature)), (List<SpeciesFeature>)raidForm, (List<SpeciesFeature>)baseForm, (String)bonusItems, (double)weight, (boolean)isCatchable, (int)healthMulti, shinyRate.floatValue(), (Map<String, String>)script, (List<String>)dens);
        }));
    }
}

