/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.mojang.serialization.Codec;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.util.DoubleWeightedRandomMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public enum RaidTier implements StringRepresentable
{
    TIER_ONE("tier_one", RaidTier.initHealth(0), RaidTier.initIvs(0), RaidTier.initLevel(0), RaidTier.initRewardLevel(0)),
    TIER_TWO("tier_two", RaidTier.initHealth(1), RaidTier.initIvs(1), RaidTier.initLevel(1), RaidTier.initRewardLevel(1)),
    TIER_THREE("tier_three", RaidTier.initHealth(2), RaidTier.initIvs(2), RaidTier.initLevel(2), RaidTier.initRewardLevel(2)),
    TIER_FOUR("tier_four", RaidTier.initHealth(3), RaidTier.initIvs(3), RaidTier.initLevel(3), RaidTier.initRewardLevel(3)),
    TIER_FIVE("tier_five", RaidTier.initHealth(4), RaidTier.initIvs(4), RaidTier.initLevel(4), RaidTier.initRewardLevel(4)),
    TIER_SIX("tier_six", RaidTier.initHealth(5), RaidTier.initIvs(5), RaidTier.initLevel(5), RaidTier.initRewardLevel(5)),
    TIER_SEVEN("tier_seven", RaidTier.initHealth(6), RaidTier.initIvs(6), RaidTier.initLevel(6), RaidTier.initRewardLevel(6));

    private final String id;
    private final int health;
    private final int maxIvs;
    private final int level;
    private final int rewardLevel;
    private boolean isPresent;
    private static final Map<String, DoubleWeightedRandomMap<RaidTier>> RANDOM_MAP;

    private RaidTier(String id, int health, int maxIvs, int level, int rewardLevel) {
        this.id = id;
        this.health = health;
        this.maxIvs = maxIvs;
        this.level = level;
        this.rewardLevel = rewardLevel;
        this.isPresent = false;
    }

    public String getLootTableId() {
        return "raid/tier/" + this.id;
    }

    public int getHealth() {
        return this.health;
    }

    public int getMaxIvs() {
        return this.maxIvs;
    }

    public int getLevel() {
        return this.level;
    }

    public int getRewardLevel() {
        return this.rewardLevel;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void setPresent() {
        this.isPresent = true;
    }

    public void setPresent(boolean isPresent) {
        this.isPresent = isPresent;
    }

    public String getStars() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "\u2605";
            case 1 -> "\u2605\u2605";
            case 2 -> "\u2605\u2605\u2605";
            case 3 -> "\u2605\u2605\u2605\u2605";
            case 4 -> "\u2605\u2605\u2605\u2605\u2605";
            case 5 -> "\u2605\u2605\u2605\u2605\u2605\u2605";
            case 6 -> "\u2605\u2605\u2605\u2605\u2605\u2605\u2605";
        };
    }

    @NotNull
    public String getSerializedName() {
        return this.id;
    }

    public static void updateRandom() {
        RANDOM_MAP.clear();
        for (Map.Entry<String, double[]> entry : CobblemonRaidDens.CONFIG.dimension_tier_weights.entrySet()) {
            RaidTier.addWeightedMap(entry.getKey(), entry.getValue());
        }
        if (!RANDOM_MAP.containsKey("minecraft:overworld")) {
            double[] weights = !CobblemonRaidDens.CONFIG.dimension_tier_weights.isEmpty() ? CobblemonRaidDens.CONFIG.dimension_tier_weights.values().iterator().next() : new double[]{9.0, 15.0, 25.0, 25.0, 20.0, 5.0, 1.0};
            RaidTier.addWeightedMap("minecraft:overworld", weights);
        }
    }

    private static void addWeightedMap(String dimension, double[] tierWeights) {
        DoubleWeightedRandomMap<RaidTier> weightedMap = new DoubleWeightedRandomMap<RaidTier>();
        ArrayList<Double> weights = new ArrayList<Double>(Arrays.stream(tierWeights).boxed().toList());
        while (weights.size() < RaidTier.values().length) {
            weights.add(tierWeights[tierWeights.length - 1]);
        }
        for (int i = 0; i < weights.size(); ++i) {
            RaidTier tier = RaidTier.values()[i];
            if (!tier.isPresent()) continue;
            weightedMap.add(RaidTier.values()[i], (Double)weights.get(i));
        }
        RANDOM_MAP.put(dimension, weightedMap);
    }

    public static RaidTier getWeightedRandom(RandomSource random, String dimension) {
        if (RANDOM_MAP.isEmpty()) {
            RaidTier.updateRandom();
        }
        if (RANDOM_MAP.isEmpty()) {
            return TIER_ONE;
        }
        if (!RANDOM_MAP.containsKey(dimension)) {
            dimension = "minecraft:overworld";
        }
        Optional<RaidTier> raidTier = RANDOM_MAP.get(dimension).getRandom(random);
        return raidTier.orElse(TIER_ONE);
    }

    public static RaidTier getWeightedRandom(RandomSource random, Level level) {
        String levelKey = level.dimension().location().toString();
        return RaidTier.getWeightedRandom(random, levelKey);
    }

    public double getWeight(Level level) {
        String levelKey = level.dimension().location().toString();
        if (!RANDOM_MAP.containsKey(levelKey)) {
            levelKey = "minecraft:overworld";
        }
        return RANDOM_MAP.get(levelKey).getWeight(this);
    }

    public static int initHealth(int index) {
        index = Math.min(index, CobblemonRaidDens.CONFIG.tier_health_multiplier.length - 1);
        return CobblemonRaidDens.CONFIG.tier_health_multiplier[index];
    }

    public static int initIvs(int index) {
        index = Math.min(index, CobblemonRaidDens.CONFIG.tier_ivs.length - 1);
        return CobblemonRaidDens.CONFIG.tier_ivs[index];
    }

    public static int initLevel(int index) {
        index = Math.min(index, CobblemonRaidDens.CONFIG.tier_level.length - 1);
        return CobblemonRaidDens.CONFIG.tier_level[index];
    }

    public static int initRewardLevel(int index) {
        index = Math.min(index, CobblemonRaidDens.CONFIG.tier_reward_level.length - 1);
        return CobblemonRaidDens.CONFIG.tier_reward_level[index];
    }

    public static RaidTier fromString(String name) {
        try {
            return RaidTier.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Codec<RaidTier> codec() {
        return Codec.STRING.xmap(RaidTier::fromString, Enum::name);
    }

    static {
        RANDOM_MAP = new HashMap<String, DoubleWeightedRandomMap<RaidTier>>();
    }
}

