/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.showdown;

import com.bedrockk.molang.runtime.MoLangRuntime;
import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.moves.animations.ActionEffectContext;
import com.cobblemon.mod.common.api.moves.animations.ActionEffectTimeline;
import com.cobblemon.mod.common.api.moves.animations.ActionEffects;
import com.cobblemon.mod.common.api.moves.animations.UsersProvider;
import com.cobblemon.mod.common.battles.ShowdownInterpreter;
import com.cobblemon.mod.common.battles.dispatch.ActionEffectInstruction;
import com.cobblemon.mod.common.battles.dispatch.DispatchResultKt;
import com.cobblemon.mod.common.battles.dispatch.UntilDispatch;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Unit;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class ResetBossInstruction
implements ActionEffectInstruction {
    private final BattleMessage message;
    private CompletableFuture<?> future;
    private Set<String> holds;
    private final BattlePokemon pokemon;
    private final BattlePokemon origin;

    public ResetBossInstruction(PokemonBattle battle, BattleMessage message) {
        this.message = message;
        this.future = CompletableFuture.completedFuture(Unit.INSTANCE);
        this.holds = new HashSet<String>();
        this.pokemon = this.message.battlePokemon(0, battle);
        this.origin = this.message.pokemonByUuid(1, battle);
    }

    @NotNull
    public CompletableFuture<?> getFuture() {
        return this.future;
    }

    public void setFuture(@NotNull CompletableFuture<?> future) {
        this.future = future;
    }

    @NotNull
    public Set<String> getHolds() {
        return this.holds;
    }

    public void setHolds(@NotNull Set<String> set) {
        this.holds = set;
    }

    @NotNull
    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"reset_boss");
    }

    public void preActionEffect(@NotNull PokemonBattle battle) {
    }

    public void runActionEffect(@NotNull PokemonBattle battle, @NotNull MoLangRuntime runtime) {
        if (this.pokemon == null || this.origin == null) {
            return;
        }
        battle.dispatch(() -> {
            ActionEffectTimeline actionEffect = (ActionEffectTimeline)ActionEffects.INSTANCE.getActionEffects().get(MiscUtilsKt.cobblemonResource((String)"boost"));
            ArrayList<PokemonBattle> providers = new ArrayList<PokemonBattle>(List.of(battle));
            providers.add((PokemonBattle)new UsersProvider(new Entity[]{this.pokemon.getEffectedPokemon().getEntity()}));
            ActionEffectContext context = new ActionEffectContext(actionEffect, new HashSet(), providers, runtime, false, false, new ArrayList(), ((ServerPlayer)battle.getPlayers().getFirst()).level());
            this.setFuture(actionEffect.run(context));
            this.setHolds(context.getHolds());
            this.future.thenAccept(v -> this.holds.clear());
            return DispatchResultKt.getGO();
        });
    }

    public void postActionEffect(@NotNull PokemonBattle battle) {
        if (this.pokemon == null || this.origin == null) {
            return;
        }
        battle.dispatch(() -> {
            battle.broadcastChatMessage((Component)Component.translatable((String)"battle.cobblemonraiddens.reset.boss", (Object[])new Object[]{this.origin.getName()}));
            BattleContext.Type boostBucket = BattleContext.Type.BOOST;
            BattleContext context = ShowdownInterpreter.INSTANCE.getContextFromAction(this.message, boostBucket, battle);
            this.pokemon.getContextManager().add(new BattleContext[]{context});
            battle.getMinorBattleActions().put(this.pokemon.getUuid(), this.message);
            return new UntilDispatch(() -> !this.holds.contains("effects"));
        });
    }

    public void addMolangQueries(@NotNull MoLangRuntime runtime) {
        ActionEffectInstruction.DefaultImpls.addMolangQueries((ActionEffectInstruction)this, (MoLangRuntime)runtime);
    }

    public void invoke(@NotNull PokemonBattle battle) {
        ActionEffectInstruction.DefaultImpls.invoke((ActionEffectInstruction)this, (PokemonBattle)battle);
    }
}

