/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.drops.LootDroppedEvent;
import com.cobblemon.mod.common.api.events.pokemon.ShinyChanceCalculationEvent;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.necro.raid.dens.common.advancements.RaidDenCriteriaTriggers;
import com.necro.raid.dens.common.config.ClientConfig;
import com.necro.raid.dens.common.config.MoveConfig;
import com.necro.raid.dens.common.config.RaidConfig;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.statistics.RaidStatistics;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IShinyRate;
import com.necro.raid.dens.common.util.RaidUtils;
import java.util.UUID;
import kotlin.Unit;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.class_1309;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobblemonRaidDens {
    public static final String MOD_ID = "cobblemonraiddens";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cobblemonraiddens");
    public static RaidConfig CONFIG;
    public static ClientConfig CLIENT_CONFIG;
    public static MoveConfig MOVE_CONFIG;

    public static void init() {
        LOGGER.info("Initialising {}", (Object)MOD_ID);
        AutoConfig.register(RaidConfig.class, JanksonConfigSerializer::new);
        CONFIG = (RaidConfig)AutoConfig.getConfigHolder(RaidConfig.class).getConfig();
        AutoConfig.register(ClientConfig.class, JanksonConfigSerializer::new);
        CLIENT_CONFIG = (ClientConfig)AutoConfig.getConfigHolder(ClientConfig.class).getConfig();
        AutoConfig.register(MoveConfig.class, JanksonConfigSerializer::new);
        MOVE_CONFIG = (MoveConfig)AutoConfig.getConfigHolder(MoveConfig.class).getConfig();
        RaidUtils.init();
        RaidStatistics.init();
        RaidDenCriteriaTriggers.init();
        CobblemonEvents.BATTLE_FLED.subscribe(Priority.NORMAL, event -> {
            CobblemonRaidDens.raidFailEvent(event.getBattle());
            return Unit.INSTANCE;
        });
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.NORMAL, event -> {
            BattlePokemon battlePokemon = ((ActiveBattlePokemon)((BattleActor)event.getLosers().getFirst()).getActivePokemon().getFirst()).getBattlePokemon();
            if (battlePokemon != null && battlePokemon.getEffectedPokemon().getOwnerPlayer() != null) {
                return Unit.INSTANCE;
            }
            CobblemonRaidDens.raidFailEvent(event.getBattle());
            return Unit.INSTANCE;
        });
        CobblemonEvents.LOOT_DROPPED.subscribe(Priority.HIGHEST, event -> {
            CobblemonRaidDens.cancelLootDrops(event);
            return Unit.INSTANCE;
        });
        CobblemonEvents.SHINY_CHANCE_CALCULATION.subscribe(Priority.HIGHEST, event -> {
            CobblemonRaidDens.setRaidShinyRate(event);
            return Unit.INSTANCE;
        });
    }

    private static void raidFailEvent(PokemonBattle battle) {
        try {
            UUID battleId = ((IRaidAccessor)((ActiveBattlePokemon)battle.getSide2().getActivePokemon().getFirst()).getBattlePokemon().getEntity()).getRaidId();
            if (RaidHelper.ACTIVE_RAIDS.containsKey(battleId)) {
                RaidInstance raidInstance = RaidHelper.ACTIVE_RAIDS.get(battleId);
                raidInstance.removePlayer(battle);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static void cancelLootDrops(LootDroppedEvent event) {
        class_1309 class_13092 = event.getEntity();
        if (!(class_13092 instanceof PokemonEntity)) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)class_13092;
        if (!((IRaidAccessor)pokemonEntity).isRaidBoss()) {
            return;
        }
        event.cancel();
    }

    private static void setRaidShinyRate(ShinyChanceCalculationEvent event) {
        event.addModificationFunction((chance, player, pokemon) -> {
            Float shinyRate = ((IShinyRate)pokemon).getRaidShinyRate();
            return shinyRate == null || shinyRate.floatValue() < 0.0f ? chance : shinyRate;
        });
    }
}

