/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.blocks.block;

import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.dimensions.DimensionHelper;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.events.RaidJoinEvent;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidCycleMode;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_9062;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RaidCrystalBlock
extends class_2237 {
    public static final class_2754<RaidType> RAID_TYPE = class_2754.method_11850((String)"raid_type", RaidType.class);
    public static final class_2754<RaidTier> RAID_TIER = class_2754.method_11850((String)"raid_tier", RaidTier.class);
    public static final class_2746 ACTIVE = class_2746.method_11825((String)"is_active");
    public static final class_2746 CAN_RESET = class_2746.method_11825((String)"can_reset");
    public static final class_2754<RaidCycleMode> CYCLE_MODE = class_2754.method_11850((String)"cycle_mode", RaidCycleMode.class);

    public RaidCrystalBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false))).method_11657(RAID_TYPE, (Comparable)((Object)RaidType.NONE))).method_11657(RAID_TIER, (Comparable)((Object)RaidTier.TIER_ONE))).method_11657((class_2769)CAN_RESET, (Comparable)Boolean.valueOf(false))).method_11657(CYCLE_MODE, (Comparable)((Object)RaidCycleMode.NONE)));
    }

    @NotNull
    protected class_1269 method_55766(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 blockHitResult) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        Boolean success = this.startOrJoinRaid(player, blockState, (RaidCrystalBlockEntity)level.method_8321(blockPos), null);
        if (success == null || success.booleanValue()) {
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    @NotNull
    protected class_9062 method_55765(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (CobblemonRaidDens.CONFIG.requires_key && !RaidUtils.isRaidDenKey(itemStack)) {
            return class_9062.field_47733;
        }
        if (level.method_8608()) {
            return class_9062.field_47728;
        }
        if (!CobblemonRaidDens.CONFIG.requires_key) {
            return class_9062.field_47731;
        }
        Boolean success = this.startOrJoinRaid(player, blockState, (RaidCrystalBlockEntity)level.method_8321(blockPos), itemStack);
        if (success == null) {
            return class_9062.field_47728;
        }
        if (success.booleanValue()) {
            itemStack.method_57008(1, (class_1309)player);
        } else {
            player.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.no_key"));
        }
        return success != false ? class_9062.field_47729 : class_9062.field_47733;
    }

    private Boolean startOrJoinRaid(class_1657 player, class_2680 blockState, RaidCrystalBlockEntity blockEntity, @Nullable class_1799 key) {
        if (blockEntity.isBusy() || player.method_5682() == null) {
            return false;
        }
        if (!blockEntity.isActive(blockState) || blockEntity.isAtMaxClears()) {
            player.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.is_not_active"));
            return false;
        }
        if (RaidHelper.hasClearedRaid(blockEntity.getUuid(), player)) {
            player.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.player_cleared"));
            return false;
        }
        if (blockEntity.hasDimension() && blockEntity.isPlayerParticipating(player)) {
            RaidUtils.teleportPlayerToRaid((class_3222)player, blockEntity);
            return null;
        }
        if (RaidHelper.isAlreadyHosting(player)) {
            player.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.already_hosting"));
            return false;
        }
        if (RaidHelper.isAlreadyParticipating(player)) {
            player.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.already_participating"));
            return false;
        }
        if (blockEntity.canSetRaidHost()) {
            boolean success = this.startRaid(player, blockEntity);
            if (!success) {
                blockEntity.clearRaidHost();
            }
            return success;
        }
        if (blockEntity.isFull()) {
            player.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.lobby_is_full"));
            return false;
        }
        if (RaidHelper.isInQueue(player)) {
            player.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.already_in_queue"));
            return false;
        }
        return this.requestJoinRaid(player, blockEntity, key);
    }

    private boolean requestJoinRaid(class_1657 player, RaidCrystalBlockEntity blockEntity, @Nullable class_1799 key) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return false;
        }
        class_3222 raidHost = server.method_3760().method_14602(blockEntity.getRaidHost());
        if (raidHost == null) {
            player.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.no_host"));
            return false;
        }
        RaidHelper.addToQueue(player, key);
        RaidHelper.addRequest(raidHost, player, blockEntity);
        RaidDenNetworkMessages.REQUEST_PACKET.accept(raidHost, player.method_5477().getString());
        return true;
    }

    private boolean startRaid(class_1657 player, RaidCrystalBlockEntity blockEntity) {
        class_3218 level;
        if (blockEntity.method_10997() == null || player.method_5682() == null) {
            return false;
        }
        class_5321<class_1937> resourceKey = ModDimensions.createLevelKey(player.method_5845());
        if (DimensionHelper.isLevelRemovedOrPending(resourceKey)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.cobblemonraiddens.raid.pending_removal").method_27692(class_124.field_1061));
            return false;
        }
        blockEntity.setRaidHost(player);
        boolean success = RaidEvents.RAID_JOIN.postWithResult(new RaidJoinEvent((class_3222)player, true, blockEntity.getRaidBoss()));
        if (!success) {
            return false;
        }
        try {
            level = this.getOrCreateDimension(blockEntity);
        }
        catch (Exception e) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.cobblemonraiddens.raid.already_hosting").method_27692(class_124.field_1061));
            return false;
        }
        blockEntity.setDimension(level);
        if (!blockEntity.spawnRaidBoss()) {
            blockEntity.setQueueClose();
            player.method_43496((class_2561)class_2561.method_43471((String)"message.cobblemonraiddens.raid.boss_spawn_failed").method_27692(class_124.field_1061));
            return false;
        }
        RaidHelper.addHost(player);
        blockEntity.method_10997().method_8500(blockEntity.method_11016()).method_12008(true);
        RaidUtils.teleportPlayerToRaid((class_3222)player, blockEntity);
        return true;
    }

    private class_3218 getOrCreateDimension(RaidCrystalBlockEntity blockEntity) {
        return blockEntity.getDimension() != null ? blockEntity.getDimension() : this.createDimension(blockEntity);
    }

    protected abstract class_3218 createDimension(RaidCrystalBlockEntity var1);

    protected void method_9536(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        class_2586 class_25862;
        if (!level.method_8608() && (class_25862 = level.method_8321(blockPos)) instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity blockEntity = (RaidCrystalBlockEntity)class_25862;
            blockEntity.closeRaid(blockPos);
            RaidHelper.resetClearedRaids(blockEntity.getUuid());
        }
        super.method_9536(blockState, level, blockPos, blockState2, bl);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{RAID_TYPE});
        builder.method_11667(new class_2769[]{RAID_TIER});
        builder.method_11667(new class_2769[]{ACTIVE});
        builder.method_11667(new class_2769[]{CAN_RESET});
        builder.method_11667(new class_2769[]{CYCLE_MODE});
    }

    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return null;
    }

    @NotNull
    protected class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11456;
    }

    protected boolean method_9516(class_2680 blockState, class_10 pathComputationType) {
        return false;
    }
}

