/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.client;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.pokemon.Gender;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidFeature;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ClientRaidBoss {
    private static Optional<String> getGender(PokemonProperties properties) {
        Gender gender = properties.getGender();
        if (gender == null) {
            return Optional.empty();
        }
        return Optional.of(gender.method_15434());
    }

    private static Optional<RaidFeature> getFeature(RaidBoss raidBoss) {
        return Optional.ofNullable(raidBoss.getFeature());
    }

    private static Optional<List<SpeciesFeature>> getRaidForm(RaidBoss raidBoss) {
        return Optional.ofNullable(raidBoss.getRaidForm());
    }

    private static Optional<List<SpeciesFeature>> getBaseForm(RaidBoss raidBoss) {
        return Optional.ofNullable(raidBoss.getBaseForm());
    }

    private static Optional<Float> getShinyRate(RaidBoss raidBoss) {
        return Optional.of(Float.valueOf(raidBoss.getShinyRate()));
    }

    private static Codec<PokemonProperties> propertiesCodec() {
        return RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("species").forGetter(PokemonProperties::getSpecies), (App)Codec.STRING.optionalFieldOf("gender").forGetter(ClientRaidBoss::getGender)).apply((Applicative)inst, (species, gender) -> {
            PokemonProperties properties = PokemonProperties.Companion.parse("");
            properties.setSpecies(species);
            try {
                gender.ifPresent(s -> properties.setGender(Gender.valueOf((String)s)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return properties;
        }));
    }

    public static Codec<RaidBoss> codec() {
        return RecordCodecBuilder.create(inst -> inst.group((App)ClientRaidBoss.propertiesCodec().fieldOf("pokemon").forGetter(RaidBoss::getProperties), (App)RaidTier.codec().fieldOf("raid_tier").forGetter(RaidBoss::getTier), (App)RaidType.codec().fieldOf("raid_type").forGetter(RaidBoss::getType), (App)RaidFeature.codec().optionalFieldOf("raid_feature").forGetter(ClientRaidBoss::getFeature), (App)RaidBoss.raidFormCodec().listOf().optionalFieldOf("raid_form").forGetter(ClientRaidBoss::getRaidForm), (App)RaidBoss.raidFormCodec().listOf().optionalFieldOf("base_form").forGetter(ClientRaidBoss::getBaseForm), (App)Codec.FLOAT.optionalFieldOf("shiny_rate").forGetter(ClientRaidBoss::getShinyRate)).apply((Applicative)inst, (properties, tier, type, oFeature, oRaidForm, oBaseForm, oShinyRate) -> {
            if (oShinyRate.isEmpty()) {
                properties.setShiny(Boolean.valueOf(false));
            } else if (((Float)oShinyRate.get()).floatValue() == 1.0f) {
                properties.setShiny(Boolean.valueOf(true));
            }
            ArrayList<SpeciesFeature> raidForm = new ArrayList<SpeciesFeature>();
            oRaidForm.ifPresent(raidForm::addAll);
            oBaseForm.ifPresent(raidForm::addAll);
            oFeature.ifPresent(feature -> {
                if (feature == RaidFeature.DYNAMAX && raidForm.stream().noneMatch(form -> form.getName().equals("dynamax_form"))) {
                    raidForm.add((SpeciesFeature)new StringSpeciesFeature("dynamax_form", "none"));
                } else if (feature == RaidFeature.MEGA && raidForm.stream().noneMatch(form -> form.getName().equals("mega_evolution"))) {
                    raidForm.add((SpeciesFeature)new StringSpeciesFeature("mega_evolution", "mega"));
                }
            });
            return new RaidBoss((PokemonProperties)properties, (RaidTier)((Object)((Object)tier)), (RaidType)((Object)((Object)type)), oFeature.orElse(RaidFeature.DEFAULT), (List<SpeciesFeature>)raidForm, (List<SpeciesFeature>)new ArrayList<SpeciesFeature>(), null, 0.0, false, 0, oShinyRate.orElse(Float.valueOf(0.0f)).floatValue(), (Map<String, String>)new HashMap<String, String>(), (List<String>)new ArrayList<String>());
        }));
    }
}

