/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.dimensions;

import com.google.common.collect.Maps;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.compat.ModCompat;
import com.necro.raid.dens.common.compat.distanthorizons.RaidDensDistantHorizonsCompat;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.mixins.MinecraftServerAccessor;
import com.necro.raid.dens.common.mixins.ServerLevelAccessor;
import com.necro.raid.dens.common.util.ILevelsSetter;
import com.necro.raid.dens.common.util.IRegistryRemover;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2370;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.util.TriConsumer;

public class DimensionHelper {
    public static TriConsumer<MinecraftServer, class_5321<class_1937>, Boolean> SYNC_DIMENSIONS;
    private static final Set<PendingDimension> QUEUED_FOR_REMOVAL;
    private static final Set<class_5321<class_1937>> REMOVED_LEVELS;

    public static void queueForRemoval(class_5321<class_1937> key, class_3218 level) {
        QUEUED_FOR_REMOVAL.add(new PendingDimension(key, level));
    }

    public static void removePending(MinecraftServer server) {
        if (QUEUED_FOR_REMOVAL.isEmpty()) {
            return;
        }
        Map<class_5321<class_1937>, class_3218> levels = ((MinecraftServerAccessor)server).getLevels();
        LinkedHashMap newLevels = Maps.newLinkedHashMap();
        for (Map.Entry<class_5321<class_1937>, class_3218> entry : levels.entrySet()) {
            if (QUEUED_FOR_REMOVAL.stream().anyMatch(pd -> pd.levelKey == entry.getKey())) continue;
            newLevels.put(entry.getKey(), entry.getValue());
        }
        ((ILevelsSetter)server).setLevels(newLevels);
        QUEUED_FOR_REMOVAL.forEach(pd -> {
            REMOVED_LEVELS.add((class_5321<class_1937>)pd.level.method_27983());
            if (!pd.isRunning) {
                pd.saveAndCLose(server);
            }
        });
        QUEUED_FOR_REMOVAL.clear();
    }

    public static boolean isLevelRemovedOrPending(class_3218 level) {
        return DimensionHelper.isLevelRemovedOrPending((class_5321<class_1937>)level.method_27983());
    }

    public static boolean isLevelRemovedOrPending(class_5321<class_1937> level) {
        return REMOVED_LEVELS.contains(level);
    }

    static {
        QUEUED_FOR_REMOVAL = new HashSet<PendingDimension>();
        REMOVED_LEVELS = new HashSet<class_5321<class_1937>>();
    }

    private static class PendingDimension {
        private final class_5321<class_1937> levelKey;
        private final class_3218 level;
        private boolean isRunning;

        PendingDimension(class_5321<class_1937> levelKey, class_3218 level) {
            this.levelKey = levelKey;
            this.level = level;
            this.isRunning = false;
        }

        void saveAndCLose(MinecraftServer server) {
            this.isRunning = true;
            try {
                ((ServerLevelAccessor)this.level).getEntityManager().close();
                this.level.method_14178().method_17293().close();
                this.level.method_14178().field_17254.close();
                if (ModCompat.DISTANT_HORIZONS.isLoaded()) {
                    CompletableFuture.runAsync(() -> RaidDensDistantHorizonsCompat.INSTANCE.unloadLevel(this.level), class_156.method_18349()).thenRun(() -> server.method_20493(() -> this.unregisterAndDelete(server)));
                } else {
                    server.method_20493(() -> this.unregisterAndDelete(server));
                }
            }
            catch (Throwable e) {
                CobblemonRaidDens.LOGGER.error("Error while closing dimension: ", e);
            }
        }

        private void unregisterAndDelete(MinecraftServer server) {
            class_2370 levelStemRegistry = (class_2370)server.method_30611().method_30530(class_7924.field_41224);
            class_5321 resourceKey = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)ModDimensions.createLevelKey(this.levelKey.method_29177().method_12832()).method_29177());
            ((IRegistryRemover)levelStemRegistry).getById().removeIf(holder -> holder.method_40225(resourceKey));
            ((IRegistryRemover)levelStemRegistry).removeDimension(this.levelKey.method_29177());
            ((ILevelsSetter)server).deleteLevel(this.levelKey);
            CompletableFuture.delayedExecutor(3L, TimeUnit.SECONDS).execute(() -> REMOVED_LEVELS.remove(this.level.method_27983()));
        }
    }
}

