/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.items.item;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.item.battle.SimpleBagItemLike;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.showdown.CheerBagItem;
import com.necro.raid.dens.common.util.IRaidAccessor;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheerItem
extends class_1792
implements SimpleBagItemLike {
    private final CheerBagItem.CheerType cheerType;
    private final BagItem bagItem;

    private CheerItem(CheerBagItem.CheerType cheerType, BagItem bagItem) {
        super(new class_1792.class_1793().method_7894(class_1814.field_8903));
        this.cheerType = cheerType;
        this.bagItem = bagItem;
    }

    public CheerItem(CheerBagItem.CheerType cheerType, int data) {
        this(cheerType, new CheerBagItem(cheerType, data));
    }

    public CheerItem(CheerBagItem.CheerType cheerType, double data) {
        this(cheerType, new CheerBagItem(cheerType, data));
    }

    @NotNull
    public BagItem getBagItem() {
        return this.bagItem;
    }

    @Nullable
    public BagItem getBagItem(@NotNull class_1799 stack) {
        return SimpleBagItemLike.DefaultImpls.getBagItem((SimpleBagItemLike)this, (class_1799)stack);
    }

    public boolean handleInteraction(@NotNull class_3222 player, @NotNull BattlePokemon battlePokemon, @NotNull class_1799 stack) {
        PokemonBattle battle = battlePokemon.getActor().getBattle();
        BattlePokemon raidPokemon = ((ActiveBattlePokemon)battle.getSide2().getActivePokemon().getFirst()).getBattlePokemon();
        if (raidPokemon == null || raidPokemon.getEntity() == null || !((IRaidAccessor)raidPokemon.getEntity()).isRaidBoss()) {
            return false;
        }
        BagItem bagItem = this.getBagItem(stack);
        if (bagItem == null) {
            return false;
        }
        if (!battlePokemon.getActor().canFitForcedAction()) {
            player.method_43496((class_2561)LocalizationUtilsKt.battleLang((String)"bagitem.cannot", (Object[])new Object[0]).method_27692(class_124.field_1061));
            return false;
        }
        if (!bagItem.canUse(battle, battlePokemon)) {
            player.method_43496((class_2561)LocalizationUtilsKt.battleLang((String)"bagitem.invalid", (Object[])new Object[0]).method_27692(class_124.field_1061));
            return false;
        }
        UUID raidId = ((IRaidAccessor)raidPokemon.getEntity()).getRaidId();
        String data = player.method_5477().getString();
        RaidInstance raid = RaidHelper.ACTIVE_RAIDS.get(raidId);
        if (!raid.runCheer(player, battle, this.getBagItem(), data)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"battle.cobblemonraiddens.cheer.cannot").method_27692(class_124.field_1061));
            return false;
        }
        return true;
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (!level.method_8608()) {
            PokemonBattle battle = BattleRegistry.INSTANCE.getBattleByParticipatingPlayer((class_3222)player);
            if (battle == null) {
                return class_1271.method_22431((Object)itemStack);
            }
            BattlePokemon battlePokemon = ((ActiveBattlePokemon)battle.getSide1().getActivePokemon().getFirst()).getBattlePokemon();
            BattlePokemon raidPokemon = ((ActiveBattlePokemon)battle.getSide2().getActivePokemon().getFirst()).getBattlePokemon();
            if (battlePokemon == null || raidPokemon == null) {
                return class_1271.method_22431((Object)itemStack);
            }
            if (raidPokemon.getEntity() == null || !((IRaidAccessor)raidPokemon.getEntity()).isRaidBoss()) {
                return class_1271.method_22431((Object)itemStack);
            }
            boolean success = this.handleInteraction((class_3222)player, battlePokemon, itemStack);
            if (!success) {
                return class_1271.method_22431((Object)itemStack);
            }
            itemStack.method_57008(1, (class_1309)player);
            class_174.field_1198.method_8821((class_3222)player, itemStack);
            return class_1271.method_22427((Object)itemStack);
        }
        return class_1271.method_29237((Object)itemStack, (boolean)level.method_8608());
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flag) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.cobblemonraiddens.cheer.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)String.format("item.cobblemonraiddens.%s.tooltip", this.cheerType.getId())).method_27692(class_124.field_1080));
    }
}

