/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidFeature;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import com.necro.raid.dens.common.util.RaidBucketRegistry;
import com.necro.raid.dens.common.util.RaidRegistry;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class RaidBucket {
    private final HashSet<RaidTier> includeTiers;
    private final HashSet<RaidType> includeTypes;
    private final HashSet<RaidFeature> includeFeatures;
    private Set<class_2960> includeBosses;
    private final HashSet<RaidTier> excludeTiers;
    private final HashSet<RaidType> excludeTypes;
    private final HashSet<RaidFeature> excludeFeatures;
    private Set<class_2960> excludeBosses;
    private Set<class_5321<class_1959>> biomes;
    private final double weight;
    private BitSet compiled;
    private class_2960 id;
    private final HashSet<String> includeBossesInner;
    private final HashSet<String> excludeBossesInner;
    private final HashSet<String> biomesInner;

    private RaidBucket(HashSet<RaidTier> includeTiers, HashSet<RaidType> includeTypes, HashSet<RaidFeature> includeFeatures, HashSet<String> includeBosses, HashSet<RaidTier> excludeTiers, HashSet<RaidType> excludeTypes, HashSet<RaidFeature> excludeFeatures, HashSet<String> excludeBosses, HashSet<String> biomes, double weight) {
        this.includeTiers = includeTiers;
        this.includeTypes = includeTypes;
        this.includeFeatures = includeFeatures;
        this.includeBosses = null;
        this.excludeTiers = excludeTiers;
        this.excludeTypes = excludeTypes;
        this.excludeFeatures = excludeFeatures;
        this.excludeBosses = null;
        this.biomes = null;
        this.weight = weight;
        this.compiled = null;
        this.id = null;
        this.includeBossesInner = includeBosses;
        this.excludeBossesInner = excludeBosses;
        this.biomesInner = biomes;
    }

    private HashSet<String> getBiomes() {
        return this.biomesInner;
    }

    public boolean isValidBiome(class_6880<class_1959> biome) {
        if (this.biomes == null) {
            this.resolveBiomes();
        }
        return this.biomes.stream().anyMatch(arg_0 -> biome.method_40225(arg_0));
    }

    public double getWeight() {
        return this.weight;
    }

    public class_2960 getId() {
        return this.id;
    }

    public void setId(class_2960 id) {
        this.id = id;
    }

    public class_2960 getRandomRaidBoss(class_5819 random, class_1937 level) {
        String key = String.valueOf(level.method_27983().method_29177()) + ":" + this.getId().toString();
        if (RaidRegistry.WEIGHTS_CACHE.containsKey(key)) {
            return RaidRegistry.roll(random, RaidRegistry.WEIGHTS_CACHE.get(key), RaidRegistry.INDEX_CACHE.get(key));
        }
        return RaidRegistry.getRandomRaidBoss(random, level, this.getCompiled(), key);
    }

    private void resolveBiomes() {
        HashSet<class_5321<class_1959>> result = new HashSet<class_5321<class_1959>>();
        for (String entry : this.biomesInner) {
            class_2960 id = class_2960.method_60654((String)(entry.startsWith("#") ? entry.substring(1) : entry));
            if (entry.equals("*")) {
                result.addAll(RaidBucketRegistry.BIOME_REGISTRY.method_42021());
                break;
            }
            if (entry.startsWith("#")) {
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)id);
                RaidBucketRegistry.BIOME_REGISTRY.method_40266(tag).ifPresent(holderSet -> holderSet.forEach(holder -> {
                    if (holder.method_40230().isEmpty()) {
                        return;
                    }
                    result.add((class_5321)holder.method_40230().get());
                }));
                continue;
            }
            class_5321 biomeKey = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)id);
            if (!RaidBucketRegistry.BIOME_REGISTRY.method_35842(biomeKey)) continue;
            result.add((class_5321<class_1959>)biomeKey);
        }
        this.biomes = result;
    }

    private void resolveRaidBosses() {
        HashSet<class_2960> result = new HashSet<class_2960>();
        for (String entry : this.includeBossesInner) {
            class_2960 id = class_2960.method_60654((String)(entry.startsWith("#") ? entry.substring(1) : entry));
            if (entry.startsWith("#")) {
                class_6862 tag = class_6862.method_40092(RaidRegistry.RAID_BOSS_KEY, (class_2960)id);
                RaidRegistry.REGISTRY.method_40266(tag).ifPresent(holderSet -> holderSet.forEach(holder -> {
                    if (holder.method_40230().isEmpty()) {
                        return;
                    }
                    class_2960 loc = ((class_5321)holder.method_40230().get()).method_29177();
                    if (RaidRegistry.getRaidBoss(loc) != null) {
                        result.add(loc);
                    } else if (RaidRegistry.getRaidBoss(((RaidBoss)holder.comp_349()).getId()) != null) {
                        result.add(((RaidBoss)holder.comp_349()).getId());
                    }
                }));
                continue;
            }
            if (RaidRegistry.getRaidBoss(id) == null) continue;
            result.add(id);
        }
        this.includeBosses = result;
        HashSet<class_2960> result2 = new HashSet<class_2960>();
        for (String entry : this.excludeBossesInner) {
            class_2960 id = class_2960.method_60654((String)(entry.startsWith("#") ? entry.substring(1) : entry));
            if (entry.startsWith("#")) {
                class_6862 tag = class_6862.method_40092(RaidRegistry.RAID_BOSS_KEY, (class_2960)id);
                RaidRegistry.REGISTRY.method_40266(tag).ifPresent(holderSet -> holderSet.forEach(holder -> {
                    if (holder.method_40230().isEmpty()) {
                        return;
                    }
                    class_2960 loc = ((class_5321)holder.method_40230().get()).method_29177();
                    if (RaidRegistry.getRaidBoss(loc) != null) {
                        result2.add(loc);
                    } else if (RaidRegistry.getRaidBoss(((RaidBoss)holder.comp_349()).getId()) != null) {
                        result2.add(((RaidBoss)holder.comp_349()).getId());
                    }
                }));
                continue;
            }
            if (RaidRegistry.getRaidBoss(id) == null) continue;
            result2.add(id);
        }
        this.excludeBosses = result2;
    }

    private BitSet getCompiled() {
        if (this.compiled == null) {
            boolean noIncludes;
            this.resolveRaidBosses();
            this.compiled = new BitSet();
            boolean bl = noIncludes = this.includeTiers.isEmpty() && this.includeTypes.isEmpty() && this.includeFeatures.isEmpty() && this.includeBosses.isEmpty();
            if (noIncludes) {
                this.compiled.set(0, RaidRegistry.RAID_LIST.size());
            }
            if (!this.includeTiers.isEmpty()) {
                BitSet tierSet = new BitSet();
                for (RaidTier tier : this.includeTiers) {
                    tierSet.or(RaidRegistry.RAIDS_BY_TIER.get((Object)tier));
                }
                this.compiled.and(tierSet);
            }
            if (!this.includeTypes.isEmpty()) {
                BitSet typeSet = new BitSet();
                for (RaidType type : this.includeTypes) {
                    typeSet.or(RaidRegistry.RAIDS_BY_TYPE.get((Object)type));
                }
                this.compiled.and(typeSet);
            }
            if (!this.includeFeatures.isEmpty()) {
                BitSet featureSet = new BitSet();
                for (RaidFeature feature : this.includeFeatures) {
                    featureSet.or(RaidRegistry.RAIDS_BY_FEATURE.get((Object)feature));
                }
                this.compiled.and(featureSet);
            }
            if (!this.includeBosses.isEmpty()) {
                BitSet bossSet = new BitSet();
                for (class_2960 raidBoss : this.includeBosses) {
                    Integer index = RaidRegistry.RAID_INDEX.get(raidBoss);
                    if (index == null) continue;
                    bossSet.set(index);
                }
                this.compiled.or(bossSet);
            }
            for (RaidTier tier : this.excludeTiers) {
                this.compiled.andNot(RaidRegistry.RAIDS_BY_TIER.get((Object)tier));
            }
            for (RaidType type : this.excludeTypes) {
                this.compiled.andNot(RaidRegistry.RAIDS_BY_TYPE.get((Object)type));
            }
            for (RaidFeature feature : this.excludeFeatures) {
                this.compiled.andNot(RaidRegistry.RAIDS_BY_FEATURE.get((Object)feature));
            }
            for (class_2960 raidBoss : this.excludeBosses) {
                Integer index = RaidRegistry.RAID_INDEX.get(raidBoss);
                if (index == null) continue;
                this.compiled.clear(index);
            }
        }
        return this.compiled;
    }

    private RaidBucketFilters getIncluded() {
        return new RaidBucketFilters(this.includeTiers, this.includeTypes, this.includeFeatures, this.includeBossesInner);
    }

    private RaidBucketFilters getExcluded() {
        return new RaidBucketFilters(this.excludeTiers, this.excludeTypes, this.excludeFeatures, this.excludeBossesInner);
    }

    public static Codec<RaidBucket> codec() {
        return RecordCodecBuilder.create(inst -> inst.group((App)RaidBucketFilters.codec().optionalFieldOf("include", (Object)new RaidBucketFilters()).forGetter(RaidBucket::getIncluded), (App)RaidBucketFilters.codec().optionalFieldOf("exclude", (Object)new RaidBucketFilters()).forGetter(RaidBucket::getExcluded), (App)Codec.STRING.listOf().xmap(HashSet::new, ArrayList::new).fieldOf("biome").forGetter(RaidBucket::getBiomes), (App)Codec.DOUBLE.optionalFieldOf("weight", (Object)10.0).forGetter(RaidBucket::getWeight)).apply((Applicative)inst, (include, exclude, biomes, weight) -> new RaidBucket(include.tiers(), include.types(), include.features(), include.bosses(), exclude.tiers(), exclude.types(), exclude.features(), exclude.bosses(), (HashSet<String>)biomes, (double)weight)));
    }

    private record RaidBucketFilters(HashSet<RaidTier> tiers, HashSet<RaidType> types, HashSet<RaidFeature> features, HashSet<String> bosses) {
        public RaidBucketFilters() {
            this(new HashSet<RaidTier>(), new HashSet<RaidType>(), new HashSet<RaidFeature>(), new HashSet<String>());
        }

        private static Codec<RaidBucketFilters> codec() {
            return RecordCodecBuilder.create(inst -> inst.group((App)RaidTier.codec().listOf().xmap(HashSet::new, ArrayList::new).optionalFieldOf("tier", new HashSet()).forGetter(RaidBucketFilters::tiers), (App)RaidType.codec().listOf().xmap(HashSet::new, ArrayList::new).optionalFieldOf("type", new HashSet()).forGetter(RaidBucketFilters::types), (App)RaidFeature.codec().listOf().xmap(HashSet::new, ArrayList::new).optionalFieldOf("feature", new HashSet()).forGetter(RaidBucketFilters::features), (App)Codec.STRING.listOf().xmap(HashSet::new, ArrayList::new).optionalFieldOf("boss", new HashSet()).forGetter(RaidBucketFilters::bosses)).apply((Applicative)inst, RaidBucketFilters::new));
        }
    }
}

