/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.util;

import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidFeature;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class RaidRegistry {
    public static final class_5321<class_2378<RaidBoss>> RAID_BOSS_KEY = class_5321.method_29180((class_2960)class_2960.method_60655((String)"raid", (String)"boss"));
    public static class_2378<RaidBoss> REGISTRY;
    static final Map<RaidTier, BitSet> RAIDS_BY_TIER;
    static final Map<RaidType, BitSet> RAIDS_BY_TYPE;
    static final Map<RaidFeature, BitSet> RAIDS_BY_FEATURE;
    static final List<class_2960> RAID_LIST;
    static final Map<class_2960, RaidBoss> RAID_LOOKUP;
    static final Map<class_2960, Integer> RAID_INDEX;
    static final Map<String, float[]> WEIGHTS_CACHE;
    static final Map<String, int[]> INDEX_CACHE;

    public static void register(RaidBoss raidBoss) {
        if (raidBoss.getProperties().getSpecies() == null) {
            return;
        }
        int index = RAID_LIST.size();
        RAID_LIST.add(raidBoss.getId());
        RAID_LOOKUP.put(raidBoss.getId(), raidBoss);
        RAID_INDEX.put(raidBoss.getId(), index);
        RAIDS_BY_TIER.computeIfAbsent(raidBoss.getTier(), tier -> new BitSet()).set(index);
        RAIDS_BY_TYPE.computeIfAbsent(raidBoss.getType(), type -> new BitSet()).set(index);
        RAIDS_BY_FEATURE.computeIfAbsent(raidBoss.getFeature(), feature -> new BitSet()).set(index);
        if (raidBoss.getWeight() > 0.0) {
            raidBoss.getTier().setPresent();
            raidBoss.getType().setPresent();
        }
    }

    public static void populateWeightedList() {
    }

    public static RaidBoss getRaidBoss(class_2960 location) {
        return RAID_LOOKUP.get(location);
    }

    public static boolean exists(class_2960 location) {
        return RAID_LOOKUP.containsKey(location);
    }

    private static float[] buildWeights(int[] matches, class_1937 level) {
        float[] weights = new float[matches.length];
        float sum = 0.0f;
        for (int i = 0; i < matches.length; ++i) {
            RaidBoss raidBoss = RAID_LOOKUP.get(RAID_LIST.get(matches[i]));
            weights[i] = sum += (float)(raidBoss.getWeight() * raidBoss.getTier().getWeight(level));
        }
        return weights;
    }

    static class_2960 roll(class_5819 random, float[] weights, int[] indexes) {
        float roll = random.method_43057() * weights[weights.length - 1];
        int idx = Arrays.binarySearch(weights, roll);
        if (idx < 0) {
            idx = -idx - 1;
        }
        return RAID_LIST.get(indexes[idx]);
    }

    static class_2960 getRandomRaidBoss(class_5819 random, class_1937 level, BitSet bitSet, @Nullable String cacheKey) {
        int size = bitSet.cardinality();
        if (size == 0) {
            return null;
        }
        int[] matches = new int[size];
        int i = bitSet.nextSetBit(0);
        int idx = 0;
        while (i >= 0) {
            matches[idx] = i;
            i = bitSet.nextSetBit(i + 1);
            ++idx;
        }
        float[] cachedWeights = RaidRegistry.buildWeights(matches, level);
        if (cacheKey != null) {
            WEIGHTS_CACHE.put(cacheKey, cachedWeights);
            INDEX_CACHE.put(cacheKey, matches);
        }
        return RaidRegistry.roll(random, cachedWeights, matches);
    }

    public static class_2960 getRandomRaidBoss(class_5819 random, class_1937 level, List<RaidTier> tiers, List<RaidType> types, List<RaidFeature> features) {
        BitSet set;
        if (tiers == null || tiers.isEmpty()) {
            return null;
        }
        boolean cacheable = !(tiers.size() != 1 || types != null && types.size() > 1 || features != null && !features.isEmpty());
        String key = String.valueOf(level.method_27983().method_29177()) + ":" + String.valueOf((Object)tiers.getFirst()) + ":" + String.valueOf(types == null ? null : types.getFirst());
        if (cacheable && WEIGHTS_CACHE.containsKey(key)) {
            return RaidRegistry.roll(random, WEIGHTS_CACHE.get(key), INDEX_CACHE.get(key));
        }
        BitSet result = new BitSet();
        for (RaidTier tier : tiers) {
            BitSet set2 = RAIDS_BY_TIER.get((Object)tier);
            if (set2 == null) continue;
            result.or(set2);
        }
        if (types != null && !types.isEmpty()) {
            BitSet typeSet = new BitSet();
            for (RaidType type : types) {
                set = RAIDS_BY_TYPE.get((Object)type);
                if (set == null) continue;
                typeSet.or(set);
            }
            result.and(typeSet);
        }
        if (features != null && !features.isEmpty()) {
            BitSet featureSet = new BitSet();
            for (RaidFeature feature : features) {
                set = RAIDS_BY_FEATURE.get((Object)feature);
                if (set == null) continue;
                featureSet.or(set);
            }
            result.and(featureSet);
        }
        return RaidRegistry.getRandomRaidBoss(random, level, result, (String)((Object)(cacheable ? key : null)));
    }

    public static class_2960 getRandomRaidBoss(class_5819 random, class_1937 level, RaidTier tier, RaidType type, RaidFeature feature) {
        return RaidRegistry.getRandomRaidBoss(random, level, List.of(tier), type == null ? null : List.of(type), feature == null ? null : List.of(feature));
    }

    public static class_2960 getRandomRaidBoss(class_5819 random, class_1937 level, RaidType type, RaidFeature feature) {
        return RaidRegistry.getRandomRaidBoss(random, level, RaidTier.getWeightedRandom(random, level), type, feature);
    }

    public static class_2960 getRandomRaidBoss(class_5819 random, class_1937 level) {
        return RaidRegistry.getRandomRaidBoss(random, level, (RaidType)null, null);
    }

    public static void clear() {
        RAIDS_BY_TIER.values().forEach(BitSet::clear);
        RAIDS_BY_TYPE.values().forEach(BitSet::clear);
        RAIDS_BY_FEATURE.values().forEach(BitSet::clear);
        RAID_LIST.clear();
        RAID_LOOKUP.clear();
        RAID_INDEX.clear();
        WEIGHTS_CACHE.clear();
        INDEX_CACHE.clear();
        for (RaidTier raidTier : RaidTier.values()) {
            raidTier.setPresent(false);
        }
        for (Enum enum_ : RaidType.values()) {
            ((RaidType)enum_).setPresent(false);
        }
    }

    public static void initRaidBosses(MinecraftServer server) {
        REGISTRY = server.method_30611().method_30530(RAID_BOSS_KEY);
    }

    static {
        RAIDS_BY_TIER = new EnumMap<RaidTier, BitSet>(RaidTier.class);
        RAIDS_BY_TYPE = new EnumMap<RaidType, BitSet>(RaidType.class);
        RAIDS_BY_FEATURE = new EnumMap<RaidFeature, BitSet>(RaidFeature.class);
        RAID_LIST = new ArrayList<class_2960>();
        RAID_LOOKUP = new HashMap<class_2960, RaidBoss>();
        RAID_INDEX = new HashMap<class_2960, Integer>();
        WEIGHTS_CACHE = new HashMap<String, float[]>();
        INDEX_CACHE = new HashMap<String, int[]>();
    }
}

