/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.util;

import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.blocks.entity.RaidHomeBlockEntity;
import com.necro.raid.dens.common.components.ModComponents;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.items.ItemTags;
import com.necro.raid.dens.common.util.RaidDenRegistry;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_9331;

public class RaidUtils {
    private static final Set<String> MOVE_BLACKLIST = new HashSet<String>();

    public static boolean isMoveBlacklisted(String move) {
        return MOVE_BLACKLIST.contains(move);
    }

    public static boolean hasSkyAccess(class_4538 level, class_2338 blockPos) {
        int topY = level.method_22350(blockPos).method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF);
        return blockPos.method_10264() >= topY;
    }

    public static void teleportPlayerToRaid(class_3222 player, RaidCrystalBlockEntity blockEntity) {
        class_243 playerPos = RaidDenRegistry.getPlayerPos(blockEntity.getRaidStructure());
        player.method_48105(blockEntity.getDimension(), playerPos.field_1352, playerPos.field_1351, playerPos.field_1350, new HashSet(), 180.0f, 0.0f);
    }

    public static void teleportPlayerSafe(class_1657 player, class_3218 level, class_2338 targetPos, float yaw, float pitch) {
        int groundY = level.method_22350(targetPos).method_12005(class_2902.class_2903.field_13197, targetPos.method_10263(), targetPos.method_10260());
        class_2338 groundPos = targetPos.method_33096((int)class_3532.method_15391((double)groundY, (double)targetPos.method_10264()));
        if (RaidUtils.isSafe(level, groundPos.method_10095()) && level.method_8320(groundPos.method_10095().method_10074()).method_26216((class_1922)level, groundPos.method_10095().method_10074())) {
            player.method_48105(level, (double)groundPos.method_10263() + 0.5, (double)groundPos.method_10264(), (double)groundPos.method_10260() - 0.5, new HashSet(), yaw, pitch);
            return;
        }
        int radius = 1;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                class_2338 offset = targetPos.method_10069(dx, 0, dz);
                int topY = level.method_22350(offset).method_12005(class_2902.class_2903.field_13197, offset.method_10263(), offset.method_10260());
                if (!RaidUtils.isSafe(level, offset = offset.method_33096((int)class_3532.method_15391((double)topY, (double)targetPos.method_10264()))) || !level.method_8320(offset.method_10074()).method_26216((class_1922)level, offset.method_10074())) continue;
                player.method_48105(level, (double)offset.method_10263() + 0.5, (double)offset.method_10264(), (double)offset.method_10260() + 0.5, new HashSet(), yaw, pitch);
                return;
            }
        }
        player.method_48105(level, (double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264(), (double)targetPos.method_10260() - 0.5, new HashSet(), yaw, pitch);
    }

    private static boolean isSafe(class_3218 world, class_2338 pos) {
        class_2680 block = world.method_8320(pos);
        class_2680 above = world.method_8320(pos.method_10084());
        return !block.method_27852(class_2246.field_10164) && block.method_26220((class_1922)world, pos).method_1110() && above.method_26220((class_1922)world, pos.method_10084()).method_1110();
    }

    public static boolean isRaidDenKey(class_1799 itemStack) {
        return itemStack.method_31573(ItemTags.RAID_DEN_KEY) || (Boolean)itemStack.method_57825((class_9331)ModComponents.RAID_DEN_KEY.comp_349(), (Object)false) != false;
    }

    public static boolean isCustomDimension(class_1937 level) {
        return level.method_40134().method_40225(ModDimensions.RAIDDIM_TYPE);
    }

    public static boolean cannotBreakOrPlace(class_1657 player, class_1937 level) {
        return RaidUtils.isCustomDimension(level) && !player.method_7337();
    }

    public static boolean cannotBreakOrPlace(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        return RaidUtils.isCustomDimension(level) && !player.method_7337() && !(level.method_8321(hitResult.method_17777()) instanceof RaidHomeBlockEntity);
    }

    public static boolean canBreakOrPlace(class_1937 level, class_1657 player, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        return !RaidUtils.cannotBreakOrPlace(player, level);
    }

    public static class_1269 canBreakOrPlace(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        return RaidUtils.cannotBreakOrPlace(player, level, hand, hitResult) ? class_1269.field_5814 : class_1269.field_5811;
    }

    public static void init() {
        MOVE_BLACKLIST.addAll(CobblemonRaidDens.MOVE_CONFIG.blacklist);
    }
}

