/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosskinchanger.client;

import de.sarocesch.sarosskinchanger.client.ClientSkinCache;
import de.sarocesch.sarosskinchanger.client.SkinChangerScreen;
import de.sarocesch.sarosskinchanger.util.SkinManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ClientPacketHandlers {
    private ClientPacketHandlers() {
    }

    public static void openSkinScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new SkinChangerScreen());
    }

    public static void applySkin(UUID uuid, byte[] pngBytes) {
        try {
            File dir = SkinManager.getSkinDirectory();
            Path out = dir.toPath().resolve(uuid.toString() + "-" + System.currentTimeMillis() + ".png");
            Files.createDirectories(out.getParent(), new FileAttribute[0]);
            Files.write(out, pngBytes, new OpenOption[0]);
            SkinManager.setPlayerSkin(uuid, out.getFileName().toString());
            SkinManager.invalidateFormat(uuid);
            ClientSkinCache.invalidate(uuid);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

