/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosskinchanger.client;

import de.sarocesch.sarosskinchanger.network.NetworkHandler;
import de.sarocesch.sarosskinchanger.network.msg.UploadSkinC2S;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class FileBrowserScreen
extends Screen {
    private File currentDir;
    private FileList list;
    private Button upButton;
    private Button selectButton;
    private EditBox pathBox;

    public FileBrowserScreen(File startDir) {
        super((Component)Component.m_237113_((String)"Select Skin.png"));
        this.currentDir = startDir;
        if (this.currentDir == null || !this.currentDir.exists()) {
            File gameDir = Minecraft.m_91087_().f_91069_;
            this.currentDir = gameDir != null ? gameDir : new File(".").getAbsoluteFile();
        }
    }

    protected void m_7856_() {
        int top = 40;
        this.pathBox = new EditBox(this.f_96547_, 10, 10, this.f_96543_ - 20, 20, (Component)Component.m_237115_((String)"gui.sarosskinchanger.path"));
        this.pathBox.m_94144_(this.currentDir.getAbsolutePath());
        this.m_142416_((GuiEventListener)this.pathBox);
        this.list = new FileList(this, 10, top, this.f_96543_ - 20, this.f_96544_ - 70);
        this.m_7787_((GuiEventListener)this.list);
        this.upButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.sarosskinchanger.button.up"), b -> this.navigateUp()).m_252987_(10, this.f_96544_ - 25, 40, 20).m_253136_();
        this.selectButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.sarosskinchanger.button.select"), b -> this.select()).m_252987_(this.f_96543_ - 90, this.f_96544_ - 25, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.upButton);
        this.m_142416_((GuiEventListener)this.selectButton);
        this.refreshList();
    }

    private void navigateUp() {
        File parent = this.currentDir.getParentFile();
        if (parent != null && parent.exists()) {
            this.currentDir = parent;
            this.pathBox.m_94144_(this.currentDir.getAbsolutePath());
            this.refreshList();
        }
    }

    private void select() {
        FileEntry sel = (FileEntry)this.list.m_93511_();
        if (sel == null) {
            return;
        }
        if (sel.file.isDirectory()) {
            this.currentDir = sel.file;
            this.pathBox.m_94144_(this.currentDir.getAbsolutePath());
            this.refreshList();
        } else {
            try {
                byte[] bytes = Files.readAllBytes(sel.file.toPath());
                NetworkHandler.CHANNEL.sendToServer((Object)new UploadSkinC2S(bytes));
                Minecraft.m_91087_().m_91152_(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void refreshList() {
        this.list.setFiles(this.listPngs(this.currentDir));
    }

    private List<File> listPngs(File dir) {
        File[] files = dir.listFiles(f -> f.isDirectory() || f.getName().toLowerCase().endsWith(".png"));
        if (files == null) {
            return List.of();
        }
        return Arrays.stream(files).sorted((a, b) -> a.isDirectory() == b.isDirectory() ? a.getName().compareToIgnoreCase(b.getName()) : (a.isDirectory() ? -1 : 1)).collect(Collectors.toList());
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        this.list.m_88315_(g, mouseX, mouseY, partialTick);
    }

    static class FileList
    extends ObjectSelectionList<FileEntry> {
        private final FileBrowserScreen parent;

        public FileList(FileBrowserScreen parent, int x, int top, int width, int height) {
            super(Minecraft.m_91087_(), width, height, top, top + height, 18);
            this.parent = parent;
            this.f_93393_ = x;
        }

        public void setFiles(List<File> files) {
            this.m_93516_();
            for (File f : files) {
                this.m_7085_((AbstractSelectionList.Entry)new FileEntry(this, f));
            }
        }
    }

    static class FileEntry
    extends ObjectSelectionList.Entry<FileEntry> {
        private final FileList list;
        final File file;

        public FileEntry(FileList list, File file) {
            this.list = list;
            this.file = file;
        }

        public Component m_142172_() {
            return Component.m_237113_((String)this.file.getName());
        }

        public void m_6311_(GuiGraphics g, int idx, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
            Object name = this.file.isDirectory() ? "[" + this.file.getName() + "]" : this.file.getName();
            g.m_280488_(Minecraft.m_91087_().f_91062_, (String)name, left + 4, top + 4, 0xCCCCCC);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                if (this.file.isDirectory()) {
                    this.list.parent.currentDir = this.file;
                    this.list.parent.pathBox.m_94144_(this.file.getAbsolutePath());
                    this.list.parent.refreshList();
                } else {
                    this.list.m_6987_((AbstractSelectionList.Entry)this);
                    this.list.parent.select();
                }
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }
}

