/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosskinchanger.client;

import com.mojang.blaze3d.platform.NativeImage;
import de.sarocesch.sarosskinchanger.client.ClientSkinCache;
import de.sarocesch.sarosskinchanger.util.SkinManager;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SkinGalleryScreen
extends Screen {
    private final Screen parent;
    private GalleryList list;
    private Button useButton;
    private Button backButton;
    private Button deleteButton;
    private UUID currentPlayer;

    public SkinGalleryScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Skin Gallery"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.currentPlayer = Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_20148_() : new UUID(0L, 0L);
        this.list = new GalleryList(this, 10, 40, this.f_96543_ - 20, this.f_96544_ - 80);
        this.m_7787_((GuiEventListener)this.list);
        this.useButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.sarosskinchanger.button.use"), b -> this.applySelected()).m_252987_(this.f_96543_ - 260, this.f_96544_ - 30, 80, 20).m_253136_();
        this.deleteButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.sarosskinchanger.button.delete"), b -> this.deleteSelected()).m_252987_(this.f_96543_ - 170, this.f_96544_ - 30, 80, 20).m_253136_();
        this.backButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.sarosskinchanger.button.back"), b -> Minecraft.m_91087_().m_91152_(this.parent)).m_252987_(this.f_96543_ - 80, this.f_96544_ - 30, 70, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.useButton);
        this.m_142416_((GuiEventListener)this.deleteButton);
        this.m_142416_((GuiEventListener)this.backButton);
        this.refresh();
    }

    private void refresh() {
        File dir = SkinManager.getSkinDirectory();
        File[] pngs = dir.listFiles(f -> f.isFile() && f.getName().toLowerCase().endsWith(".png"));
        ArrayList<File> files = pngs != null ? Arrays.asList(pngs) : new ArrayList<File>();
        this.list.setFiles(files);
    }

    private void applySelected() {
        GalleryEntry sel = (GalleryEntry)this.list.m_93511_();
        if (sel == null) {
            return;
        }
        SkinManager.setPlayerSkin(this.currentPlayer, sel.file.getName());
        ClientSkinCache.invalidate(this.currentPlayer);
    }

    private void deleteSelected() {
        GalleryEntry sel = (GalleryEntry)this.list.m_93511_();
        if (sel == null) {
            return;
        }
        sel.file.delete();
        this.refresh();
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        this.list.m_88315_(g, mouseX, mouseY, partialTick);
    }

    static class GalleryList
    extends ObjectSelectionList<GalleryEntry> {
        private final SkinGalleryScreen parent;

        public GalleryList(SkinGalleryScreen parent, int x, int top, int width, int height) {
            super(Minecraft.m_91087_(), width, height, top, top + height, 20);
            this.parent = parent;
            this.f_93393_ = x;
        }

        public void setFiles(List<File> files) {
            this.m_93516_();
            for (File f : files) {
                this.m_7085_((AbstractSelectionList.Entry)new GalleryEntry(this, f));
            }
        }
    }

    static class GalleryEntry
    extends ObjectSelectionList.Entry<GalleryEntry> {
        private final GalleryList list;
        final File file;
        ResourceLocation preview;

        public GalleryEntry(GalleryList list, File file) {
            this.list = list;
            this.file = file;
        }

        public Component m_142172_() {
            return Component.m_237113_((String)this.file.getName());
        }

        public void m_6311_(GuiGraphics g, int idx, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
            g.m_280488_(Minecraft.m_91087_().f_91062_, this.file.getName(), left + 50, top + 6, 0xCCCCCC);
            if (this.preview == null) {
                try {
                    NativeImage img = NativeImage.m_85058_((InputStream)Files.newInputStream(this.file.toPath(), new OpenOption[0]));
                    DynamicTexture tex = new DynamicTexture(img);
                    this.preview = Minecraft.m_91087_().m_91097_().m_118490_("ssc_gallery/" + this.file.getName(), tex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.preview != null) {
                g.m_280163_(this.preview, left + 6, top + 4, 0.0f, 0.0f, 32, 32, 32, 32);
            } else {
                g.m_280509_(left + 4, top + 2, left + 44, top + 42, -13421773);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.list.m_6987_((AbstractSelectionList.Entry)this);
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }
}

