/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosskinchanger.client;

import com.mojang.blaze3d.platform.NativeImage;
import de.sarocesch.sarosskinchanger.network.NetworkHandler;
import de.sarocesch.sarosskinchanger.network.msg.UploadSkinC2S;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class SkinUploadScreen
extends Screen {
    private Button uploadButton;
    private Button cancelButton;
    private Path selectedPath;
    private NativeImage previewImage;

    public SkinUploadScreen() {
        super((Component)Component.m_237115_((String)"gui.sarosskinchanger.title.upload"));
    }

    protected void m_7856_() {
        int cx = this.f_96543_ / 2;
        int cy = this.f_96544_ / 2;
        this.uploadButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.sarosskinchanger.button.upload"), b -> this.doUpload()).m_252987_(cx - 100, cy + 60, 90, 20).m_253136_();
        this.cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.sarosskinchanger.button.cancel"), b -> this.m_7379_()).m_252987_(cx + 10, cy + 60, 90, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.uploadButton);
        this.m_142416_((GuiEventListener)this.cancelButton);
        Path importDir = Paths.get("skin_import", new String[0]);
        try {
            Files.createDirectories(importDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.selectedPath = Files.list(importDir).filter(p -> p.toString().toLowerCase().endsWith(".png")).sorted((a, b) -> {
                try {
                    return Long.compare(Files.getLastModifiedTime(b, new LinkOption[0]).toMillis(), Files.getLastModifiedTime(a, new LinkOption[0]).toMillis());
                }
                catch (IOException e) {
                    return 0;
                }
            }).findFirst().orElse(null);
            this.loadPreview();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadPreview() {
        if (this.selectedPath == null) {
            this.previewImage = null;
            return;
        }
        try {
            this.previewImage = NativeImage.m_85058_((InputStream)Files.newInputStream(this.selectedPath, new OpenOption[0]));
        }
        catch (IOException e) {
            this.previewImage = null;
        }
    }

    private void doUpload() {
        if (this.selectedPath == null) {
            return;
        }
        try {
            byte[] bytes = Files.readAllBytes(this.selectedPath);
            NetworkHandler.CHANNEL.sendToServer((Object)new UploadSkinC2S(bytes));
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)"Skin uploaded."), true);
            this.m_7379_();
        }
        catch (IOException e) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)"Failed to upload skin."), true);
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        int cx = this.f_96543_ / 2;
        int cy = this.f_96544_ / 2;
        g.m_280653_(this.f_96547_, this.f_96539_, cx, cy - 80, 0xFFFFFF);
        g.m_280488_(this.f_96547_, "Place PNG files into ./skin_import and reopen to select latest.", cx - 140, cy - 60, 0xA0A0A0);
        if (this.selectedPath != null) {
            g.m_280488_(this.f_96547_, "Selected: " + String.valueOf(this.selectedPath.getFileName()), cx - 140, cy - 40, 0xFFFFFF);
        } else {
            g.m_280488_(this.f_96547_, "No PNG found in ./skin_import", cx - 140, cy - 40, 0xFF5555);
        }
        g.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.sarosskinchanger.label.preview"), cx - 140, cy - 20, 0xFFFFFF);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(null);
    }
}

