/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosskinchanger.mixin;

import de.sarocesch.sarosskinchanger.client.ClientSkinCache;
import de.sarocesch.sarosskinchanger.util.SkinFormat;
import de.sarocesch.sarosskinchanger.util.SkinManager;
import java.util.UUID;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin {
    @Inject(method={"getSkinTextureLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void ssc$overrideSkin(CallbackInfoReturnable<ResourceLocation> cir) {
        ResourceLocation rl;
        UUID id = ((AbstractClientPlayer)this).m_20148_();
        String skin = SkinManager.getPlayerSkin(id);
        if (skin != null && (rl = ClientSkinCache.getOrLoad(id, skin)) != null) {
            cir.setReturnValue((Object)rl);
        }
    }

    @Inject(method={"getModelName"}, at={@At(value="HEAD")}, cancellable=true)
    private void ssc$modelName(CallbackInfoReturnable<String> cir) {
        AbstractClientPlayer self = (AbstractClientPlayer)this;
        UUID id = self.m_20148_();
        String mapped = SkinManager.getPlayerSkin(id);
        if (mapped != null) {
            SkinFormat fmt = SkinManager.getFormat(id);
            if (fmt == SkinFormat.SLIM_64x64) {
                cir.setReturnValue((Object)"slim");
            } else {
                cir.setReturnValue((Object)"default");
            }
        }
    }
}

