/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosskinchanger.setup;

import de.sarocesch.sarosskinchanger.network.NetworkHandler;
import de.sarocesch.sarosskinchanger.network.msg.ApplySkinS2C;
import de.sarocesch.sarosskinchanger.util.SkinManager;
import java.io.File;
import java.nio.file.Files;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="sarosskinchanger")
public class ServerEvents {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer joining = (ServerPlayer)event.getEntity();
        Map<UUID, String> mappings = SkinManager.getAllMappings();
        mappings.forEach((uuid, fileName) -> {
            try {
                File file = SkinManager.getSkinFile(fileName);
                if (file != null) {
                    byte[] bytes = Files.readAllBytes(file.toPath());
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> joining), (Object)new ApplySkinS2C((UUID)uuid, bytes));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

