/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosskinchanger.client;

import com.mojang.blaze3d.platform.NativeImage;
import de.sarocesch.sarosskinchanger.SarosSkinChanger;
import de.sarocesch.sarosskinchanger.util.SkinManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class ClientSkinCache {
    private static final Map<UUID, ResourceLocation> CACHE = new HashMap<UUID, ResourceLocation>();

    public static ResourceLocation getOrLoad(UUID uuid, String skinFileName) {
        ResourceLocation rl = CACHE.get(uuid);
        if (rl != null) {
            return rl;
        }
        File file = SkinManager.getSkinFile(skinFileName);
        if (file == null) {
            return null;
        }
        try {
            NativeImage img = NativeImage.m_85058_((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
            DynamicTexture tex = new DynamicTexture(img);
            rl = Minecraft.m_91087_().m_91097_().m_118490_("sarosskinchanger/" + String.valueOf(uuid), tex);
            CACHE.put(uuid, rl);
            return rl;
        }
        catch (IOException e) {
            SarosSkinChanger.LOGGER.error("Failed to load skin {} for {}", (Object)skinFileName, (Object)uuid, (Object)e);
            return null;
        }
    }

    public static void invalidate(UUID uuid) {
        CACHE.remove(uuid);
    }
}

