/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosskinchanger.client;

import com.mojang.blaze3d.platform.NativeImage;
import de.sarocesch.sarosskinchanger.SarosSkinChanger;
import de.sarocesch.sarosskinchanger.util.SkinManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sarosskinchanger", value={Dist.CLIENT})
public class ClientSkinHandler {
    private static final Map<UUID, ResourceLocation> CACHE = new HashMap<UUID, ResourceLocation>();

    @SubscribeEvent
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        UUID uuid = player.m_20148_();
        String skinFileName = SkinManager.getPlayerSkin(uuid);
        if (skinFileName == null) {
            return;
        }
        try {
            ResourceLocation rl = CACHE.get(uuid);
            if (rl == null) {
                File file = SkinManager.getSkinFile(skinFileName);
                if (file == null) {
                    return;
                }
                NativeImage img = NativeImage.m_85058_((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
                DynamicTexture tex = new DynamicTexture(img);
                rl = Minecraft.m_91087_().m_91097_().m_118490_("sarosskinchanger/" + String.valueOf(uuid), tex);
                CACHE.put(uuid, rl);
            }
        }
        catch (IOException e) {
            SarosSkinChanger.LOGGER.error("Failed to load custom skin for {}: {}", (Object)uuid, (Object)e.getMessage());
        }
    }

    public static void invalidate(UUID uuid) {
        CACHE.remove(uuid);
    }
}

