/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosskinchanger.network.msg;

import de.sarocesch.sarosskinchanger.client.ClientSkinCache;
import de.sarocesch.sarosskinchanger.util.SkinManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ApplySkinS2C {
    public UUID uuid;
    public byte[] pngBytes;

    public ApplySkinS2C(UUID uuid, byte[] pngBytes) {
        this.uuid = uuid;
        this.pngBytes = pngBytes;
    }

    public static void encode(ApplySkinS2C msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.uuid);
        buf.m_130130_(msg.pngBytes.length);
        buf.m_130087_(msg.pngBytes);
    }

    public static ApplySkinS2C decode(FriendlyByteBuf buf) {
        UUID id = buf.m_130259_();
        int len = buf.m_130242_();
        byte[] data = buf.m_130101_(len);
        return new ApplySkinS2C(id, data);
    }

    public static void handle(ApplySkinS2C msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            try {
                File dir = SkinManager.getSkinDirectory();
                Path out = dir.toPath().resolve(msg.uuid.toString() + "-" + System.currentTimeMillis() + ".png");
                Files.createDirectories(out.getParent(), new FileAttribute[0]);
                Files.write(out, msg.pngBytes, new OpenOption[0]);
                SkinManager.setPlayerSkin(msg.uuid, out.getFileName().toString());
                SkinManager.invalidateFormat(msg.uuid);
                ClientSkinCache.invalidate(msg.uuid);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        ctx.setPacketHandled(true);
    }
}

