/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosskinchanger.network.msg;

import de.sarocesch.sarosskinchanger.network.NetworkHandler;
import de.sarocesch.sarosskinchanger.network.msg.ApplySkinS2C;
import de.sarocesch.sarosskinchanger.util.SkinManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class UploadSkinC2S {
    public byte[] pngBytes;

    public UploadSkinC2S(byte[] pngBytes) {
        this.pngBytes = pngBytes;
    }

    public static void encode(UploadSkinC2S msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.pngBytes.length);
        buf.m_130087_(msg.pngBytes);
    }

    public static UploadSkinC2S decode(FriendlyByteBuf buf) {
        int len = buf.m_130242_();
        byte[] data = buf.m_130101_(len);
        return new UploadSkinC2S(data);
    }

    public static void handle(UploadSkinC2S msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            String fileName = sender.m_20148_().toString() + "-uploaded.png";
            try {
                File dir = SkinManager.getSkinDirectory();
                Path out = dir.toPath().resolve(fileName);
                Files.write(out, msg.pngBytes, new OpenOption[0]);
                SkinManager.setPlayerSkin(sender.m_20148_(), out.getFileName().toString());
            }
            catch (Exception dir) {
                // empty catch block
            }
            ApplySkinS2C broadcast = new ApplySkinS2C(sender.m_20148_(), msg.pngBytes);
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)broadcast);
        });
        ctx.setPacketHandled(true);
    }
}

