/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosskinchanger.setup;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosskinchanger.network.NetworkHandler;
import de.sarocesch.sarosskinchanger.network.msg.OpenSkinScreenMsg;
import de.sarocesch.sarosskinchanger.util.SkinResetUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sarosskinchanger", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skin").executes(ModEvents::openSkinGui)).then(Commands.m_82127_((String)"reset").executes(ModEvents::resetSkin))).then(Commands.m_82127_((String)"reload").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.sarosskinchanger.reload.pending"), false);
            return 1;
        })));
    }

    private static int openSkinGui(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        NetworkHandler.sendTo(player, new OpenSkinScreenMsg());
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.sarosskinchanger.open_gui"), false);
        return 1;
    }

    private static int resetSkin(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        SkinResetUtil.resetServerSide(player);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.sarosskinchanger.reset.success"), false);
        return 1;
    }
}

