/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosskinchanger.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.platform.NativeImage;
import de.sarocesch.sarosskinchanger.util.SkinFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public class SkinManager {
    private static final String SKIN_TEXTURES_DIR = "skintextures";
    private static final String MAPPING_FILE = "skins.json";
    public static final Map<UUID, String> playerSkins = new HashMap<UUID, String>();
    private static final Map<UUID, String> pendingSkins = new HashMap<UUID, String>();
    private static boolean loaded = false;
    private static final Map<UUID, SkinFormat> FORMAT_CACHE = new HashMap<UUID, SkinFormat>();

    public static void setPlayerSkin(UUID playerUUID, String skinFileName) {
        if (playerUUID == null || skinFileName == null || skinFileName.isEmpty()) {
            return;
        }
        SkinManager.loadMappings();
        playerSkins.put(playerUUID, skinFileName);
        SkinManager.saveMappings();
        SkinManager.detectAndCacheFormat(playerUUID, skinFileName);
    }

    public static void clearPlayerSkin(UUID playerUUID) {
        if (playerUUID == null) {
            return;
        }
        SkinManager.loadMappings();
        playerSkins.remove(playerUUID);
        SkinManager.saveMappings();
    }

    public static String getPlayerSkin(UUID playerUUID) {
        SkinManager.loadMappings();
        return playerSkins.get(playerUUID);
    }

    public static File getSkinDirectory() {
        File dir = new File(SKIN_TEXTURES_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File getSkinFile(String skinFileName) {
        if (skinFileName == null || skinFileName.isEmpty()) {
            return null;
        }
        File dir = SkinManager.getSkinDirectory();
        File f = new File(dir, skinFileName);
        return f.exists() ? f : null;
    }

    public static Map<UUID, String> getAllMappings() {
        SkinManager.loadMappings();
        return new HashMap<UUID, String>(playerSkins);
    }

    public static void loadMappings() {
        block10: {
            if (loaded) {
                return;
            }
            try {
                File mapFile = new File(SkinManager.getSkinDirectory(), MAPPING_FILE);
                if (!mapFile.exists()) break block10;
                try (FileReader r = new FileReader(mapFile);){
                    Type t = new TypeToken<Map<String, String>>(){}.getType();
                    Map raw = (Map)new Gson().fromJson((Reader)r, t);
                    playerSkins.clear();
                    if (raw != null) {
                        for (Map.Entry e : raw.entrySet()) {
                            playerSkins.put(UUID.fromString((String)e.getKey()), (String)e.getValue());
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        loaded = true;
    }

    public static void saveMappings() {
        try {
            File mapFile = new File(SkinManager.getSkinDirectory(), MAPPING_FILE);
            HashMap<String, String> raw = new HashMap<String, String>();
            for (Map.Entry<UUID, String> e : playerSkins.entrySet()) {
                raw.put(e.getKey().toString(), e.getValue());
            }
            try (FileWriter w = new FileWriter(mapFile);){
                new Gson().toJson(raw, (Appendable)w);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setPendingSkin(UUID playerUUID, String skinFileName) {
        pendingSkins.put(playerUUID, skinFileName);
    }

    public static void removePendingSkin(UUID playerUUID) {
        pendingSkins.remove(playerUUID);
    }

    public static SkinFormat getFormat(UUID uuid) {
        String name;
        SkinManager.loadMappings();
        SkinFormat fmt = FORMAT_CACHE.get(uuid);
        if (fmt == null && (name = playerSkins.get(uuid)) != null) {
            SkinManager.detectAndCacheFormat(uuid, name);
            fmt = FORMAT_CACHE.get(uuid);
        }
        return fmt;
    }

    private static void detectAndCacheFormat(UUID uuid, String fileName) {
        try {
            File file = SkinManager.getSkinFile(fileName);
            if (file == null) {
                return;
            }
            try (FileInputStream in = new FileInputStream(file);){
                NativeImage img = NativeImage.m_85058_((InputStream)in);
                int w = img.m_84982_();
                int h = img.m_85084_();
                SkinFormat fmt = SkinFormat.CLASSIC_64x64;
                if (w == 64 && h == 32) {
                    fmt = SkinFormat.CLASSIC_64x32;
                } else if (w == 64 && h == 64) {
                    boolean slim = SkinManager.isSlimArms(img);
                    fmt = slim ? SkinFormat.SLIM_64x64 : SkinFormat.CLASSIC_64x64;
                }
                FORMAT_CACHE.put(uuid, fmt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void invalidateFormat(UUID uuid) {
        FORMAT_CACHE.remove(uuid);
    }

    private static boolean isSlimArms(NativeImage img) {
        if (img.m_84982_() != 64 || img.m_85084_() != 64) {
            return false;
        }
        int opaqueTotal = 0;
        ArrayList<Integer> runWidths = new ArrayList<Integer>();
        int xStart = 44;
        int xEnd = 55;
        int yStart = 48;
        int yEnd = 63;
        for (int y = yStart; y <= yEnd; ++y) {
            int run = 0;
            int bestRun = 0;
            for (int x = xStart; x <= xEnd; ++x) {
                int a = img.m_84985_(x, y) >>> 24 & 0xFF;
                if (a > 0) {
                    ++run;
                    ++opaqueTotal;
                    continue;
                }
                if (run > bestRun) {
                    bestRun = run;
                }
                run = 0;
            }
            if (run > bestRun) {
                bestRun = run;
            }
            if (bestRun <= 0) continue;
            runWidths.add(bestRun);
        }
        if (opaqueTotal == 0) {
            return false;
        }
        int maxRunAcrossRows = 0;
        Iterator iterator = runWidths.iterator();
        while (iterator.hasNext()) {
            int rw = (Integer)iterator.next();
            if (rw <= maxRunAcrossRows) continue;
            maxRunAcrossRows = rw;
        }
        return maxRunAcrossRows <= 3;
    }

    public static boolean hasPendingSkin(UUID playerUUID) {
        return pendingSkins.containsKey(playerUUID);
    }

    public static String getPendingSkin(UUID playerUUID) {
        return pendingSkins.get(playerUUID);
    }
}

