/*
 * Decompiled with CFR 0.152.
 */
package niuhi.elytra.compat;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import niuhi.elytra.config.DebugLogger;
import niuhi.elytra.config.ModConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Accessories {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"elytra-revamped-compat");
    private static boolean hasWarned = false;
    private static final ModConfig config = ModConfig.init();

    public static boolean hasElytraAccessories(class_3222 player) {
        if (Accessories.config.debug.enabled && Accessories.config.debug.Accessories) {
            DebugLogger.debug("Accessories", "Checking Accessories for player %s", player.method_5477().getString());
        }
        try {
            Class.forName("io.wispforest.accessories.api.AccessoriesCapability");
            AccessoriesCapability capability = AccessoriesCapability.get((class_1309)player);
            if (capability == null) {
                if (Accessories.config.debug.enabled && Accessories.config.debug.Accessories) {
                    DebugLogger.debug("Accessories", "Player %s: AccessoriesCapability is null, no accessories found", player.method_5477().getString());
                }
                return false;
            }
            boolean hasElytra = capability.isEquipped((Predicate)ItemStackBasedPredicate.ofItem((class_1792)class_1802.field_8833));
            if (Accessories.config.debug.enabled && Accessories.config.debug.Accessories) {
                DebugLogger.debug("Accessories", "Player %s: Accessories check result - hasElytra=%b", player.method_5477().getString(), hasElytra);
            }
            return hasElytra;
        }
        catch (ClassNotFoundException e) {
            if (!hasWarned) {
                LOGGER.info("Accessories mod not found, disabling accessories integration");
                hasWarned = true;
            }
            if (Accessories.config.debug.enabled && Accessories.config.debug.Accessories) {
                DebugLogger.debug("Accessories", "Player %s: Accessories mod not present, skipping check", player.method_5477().getString());
            }
            return false;
        }
        catch (Exception e) {
            if (!hasWarned) {
                LOGGER.error("Error checking for elytra accessories: {}", (Object)e.getMessage());
                hasWarned = true;
            }
            if (Accessories.config.debug.enabled && Accessories.config.debug.Accessories) {
                DebugLogger.debug("Accessories", "Player %s: Exception during accessories check - message=%s", player.method_5477().getString(), e.getMessage());
            }
            return false;
        }
    }
}

