/*
 * Decompiled with CFR 0.152.
 */
package niuhi.elytra.config;

import java.text.SimpleDateFormat;
import java.util.Date;
import niuhi.elytra.ElytraMod;
import niuhi.elytra.config.ModConfig;
import org.slf4j.Logger;

public class DebugLogger {
    private static final Logger LOGGER = ElytraMod.LOGGER;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void debug(String handler, String message, Object ... args) {
        boolean shouldLog;
        ModConfig config = ModConfig.getInstance();
        if (config == null) {
            LOGGER.error("DebugLogger: Config is null, cannot proceed with logging");
            return;
        }
        if (handler == null || handler.trim().isEmpty()) {
            LOGGER.warn("DebugLogger: Invalid handler (null or empty) called with message: {}", (Object)String.format(message, args));
            return;
        }
        boolean debugEnabled = config.debug.enabled;
        boolean handlerEnabled = DebugLogger.isHandlerEnabled(handler, config);
        boolean bl = shouldLog = debugEnabled && handlerEnabled;
        if (shouldLog) {
            String formattedMessage = String.format(message, args);
            String timestampedMessage = String.format("[ElytraRevamped-Debug] [%s] [%s] %s", DATE_FORMAT.format(new Date()), handler, formattedMessage);
            LOGGER.info(timestampedMessage);
        }
    }

    private static boolean isHandlerEnabled(String handler, ModConfig config) {
        boolean enabled = switch (handler) {
            case "FireBoostHandler" -> config.debug.fireBoostHandler;
            case "SoulFireHandler" -> config.debug.soulFireHandler;
            case "FireworkSmokeHandler" -> config.debug.fireworkSmokeHandler;
            case "DragHandler" -> config.debug.dragHandler;
            case "InitialFlightHandler" -> config.debug.initialFlightHandler;
            case "FeedbackHandler" -> config.debug.feedbackHandler;
            case "FlightDetector" -> config.debug.flightDetector;
            case "Accessories" -> config.debug.Accessories;
            case "YACL" -> config.debug.YACL;
            default -> {
                LOGGER.warn("DebugLogger: Unknown debug handler: '{}'", (Object)handler);
                yield false;
            }
        };
        return enabled;
    }
}

