/*
 * Decompiled with CFR 0.152.
 */
package niuhi.elytra.detection;

import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import niuhi.elytra.config.DebugLogger;
import niuhi.elytra.config.ModConfig;
import niuhi.elytra.detection.FeedbackHandler;

public class DragHandler {
    private final ModConfig config;
    private final class_5819 random = class_5819.method_43047();

    public DragHandler(ModConfig config, FeedbackHandler feedbackHandler) {
        this.config = config;
    }

    public void processTick(class_3222 player) {
        if (!this.config.drag.enabled) {
            return;
        }
        if (player.method_5715()) {
            this.applyDrag(player);
            this.playDragFeedback(player);
            if (this.config.debug.enabled && this.config.debug.dragHandler) {
                DebugLogger.debug("DragHandler", "Player %s sneaking: drag applied, velocity=%s", player.method_5477().getString(), player.method_18798());
            }
        }
    }

    private void applyDrag(class_3222 player) {
        class_243 velocity;
        double draggedX = velocity.field_1352 * this.config.drag.dragFactor;
        double draggedZ = velocity.field_1350 * this.config.drag.dragFactor;
        class_243 draggedVelocity = new class_243(draggedX, velocity.field_1351, draggedZ);
        velocity = player.method_18798();
        if (!draggedVelocity.equals((Object)velocity)) {
            player.method_18799(draggedVelocity);
            player.field_6037 = true;
        }
    }

    private void playDragFeedback(class_3222 player) {
        if (!this.config.feedback.enableParticles && !this.config.feedback.enableSounds) {
            return;
        }
        class_3218 world = player.method_51469();
        class_243 pos = player.method_19538();
        class_243 velocity = player.method_18798();
        double horizSpeed = Math.sqrt(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350);
        if (horizSpeed < 0.3) {
            return;
        }
        if (this.config.feedback.enableParticles) {
            for (int i = 0; i < 5; ++i) {
                double offsetX = (this.random.method_43058() - 0.5) * 0.5;
                double offsetY = (this.random.method_43058() - 0.5) * 0.5;
                double offsetZ = (this.random.method_43058() - 0.5) * 0.5;
                class_243 particlePos = pos.method_1020(velocity.method_1029().method_1021(0.5 + this.random.method_43058() * 0.5)).method_1031(offsetX, offsetY, offsetZ);
                world.method_65096((class_2394)class_2398.field_11204, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.05, 0.05, 0.05, 0.02);
            }
        }
        if (this.config.feedback.enableSounds && this.random.method_43048(20) == 0) {
            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_47197, class_3419.field_15248, this.config.feedback.soundVolume * 0.4f, this.config.feedback.soundPitch * 1.2f + this.random.method_43057() * 0.1f);
        }
    }
}

