/*
 * Decompiled with CFR 0.152.
 */
package niuhi.elytra.detection;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import niuhi.elytra.compat.Accessories;
import niuhi.elytra.config.DebugLogger;
import niuhi.elytra.config.ModConfig;

public class ElytraFlightDetector {
    private final ModConfig config;
    private final boolean accessoriesLoaded;

    public ElytraFlightDetector(ModConfig config) {
        this.config = config;
        this.accessoriesLoaded = FabricLoader.getInstance().isModLoaded("accessories");
    }

    public boolean isFlying(class_3222 player) {
        boolean isGliding = player.method_6128();
        boolean isWearingElytra = this.isWearingElytra(player);
        boolean result = isGliding && isWearingElytra;
        DebugLogger.debug("FlightDetector", "Player %s: isFlying check - isGliding=%b, isWearingElytra=%b, result=%b", player.method_5477().getString(), isGliding, isWearingElytra, result);
        return result;
    }

    public boolean isWearingElytra(class_3222 player) {
        boolean hasElytraInChest;
        boolean result = hasElytraInChest = player.method_6118(class_1304.field_6174).method_31574(class_1802.field_8833);
        if (this.accessoriesLoaded) {
            try {
                boolean hasAccessoryElytra = Accessories.hasElytraAccessories(player);
                result = hasElytraInChest || hasAccessoryElytra;
                DebugLogger.debug("FlightDetector", "Player %s: Accessories check - chestElytra=%b, accessoryElytra=%b, result=%b", player.method_5477().getString(), hasElytraInChest, hasAccessoryElytra, result);
            }
            catch (Exception e) {
                DebugLogger.debug("FlightDetector", "Player %s: Accessories check failed - exception=%s, falling back to chest check only", player.method_5477().getString(), e.getMessage());
                result = hasElytraInChest;
            }
        } else {
            DebugLogger.debug("FlightDetector", "Player %s: No Accessories mod - chestElytra=%b, result=%b", player.method_5477().getString(), hasElytraInChest, result);
        }
        return result;
    }
}

