/*
 * Decompiled with CFR 0.152.
 */
package niuhi.elytra.detection;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3922;
import niuhi.elytra.config.DebugLogger;
import niuhi.elytra.config.ModConfig;
import niuhi.elytra.detection.FeedbackHandler;
import niuhi.elytra.detection.FireType;

public class FireBoostHandler {
    private final ModConfig config;
    private final FeedbackHandler feedbackHandler;
    private final Map<class_3222, Integer> boostedPlayers = new HashMap<class_3222, Integer>();

    public FireBoostHandler(ModConfig config, FeedbackHandler feedbackHandler) {
        this.config = config;
        this.feedbackHandler = feedbackHandler;
    }

    public void processTick(class_3222 player) {
        int remainingCooldown;
        if (this.config == null || !this.config.mechanics.enableFireworkSmoke) {
            return;
        }
        if (this.boostedPlayers.containsKey(player) && (remainingCooldown = this.boostedPlayers.get(player).intValue()) > 0) {
            this.boostedPlayers.put(player, remainingCooldown - 1);
            return;
        }
        if (this.isAboveCampfire(player)) {
            this.applyBoostIfEligible(player);
            if (this.config.debug.enabled && this.config.debug.fireBoostHandler) {
                DebugLogger.debug("FireBoostHandler", "Player %s above campfire, checking boost eligibility", player.method_5477().getString());
            }
        }
    }

    public void resetPlayer(class_3222 player) {
        this.boostedPlayers.remove(player);
    }

    private boolean hasHayBaleUnderneathArea(class_3218 world, class_2338 pos) {
        if (world.method_8320(pos.method_10074()).method_27852(class_2246.field_10359)) {
            return true;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0 || !world.method_8320(pos.method_10074().method_10069(x, 0, z)).method_27852(class_2246.field_10359)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAboveCampfire(class_3222 player) {
        class_3218 world = player.method_51469();
        class_2338 playerPos = player.method_24515();
        boolean hasHayBale = false;
        for (int y = 0; y <= Math.max(this.config.campFire.hayDetectionHeight, this.config.campFire.detectionHeight); ++y) {
            class_2338 checkPos = playerPos.method_10087(y);
            if (!this.hasHayBaleUnderneathArea(world, checkPos)) continue;
            hasHayBale = true;
            break;
        }
        int maxDetectionHeight = hasHayBale ? this.config.campFire.hayDetectionHeight : this.config.campFire.detectionHeight;
        for (int y = 0; y <= maxDetectionHeight; ++y) {
            boolean isLit;
            class_2338 checkPos = playerPos.method_10087(y);
            class_2680 blockState = world.method_8320(checkPos);
            FireType fireType = FireType.fromState(blockState);
            if (fireType == null || fireType.isSoulFire()) continue;
            boolean bl = isLit = blockState.method_28498((class_2769)class_3922.field_17352) && (Boolean)blockState.method_11654((class_2769)class_3922.field_17352) != false;
            if (!isLit) continue;
            return true;
        }
        return false;
    }

    private void applyBoostIfEligible(class_3222 player) {
        if (this.boostedPlayers.containsKey(player) && this.boostedPlayers.get(player) > 0) {
            return;
        }
        class_3218 world = player.method_51469();
        class_2338 playerPos = player.method_24515();
        double boostAmount = 0.0;
        boolean hasHayInArea = false;
        for (int y = 0; y <= Math.max(this.config.campFire.detectionHeight, this.config.campFire.hayDetectionHeight); ++y) {
            class_2338 checkPos = playerPos.method_10087(y);
            if (!this.hasHayBaleUnderneathArea(world, checkPos)) continue;
            hasHayInArea = true;
            break;
        }
        int maxDetectionHeight = hasHayInArea ? this.config.campFire.hayDetectionHeight : this.config.campFire.detectionHeight;
        for (int y = 0; y <= maxDetectionHeight; ++y) {
            class_2338 checkPos = playerPos.method_10087(y);
            class_2680 blockState = world.method_8320(checkPos);
            FireType fireType = FireType.fromState(blockState);
            if (fireType == null || fireType.isSoulFire()) continue;
            boolean isLit = blockState.method_28498((class_2769)class_3922.field_17352) && (Boolean)blockState.method_11654((class_2769)class_3922.field_17352) != false;
            boolean directHayBale = world.method_8320(checkPos.method_10074()).method_27852(class_2246.field_10359);
            if (!isLit) continue;
            double d = boostAmount = directHayBale ? this.config.campFire.hayBoost : this.config.campFire.baseBoost;
            if (this.config.campFire.autoScaleWithHeight) {
                double distance = player.method_23318() - (double)checkPos.method_10264();
                double scaleFactor = 1.0 - 0.7 * (distance / (double)maxDetectionHeight);
                scaleFactor = Math.min(1.0, Math.max(0.3, scaleFactor));
                boostAmount *= scaleFactor;
            }
            this.boostedPlayers.put(player, Math.max(this.config.campFire.boostCooldownTicks, 0));
            break;
        }
        if (boostAmount > 0.0) {
            this.applyBoost(player, boostAmount);
            this.feedbackHandler.playFireBoostFeedback(player);
            if (this.config.debug.enabled && this.config.debug.fireBoostHandler) {
                DebugLogger.debug("FireBoostHandler", "Player %s boosted by %s units", player.method_5477().getString(), boostAmount);
            }
        }
    }

    private void applyBoost(class_3222 player, double boostAmount) {
        class_243 velocity = player.method_18798();
        class_243 boostVector = new class_243(0.0, boostAmount, 0.0);
        player.method_18799(velocity.method_1019(boostVector));
        player.field_6037 = true;
    }
}

