/*
 * Decompiled with CFR 0.152.
 */
package niuhi.elytra.detection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import niuhi.elytra.config.DebugLogger;
import niuhi.elytra.config.ModConfig;

public class FireworkSmokeHandler {
    private final ModConfig config;
    private final class_5819 random = class_5819.method_43047();
    private final Map<class_3222, SmokeEffectData> activeEffects = new HashMap<class_3222, SmokeEffectData>();

    public FireworkSmokeHandler(ModConfig config) {
        this.config = config;
    }

    public void playFireworkSmokeEffect(class_3222 player, int flightDuration) {
        if (!this.config.mechanics.enableFireworkSmoke) {
            return;
        }
        int clampedDuration = Math.max(1, Math.min(3, flightDuration));
        int smokeDuration = clampedDuration * 20;
        if (this.config.feedback.enableSounds) {
            player.method_51469().method_60511(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_6880)class_3417.field_49049, class_3419.field_15248, this.config.feedback.soundVolume * 0.5f, this.config.feedback.soundPitch + (this.random.method_43057() * 0.2f - 0.1f));
        }
        this.activeEffects.put(player, new SmokeEffectData(smokeDuration));
        if (this.config.debug.enabled && this.config.debug.fireworkSmokeHandler) {
            DebugLogger.debug("FireworkSmokeHandler", "Player %s triggered firework smoke effect, flightDuration=%d, smokeDuration=%d ticks", player.method_5477().getString(), clampedDuration, smokeDuration);
        }
    }

    public void playFireworkSmokeEffect(class_3222 player, class_1799 fireworkStack) {
        int flightDuration = this.getFlightDuration(fireworkStack);
        this.playFireworkSmokeEffect(player, flightDuration);
    }

    public void playFireworkSmokeEffect(class_3222 player) {
        this.playFireworkSmokeEffect(player, 1);
    }

    private int getFlightDuration(class_1799 stack) {
        if (stack == null || stack.method_7960() || stack.method_7909() != class_1802.field_8639) {
            if (this.config.debug.enabled && this.config.debug.fireworkSmokeHandler) {
                DebugLogger.debug("FireworkSmokeHandler", "Invalid or non-firework item stack: %s, defaulting to flight duration 1", stack == null ? "null" : stack.toString());
            }
            return 1;
        }
        class_9284 fireworksComponent = (class_9284)stack.method_58694(class_9334.field_49616);
        if (fireworksComponent == null) {
            if (this.config.debug.enabled && this.config.debug.fireworkSmokeHandler) {
                DebugLogger.debug("FireworkSmokeHandler", "No Fireworks component for stack: %s, defaulting to flight duration 1", stack.toString());
            }
            return 1;
        }
        int flightDuration = fireworksComponent.comp_2391();
        if (flightDuration < 1 || flightDuration > 3) {
            if (this.config.debug.enabled && this.config.debug.fireworkSmokeHandler) {
                DebugLogger.debug("FireworkSmokeHandler", "Invalid flight duration %d for stack: %s, defaulting to 1", flightDuration, stack.toString());
            }
            return 1;
        }
        if (this.config.debug.enabled && this.config.debug.fireworkSmokeHandler) {
            DebugLogger.debug("FireworkSmokeHandler", "Extracted flight duration %d for stack: %s", flightDuration, stack.toString());
        }
        return flightDuration;
    }

    public void processTick() {
        if (!this.config.mechanics.enableFireworkSmoke) {
            this.activeEffects.clear();
            return;
        }
        Iterator<Map.Entry<class_3222, SmokeEffectData>> iterator = this.activeEffects.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_3222, SmokeEffectData> entry = iterator.next();
            class_3222 player = entry.getKey();
            SmokeEffectData effectData = entry.getValue();
            if (!player.method_5805() || player.method_31481() || !effectData.update()) {
                iterator.remove();
                if (!this.config.debug.enabled || !this.config.debug.fireworkSmokeHandler) continue;
                DebugLogger.debug("FireworkSmokeHandler", "Player %s smoke effect ended", player.method_5477().getString());
                continue;
            }
            this.spawnFollowingParticles(player, effectData);
        }
    }

    private void spawnFollowingParticles(class_3222 player, SmokeEffectData effectData) {
        class_3218 world = player.method_51469();
        class_243 pos = player.method_19538();
        class_243 lookVec = player.method_5720().method_1029();
        int particleCount = Math.max(1, Math.min(5, (int)(effectData.getRemainingPercentage() * 5.0f)));
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = (this.random.method_43058() - 0.5) * 0.3;
            double offsetY = (this.random.method_43058() - 0.5) * 0.3;
            double offsetZ = (this.random.method_43058() - 0.5) * 0.3;
            class_243 particlePos = pos.method_1019(lookVec.method_1021(-0.5 - this.random.method_43058() * 0.5)).method_1031(offsetX, offsetY, offsetZ);
            double upDrift = 0.02 + this.random.method_43058() * 0.03;
            world.method_65096((class_2394)class_2398.field_17430, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, offsetX * 0.02, upDrift, offsetZ * 0.02, 0.01);
        }
    }

    public void resetPlayer(class_3222 player) {
        this.activeEffects.remove(player);
    }

    private static class SmokeEffectData {
        private int remainingTicks;
        private final int totalDuration;

        public SmokeEffectData(int duration) {
            this.remainingTicks = duration;
            this.totalDuration = duration;
        }

        public boolean update() {
            return --this.remainingTicks > 0;
        }

        public float getRemainingPercentage() {
            return (float)this.remainingTicks / (float)this.totalDuration;
        }
    }
}

