/*
 * Decompiled with CFR 0.152.
 */
package niuhi.elytra.detection;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3222;
import niuhi.elytra.config.DebugLogger;
import niuhi.elytra.config.ModConfig;

public class InitialFlightHandler {
    private final ModConfig config;
    private final Map<UUID, Boolean> hasUsedInitialFirework = new HashMap<UUID, Boolean>();
    private final Map<UUID, Integer> flightDurationTicks = new HashMap<UUID, Integer>();

    public InitialFlightHandler(ModConfig config) {
        this.config = config;
    }

    public void processTick(class_3222 player) {
        UUID playerId = player.method_5667();
        if (player.method_6128()) {
            int currentDuration = this.flightDurationTicks.getOrDefault(playerId, 0);
            this.flightDurationTicks.put(playerId, currentDuration + 1);
            if (this.config.debug.enabled && this.config.debug.initialFlightHandler) {
                DebugLogger.debug("InitialFlightHandler", "Player %s flight duration: %s ticks", player.method_5477().getString(), currentDuration + 1);
            }
        }
    }

    public boolean canUseInitialFirework(class_3222 player) {
        if (!this.config.mechanics.allowInitialFirework) {
            return false;
        }
        UUID playerId = player.method_5667();
        if (this.hasUsedInitialFirework.getOrDefault(playerId, false).booleanValue()) {
            return false;
        }
        int flightDuration = this.flightDurationTicks.getOrDefault(playerId, 0);
        return flightDuration <= this.config.mechanics.initialFireworkGraceTicks;
    }

    public void markInitialFireworkUsed(class_3222 player) {
        this.hasUsedInitialFirework.put(player.method_5667(), true);
    }

    public void resetPlayer(class_3222 player) {
        UUID playerId = player.method_5667();
        if (!player.method_6128()) {
            this.hasUsedInitialFirework.remove(playerId);
            this.flightDurationTicks.remove(playerId);
        }
    }
}

