/*
 * Decompiled with CFR 0.152.
 */
package niuhi.elytra.detection;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import niuhi.elytra.ElytraMod;
import niuhi.elytra.config.DebugLogger;
import niuhi.elytra.config.ModConfig;
import niuhi.elytra.detection.DragHandler;
import niuhi.elytra.detection.ElytraFlightDetector;
import niuhi.elytra.detection.FeedbackHandler;
import niuhi.elytra.detection.FireBoostHandler;
import niuhi.elytra.detection.FireworkSmokeHandler;
import niuhi.elytra.detection.InitialFlightHandler;
import niuhi.elytra.detection.SoulFireHandler;

public class ModEvents {
    public static final ModConfig config = ModConfig.init();
    private static final ElytraFlightDetector flightDetector = new ElytraFlightDetector(config);
    private static final FeedbackHandler feedbackHandler = new FeedbackHandler(config);
    private static final FireBoostHandler fireBoostHandler = new FireBoostHandler(config, feedbackHandler);
    private static final SoulFireHandler soulFireHandler = new SoulFireHandler(config, feedbackHandler);
    private static final FireworkSmokeHandler fireworkSmokeHandler = new FireworkSmokeHandler(config);
    private static final DragHandler dragHandler = new DragHandler(config, feedbackHandler);
    private static final InitialFlightHandler initialFlightHandler = new InitialFlightHandler(config);

    public static void register() {
        ModEvents.registerFireworkPrevention();
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (config == null) {
                ElytraMod.LOGGER.error("Config is null in ModEvents tick handler!");
                return;
            }
            fireworkSmokeHandler.processTick();
            for (class_3222 player : server.method_3760().method_14571()) {
                initialFlightHandler.processTick(player);
                boolean isCurrentlyFlying = flightDetector.isFlying(player);
                if (ModEvents.config.debug.enabled && ModEvents.config.debug.initialFlightHandler) {
                    DebugLogger.debug("InitialFlightHandler", "Player %s: isFlying=%b, position=%s", player.method_5477().getString(), isCurrentlyFlying, player.method_19538());
                }
                if (isCurrentlyFlying) {
                    fireBoostHandler.processTick(player);
                    soulFireHandler.processTick(player);
                    dragHandler.processTick(player);
                    continue;
                }
                fireBoostHandler.resetPlayer(player);
                soulFireHandler.resetPlayer(player);
                fireworkSmokeHandler.resetPlayer(player);
                initialFlightHandler.resetPlayer(player);
            }
        });
    }

    private static void registerFireworkPrevention() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_1799 itemStack = player.method_5998(hand);
                if (config != null && ModEvents.config.mechanics.disableFireworks && serverPlayer.method_6128() && itemStack.method_31574(class_1802.field_8639)) {
                    if (initialFlightHandler.canUseInitialFirework(serverPlayer)) {
                        initialFlightHandler.markInitialFireworkUsed(serverPlayer);
                        if (ModEvents.config.debug.enabled && ModEvents.config.debug.initialFlightHandler) {
                            DebugLogger.debug("InitialFlightHandler", "Player %s used initial firework", serverPlayer.method_5477().getString());
                        }
                        return class_1269.field_5811;
                    }
                    fireworkSmokeHandler.playFireworkSmokeEffect(serverPlayer, itemStack);
                    if (!serverPlayer.method_68878()) {
                        itemStack.method_7934(1);
                    }
                    if (ModEvents.config.debug.enabled && ModEvents.config.debug.fireworkSmokeHandler) {
                        DebugLogger.debug("FireworkSmokeHandler", "Player %s attempted firework use - blocked and consumed", serverPlayer.method_5477().getString());
                    }
                    return class_1269.field_5814;
                }
            }
            return class_1269.field_5811;
        });
    }
}

