/*
 * Decompiled with CFR 0.152.
 */
package niuhi.elytra.detection;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3922;
import niuhi.elytra.config.DebugLogger;
import niuhi.elytra.config.ModConfig;
import niuhi.elytra.detection.FeedbackHandler;
import niuhi.elytra.detection.FireType;

public class SoulFireHandler {
    private final ModConfig config;
    private final FeedbackHandler feedbackHandler;
    private final Map<class_3222, Integer> pulledPlayers = new HashMap<class_3222, Integer>();

    public SoulFireHandler(ModConfig config, FeedbackHandler feedbackHandler) {
        this.config = config;
        this.feedbackHandler = feedbackHandler;
    }

    public void processTick(class_3222 player) {
        int remainingCooldown;
        if (!this.config.soulFire.enabled) {
            return;
        }
        if (this.pulledPlayers.containsKey(player) && (remainingCooldown = this.pulledPlayers.get(player).intValue()) > 0) {
            this.pulledPlayers.put(player, remainingCooldown - 1);
            return;
        }
        this.applySoulCampfirePull(player);
        if (this.config.debug.enabled && this.config.debug.soulFireHandler) {
            DebugLogger.debug("SoulFireHandler", "Player %s checked for soul fire pull", player.method_5477().getString());
        }
    }

    public void resetPlayer(class_3222 player) {
        this.pulledPlayers.remove(player);
    }

    private boolean hasHayBaleUnderneathArea(class_3218 world, class_2338 pos) {
        if (world.method_8320(pos.method_10074()).method_27852(class_2246.field_10359)) {
            return true;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0 || !world.method_8320(pos.method_10074().method_10069(x, 0, z)).method_27852(class_2246.field_10359)) continue;
                return true;
            }
        }
        return false;
    }

    private void applySoulCampfirePull(class_3222 player) {
        if (this.pulledPlayers.containsKey(player) && this.pulledPlayers.get(player) > 0) {
            return;
        }
        class_3218 world = player.method_51469();
        class_2338 playerPos = player.method_24515();
        boolean hasHayInArea = false;
        for (int y = 0; y <= Math.max(this.config.soulFire.detectionHeight, this.config.soulFire.hayDetectionHeight); ++y) {
            class_2338 checkPos = playerPos.method_10087(y);
            if (!this.hasHayBaleUnderneathArea(world, checkPos)) continue;
            hasHayInArea = true;
            break;
        }
        int maxDetectionHeight = hasHayInArea ? this.config.soulFire.hayDetectionHeight : this.config.soulFire.detectionHeight;
        for (int y = 0; y < maxDetectionHeight; ++y) {
            double pullAmount;
            boolean isLit;
            class_2338 checkPos = playerPos.method_10087(y);
            class_2680 blockState = world.method_8320(checkPos);
            FireType fireType = FireType.fromState(blockState);
            if (fireType == null || !fireType.isSoulFire()) continue;
            boolean bl = isLit = blockState.method_28498((class_2769)class_3922.field_17352) && (Boolean)blockState.method_11654((class_2769)class_3922.field_17352) != false;
            if (!isLit) continue;
            boolean directHayBale = world.method_8320(checkPos.method_10074()).method_27852(class_2246.field_10359);
            double d = pullAmount = directHayBale ? this.config.soulFire.hayPull : this.config.soulFire.basePull;
            if (this.config.soulFire.autoScaleWithHeight) {
                double distance = player.method_23318() - (double)checkPos.method_10264();
                double scaleFactor = 1.0 - 0.7 * (distance / (double)maxDetectionHeight);
                scaleFactor = Math.min(1.0, Math.max(0.3, scaleFactor));
                pullAmount *= scaleFactor;
            }
            this.pulledPlayers.put(player, Math.max(this.config.soulFire.pullCooldownTicks, 0));
            this.applyPull(player, pullAmount);
            this.feedbackHandler.playSoulFirePullFeedback(player);
            if (this.config.debug.enabled && this.config.debug.soulFireHandler) {
                DebugLogger.debug("SoulFireHandler", "Player %s pulled down by %s units", player.method_5477().getString(), pullAmount);
            }
            return;
        }
    }

    private void applyPull(class_3222 player, double pullAmount) {
        class_243 velocity = player.method_18798();
        class_243 pullVector = new class_243(0.0, -pullAmount, 0.0);
        player.method_18799(velocity.method_1019(pullVector));
        player.field_6037 = true;
    }
}

