/*
 * Decompiled with CFR 0.152.
 */
package walksy.shieldstatus.manager;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import walksy.shieldstatus.manager.ShieldCooldownManager;

public class ShieldStateManager {
    private final long ATTACK_ENTRY_TTL_MS = 1000L;
    private final Map<class_1657, Integer> shieldUseTicks = new HashMap<class_1657, Integer>();
    private final Map<class_1657, AttackEntry> attackedPlayerEntries = new HashMap<class_1657, AttackEntry>();
    private final class_310 client = class_310.method_1551();
    private boolean clientShieldDisabled = false;
    private long lastClientShieldDisabledAt = 0L;
    private final ShieldCooldownManager cooldownManager = new ShieldCooldownManager();

    public void set(class_1657 player) {
        if (player == null) {
            return;
        }
        this.cooldownManager.setCooldown(player);
        if (this.client != null && this.client.field_1724 != null && player == this.client.field_1724) {
            this.clientShieldDisabled = true;
            this.lastClientShieldDisabledAt = System.currentTimeMillis();
        }
    }

    public void update() {
        long now = System.currentTimeMillis();
        if (this.client.field_1687 == null) {
            return;
        }
        for (class_1657 player : this.client.field_1687.method_18456()) {
            if (this.isHoldingUsableShield(player) && player.method_6115()) {
                int current = this.shieldUseTicks.getOrDefault(player, 0);
                this.shieldUseTicks.put(player, current + 1);
                continue;
            }
            this.shieldUseTicks.put(player, 0);
        }
        this.attackedPlayerEntries.entrySet().removeIf(e -> now - ((AttackEntry)e.getValue()).time > 1000L);
        this.cooldownManager.tick();
        if (this.client.field_1724 != null) {
            boolean nowDisabled = this.cooldownManager.isCoolingDown((class_1657)this.client.field_1724);
            if (nowDisabled && !this.clientShieldDisabled) {
                this.lastClientShieldDisabledAt = System.currentTimeMillis();
            }
            this.clientShieldDisabled = nowDisabled;
        } else {
            this.clientShieldDisabled = false;
        }
    }

    public void handleBreakPacket(double x, double y, double z) {
        double threshold;
        if (this.client == null || this.client.field_1687 == null || this.client.field_1724 == null) {
            return;
        }
        class_746 local = this.client.field_1724;
        long now = System.currentTimeMillis();
        long CLIENT_DISABLE_GRACE_MS = 250L;
        int MATCH_RADIUS = 5;
        double matchRadiusSq = (double)MATCH_RADIUS * (double)MATCH_RADIUS;
        class_1657 best = null;
        double bestScore = Double.NEGATIVE_INFINITY;
        double bestClientSq = Double.POSITIVE_INFINITY;
        for (Map.Entry<class_1657, AttackEntry> e : this.attackedPlayerEntries.entrySet()) {
            class_1657 candidate = e.getKey();
            AttackEntry ae = e.getValue();
            if (candidate == null || candidate == local || now - ae.time > 1000L) continue;
            double apx = ae.attackPos.field_1352;
            double apy = ae.attackPos.field_1351;
            double apz = ae.attackPos.field_1350;
            double tpx = ae.targetPos.field_1352;
            double tpy = ae.targetPos.field_1351;
            double tpz = ae.targetPos.field_1350;
            double clientDx = apx - x;
            double clientDy = apy - y;
            double clientDz = apz - z;
            double clientSq = clientDx * clientDx + clientDy * clientDy + clientDz * clientDz;
            double dx = tpx - x;
            double dy = tpy - y;
            double dz = tpz - z;
            double distSq = dx * dx + dy * dy + dz * dz;
            if (distSq > matchRadiusSq) continue;
            double score = Math.max(0.0, matchRadiusSq - distSq) / matchRadiusSq;
            if (ae.wasBlocking) {
                score += 0.3;
            }
            if (!this.clientShieldDisabled && clientSq + 0.01 < distSq) {
                score -= 0.35;
            }
            if (!(score > bestScore)) continue;
            bestScore = score;
            best = candidate;
            bestClientSq = clientSq;
        }
        double d = threshold = this.clientShieldDisabled ? 0.05 : 0.25;
        if (best == null || bestScore <= threshold) {
            return;
        }
        AttackEntry bestEntry = this.attackedPlayerEntries.get(best);
        if (bestEntry == null) {
            return;
        }
        double dx = bestEntry.targetPos.field_1352 - x;
        double dy = bestEntry.targetPos.field_1351 - y;
        double dz = bestEntry.targetPos.field_1350 - z;
        double bestDistSq = dx * dx + dy * dy + dz * dz;
        double clientScore = Math.max(0.0, matchRadiusSq - bestClientSq) / matchRadiusSq;
        double candDx = best.method_23317() - x;
        double candDy = best.method_23318() - y;
        double candDz = best.method_23321() - z;
        double candidateCurrentDistSq = candDx * candDx + candDy * candDy + candDz * candDz;
        double EPS = 0.05;
        double CLOSE_DIST_SQ = 0.5;
        boolean accept = false;
        if (bestEntry.wasBlocking) {
            if (bestDistSq <= bestClientSq + 0.05 || candidateCurrentDistSq <= bestClientSq + 0.05) {
                accept = true;
            }
            if (bestDistSq <= 0.5 && bestClientSq <= 0.5) {
                accept = true;
            }
        }
        if (!accept) {
            double deltaThreshold;
            double relativeFactor;
            if (this.clientShieldDisabled) {
                relativeFactor = 1.02;
                deltaThreshold = 0.05;
            } else {
                relativeFactor = 1.05;
                deltaThreshold = 0.08;
            }
            if (bestScore > clientScore * relativeFactor) {
                accept = true;
            } else if (bestScore - clientScore > deltaThreshold) {
                accept = true;
            }
        }
        if (accept) {
            this.set(best);
            this.attackedPlayerEntries.remove(best);
        }
    }

    public void handleEntityStatus(class_1657 player, byte status) {
        if (status == 30 && player != this.client.field_1724) {
            this.set(player);
        }
    }

    public void handlePlayerAttack(class_1657 target) {
        boolean estBlocking;
        boolean bl = estBlocking = this.shieldUseTicks.getOrDefault(target, 0) >= 3;
        if (this.client == null || this.client.field_1724 == null) {
            return;
        }
        if (this.disablesShield((class_1657)this.client.field_1724)) {
            this.attackedPlayerEntries.put(target, new AttackEntry(this.client.field_1724.method_19538(), target.method_19538(), System.currentTimeMillis(), estBlocking));
        }
    }

    public boolean isCoolingDown(class_1657 player) {
        if (player == this.client.field_1724) {
            return this.client.field_1724.method_7357().method_7904(new class_1799((class_1935)class_1802.field_8255));
        }
        return this.cooldownManager.isCoolingDown(player);
    }

    public float getCooldownProgress(class_1657 player) {
        if (player == null) {
            return 0.0f;
        }
        if (player == this.client.field_1724) {
            return this.client.field_1724.method_7357().method_7905(new class_1799((class_1935)class_1802.field_8255), 0.0f);
        }
        int remaining = this.cooldownManager.getRemainingTicks(player);
        if (remaining <= 0) {
            return 0.0f;
        }
        float frac = (float)remaining / 100.0f;
        return Math.max(0.0f, Math.min(1.0f, frac));
    }

    public boolean isUsingShield(class_1657 player) {
        return this.shieldUseTicks.getOrDefault(player, 0) >= 5;
    }

    public boolean isHoldingUsableShield(class_1657 entity) {
        return (entity.method_6047().method_31574(class_1802.field_8255) || entity.method_6079().method_31574(class_1802.field_8255)) && !this.isHoldingAnimationItemMainHand(entity);
    }

    private boolean isHoldingAnimationItemMainHand(class_1657 entity) {
        return entity.method_6047().method_7935((class_1309)entity) != 0 && !entity.method_6047().method_31574(class_1802.field_8255);
    }

    public boolean disablesShield(class_1657 player) {
        return player.method_59958().method_7909() instanceof class_1743;
    }

    private record AttackEntry(class_243 attackPos, class_243 targetPos, long time, boolean wasBlocking) {
    }
}

