/*
 * Decompiled with CFR 0.152.
 */
package walksy.shieldstatus.manager;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_310;

public class ShieldStateManager {
    private final Map<class_1657, Integer> shieldUseTicks = new HashMap<class_1657, Integer>();
    private final HashMap<class_1657, Long> attackedPlayerEntries = new HashMap();
    private final class_310 client = class_310.method_1551();
    private final int SHIELD_BREAK_STATUS = 30;

    public void set(class_1657 player) {
        player.method_7357().method_62835(new class_1799((class_1935)class_1802.field_8255), 100);
    }

    public void update() {
        long now = System.currentTimeMillis();
        for (class_1657 player : this.client.field_1687.method_18456()) {
            if (this.isHoldingUsableShield(player) && player.method_6115()) {
                int current = this.shieldUseTicks.getOrDefault(player, 0);
                this.shieldUseTicks.put(player, current + 1);
                continue;
            }
            this.shieldUseTicks.put(player, 0);
        }
        this.attackedPlayerEntries.entrySet().removeIf(entry -> now - (Long)entry.getValue() > 1000L);
    }

    public void handleEntityStatus(class_1657 player, byte status) {
        if (status == this.SHIELD_BREAK_STATUS) {
            this.set(player);
        }
    }

    public void handleBreakPacket(double x, double y, double z) {
        if (this.client.field_1687 == null || this.client.field_1724 == null) {
            return;
        }
        for (class_1657 player : this.client.field_1687.method_18456()) {
            if (player == this.client.field_1724) continue;
            boolean bl = this.attackedPlayerEntries.containsKey(player);
            int MAX_DIST = 5;
            if (!bl || !(player.method_5649(x, y, z) <= 25.0)) continue;
            this.set(player);
            this.attackedPlayerEntries.remove(player);
            break;
        }
    }

    public void handlePlayerAttack(class_1657 target) {
        if (this.isHoldingUsableShield(target) && target.method_6115() && this.disablesShield((class_1657)this.client.field_1724)) {
            this.attackedPlayerEntries.put(target, System.currentTimeMillis());
        }
    }

    public boolean isCoolingDown(class_1657 player) {
        if (player == null) {
            return false;
        }
        return player.method_7357().method_7904(new class_1799((class_1935)class_1802.field_8255));
    }

    public boolean isUsingShield(class_1657 player) {
        return this.shieldUseTicks.getOrDefault(player, 0) >= 5;
    }

    public boolean isHoldingUsableShield(class_1657 entity) {
        return (entity.method_6047().method_31574(class_1802.field_8255) || entity.method_6079().method_31574(class_1802.field_8255)) && !this.isHoldingAnimationItemMainHand(entity);
    }

    private boolean isHoldingAnimationItemMainHand(class_1657 entity) {
        return entity.method_6047().method_7935((class_1309)entity) != 0 && !entity.method_6047().method_31574(class_1802.field_8255);
    }

    public boolean disablesShield(class_1657 player) {
        return player.method_59958().method_7909() instanceof class_1743;
    }
}

