/*
 * Decompiled with CFR 0.152.
 */
package walksy.shieldstatus.config;

import main.walksy.lib.api.WalksyLibConfig;
import main.walksy.lib.core.config.impl.LocalConfig;
import main.walksy.lib.core.config.local.Category;
import main.walksy.lib.core.config.local.Option;
import main.walksy.lib.core.config.local.OptionDescription;
import main.walksy.lib.core.config.local.options.BooleanOption;
import main.walksy.lib.core.config.local.options.ColorOption;
import main.walksy.lib.core.config.local.options.SpriteOption;
import main.walksy.lib.core.config.local.options.groups.OptionGroup;
import main.walksy.lib.core.config.local.options.type.WalksyLibColor;
import main.walksy.lib.core.utils.IdentifierWrapper;
import main.walksy.lib.core.utils.PathUtils;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import walksy.shieldstatus.ShieldStatus;
import walksy.shieldstatus.manager.ShieldStateManager;

public class Config
implements WalksyLibConfig {
    public static boolean modEnabled = true;
    public static boolean colorInterpolation = false;
    public static boolean grayscaleTexture = false;
    public static boolean selfStateOnly = false;
    public static boolean customEnabledShieldColor = true;
    public static boolean customUsingShieldColor = false;
    public static boolean customDisabledShieldColor = true;
    private static WalksyLibColor enabledColor = new WalksyLibColor(0, 255, 0, 255);
    private static WalksyLibColor usingColor = new WalksyLibColor(0, 255, 0, 255);
    private static WalksyLibColor disabledColor = new WalksyLibColor(255, 0, 0, 255);
    public static IdentifierWrapper enabledTexture = new IdentifierWrapper(class_2960.method_60656((String)"textures/entity/shield_base_nopattern.png"));
    public static IdentifierWrapper disabledTexture = new IdentifierWrapper(class_2960.method_60656((String)"textures/entity/shield_base_nopattern.png"));
    private final Option<Boolean> modEnabledOption = ((BooleanOption)BooleanOption.createBuilder((String)"Mod Enabled", () -> modEnabled, (boolean)modEnabled, newValue -> {
        modEnabled = newValue;
    }).description(OptionDescription.ofOrderedString(() -> "Toggles ShieldStatuses on or off"))).build();
    private final Option<Boolean> selfStateOnlyOption = ((BooleanOption)((BooleanOption)BooleanOption.createBuilder((String)"Self State Only", () -> selfStateOnly, (boolean)selfStateOnly, newValue -> {
        selfStateOnly = newValue;
    }).description(OptionDescription.ofOrderedString(() -> "Shows shield states for the client player only, ignores other players"))).availability(() -> modEnabled, "Requires 'Mod Enabled' to be enabled")).build();
    private final Option<Boolean> interpolateShieldColorOption = ((BooleanOption)((BooleanOption)BooleanOption.createBuilder((String)"Interpolate Shield Color", () -> colorInterpolation, (boolean)colorInterpolation, newValue -> {
        colorInterpolation = newValue;
    }).description(OptionDescription.ofOrderedString(() -> "Transitions the shield color based on the player's disabled and enabled state. Ignores 'use' state"))).availability(() -> modEnabled, "Requires 'Mod Enabled' to be enabled")).build();
    private final Option<Boolean> grayscaleShieldTextureOption = ((BooleanOption)((BooleanOption)BooleanOption.createBuilder((String)"Grayscale Shield Texture", () -> grayscaleTexture, (boolean)grayscaleTexture, newValue -> {
        grayscaleTexture = newValue;
    }).description(OptionDescription.ofOrderedString(() -> "Grayscales the texture of the shield before applying the color overlay. This can lead to more vibrant colors"))).availability(() -> modEnabled, "Requires 'Mod Enabled' to be enabled")).build();
    private final Option<Boolean> customEnabledColorOption = ((BooleanOption)((BooleanOption)BooleanOption.createBuilder((String)"Custom Enabled Shield Color", () -> customEnabledShieldColor, (boolean)customEnabledShieldColor, newValue -> {
        customEnabledShieldColor = newValue;
    }).description(OptionDescription.ofOrderedString(() -> "Allows customization of the shield color when enabled"))).availability(() -> modEnabled, "Requires 'Mod Enabled' to be enabled")).build();
    private final Option<WalksyLibColor> enabledColorOption = ((ColorOption)((ColorOption)ColorOption.createBuilder((String)"Enabled Color", () -> enabledColor, (WalksyLibColor)enabledColor, newValue -> {
        enabledColor = newValue;
    }).description(OptionDescription.ofOrderedString(() -> "Color of the shield when enabled"))).availability(() -> customEnabledShieldColor && modEnabled, "Requires 'Custom Enabled Shield Color & Mod Enabled' to be enabled")).build();
    private final Option<Boolean> customUsingColorOption = ((BooleanOption)((BooleanOption)BooleanOption.createBuilder((String)"Custom Using Shield Color", () -> customUsingShieldColor, (boolean)customUsingShieldColor, newValue -> {
        customUsingShieldColor = newValue;
    }).description(OptionDescription.ofOrderedString(() -> "Allows customization of the shield color while in use"))).availability(() -> modEnabled, "Requires 'Mod Enabled' to be enabled")).build();
    private final Option<WalksyLibColor> usingColorOption = ((ColorOption)((ColorOption)ColorOption.createBuilder((String)"Using Color", () -> usingColor, (WalksyLibColor)usingColor, newValue -> {
        usingColor = newValue;
    }).description(OptionDescription.ofOrderedString(() -> "Color of the shield when in use"))).availability(() -> customUsingShieldColor && modEnabled, "Requires 'Custom Using Shield Color & Mod Enabled' to be enabled")).build();
    private final Option<Boolean> customDisabledColorOption = ((BooleanOption)((BooleanOption)BooleanOption.createBuilder((String)"Custom Disabled Shield Color", () -> customDisabledShieldColor, (boolean)customDisabledShieldColor, newValue -> {
        customDisabledShieldColor = newValue;
    }).description(OptionDescription.ofOrderedString(() -> "Allows customization of the shield color when disabled"))).availability(() -> modEnabled, "Requires 'Mod Enabled' to be enabled")).build();
    private final Option<WalksyLibColor> disabledColorOption = ((ColorOption)((ColorOption)ColorOption.createBuilder((String)"Disabled Color", () -> disabledColor, (WalksyLibColor)disabledColor, newValue -> {
        disabledColor = newValue;
    }).description(OptionDescription.ofOrderedString(() -> "Color of the shield when disabled"))).availability(() -> customDisabledShieldColor && modEnabled, "Requires 'Custom Disabled Shield Color & Mod Enabled' to be enabled")).build();
    private final Category generalCategory = Category.createBuilder((String)"General").group(OptionGroup.createBuilder((String)"Global Options").addOption(this.modEnabledOption).build()).build();
    private final Category colorCategory = Category.createBuilder((String)"Color").group(OptionGroup.createBuilder((String)"General Options").addOption(this.selfStateOnlyOption).addOption(this.interpolateShieldColorOption).addOption(this.grayscaleShieldTextureOption).build()).group(OptionGroup.createBuilder((String)"Enabled Shield Options").addOption(this.customEnabledColorOption).addOption(this.enabledColorOption).build()).group(OptionGroup.createBuilder((String)"Using Shield Options").addOption(this.customUsingColorOption).addOption(this.usingColorOption).build()).group(OptionGroup.createBuilder((String)"Disabled Shield Options").addOption(this.customDisabledColorOption).addOption(this.disabledColorOption).build()).build();
    private final Option<IdentifierWrapper> enabledShieldTextureOption = ((SpriteOption)((SpriteOption)SpriteOption.createBuilder((String)"Enabled Shield Texture", () -> enabledTexture, (IdentifierWrapper)enabledTexture, newValue -> {
        enabledTexture = newValue;
    }).description(OptionDescription.ofOrderedString(() -> "Sets the texture used for the shield when enabled"))).availability(() -> modEnabled, "Requires 'Mod Enabled' to be enabled")).build();
    private final Option<IdentifierWrapper> disabledShieldTextureOption = ((SpriteOption)((SpriteOption)SpriteOption.createBuilder((String)"Disabled Shield Texture", () -> disabledTexture, (IdentifierWrapper)disabledTexture, newValue -> {
        disabledTexture = newValue;
    }).description(OptionDescription.ofOrderedString(() -> "Sets the texture used for the shield when disabled"))).availability(() -> modEnabled, "Requires 'Mod Enabled' to be enabled")).build();
    private final Category textureCategory = Category.createBuilder((String)"Texture").group(OptionGroup.createBuilder((String)"Enabled Shield Options").addOption(this.enabledShieldTextureOption).build()).group(OptionGroup.createBuilder((String)"Disabled Shield Options").addOption(this.disabledShieldTextureOption).build()).build();

    public static WalksyLibColor getColor(@Nullable class_1657 player) {
        WalksyLibColor currentUseColor;
        WalksyLibColor DEFAULT = new WalksyLibColor(255, 255, 255, 255);
        if (player == null) {
            return DEFAULT;
        }
        if (player != class_310.method_1551().field_1724 && selfStateOnly) {
            return DEFAULT;
        }
        ShieldStateManager ssm = ShieldStatus.getShieldStateManager();
        boolean cd = ssm.isCoolingDown(player);
        boolean active = ssm.isUsingShield(player);
        WalksyLibColor currentEnabledColor = customEnabledShieldColor ? enabledColor : DEFAULT;
        WalksyLibColor currentDisabledColor = customDisabledShieldColor ? disabledColor : DEFAULT;
        WalksyLibColor walksyLibColor = currentUseColor = customUsingShieldColor ? usingColor : DEFAULT;
        if (active && customUsingShieldColor) {
            return currentUseColor;
        }
        if (!colorInterpolation) {
            return cd ? currentDisabledColor : currentEnabledColor;
        }
        float progress = cd ? ssm.getCooldownProgress(player) : 0.0f;
        int red = (int)((float)currentEnabledColor.getRed() + (float)(currentDisabledColor.getRed() - currentEnabledColor.getRed()) * progress);
        int green = (int)((float)currentEnabledColor.getGreen() + (float)(currentDisabledColor.getGreen() - currentEnabledColor.getGreen()) * progress);
        int blue = (int)((float)currentEnabledColor.getBlue() + (float)(currentDisabledColor.getBlue() - currentEnabledColor.getBlue()) * progress);
        int alpha = (int)((float)currentEnabledColor.getAlpha() + (float)(currentDisabledColor.getAlpha() - currentEnabledColor.getAlpha()) * progress);
        return new WalksyLibColor(red, green, blue, alpha);
    }

    public static class_2960 getTexture(class_1657 player) {
        if (player != class_310.method_1551().field_1724 && selfStateOnly) {
            return enabledTexture.getIdentifier();
        }
        return ShieldStatus.getShieldStateManager().isCoolingDown(player) ? disabledTexture.getIdentifier() : enabledTexture.getIdentifier();
    }

    public static void tick() {
        enabledColor.tick();
        disabledColor.tick();
        usingColor.tick();
        if (class_310.method_1551().field_1687 != null && class_310.method_1551().field_1724 != null && class_310.method_1551().field_1755 == null && ShieldStatus.toggleSelfState.method_1436()) {
            selfStateOnly = !selfStateOnly;
        }
    }

    public LocalConfig define() {
        return LocalConfig.createBuilder((String)"Shield Status").path(PathUtils.ofConfigDir((String)"shieldstatus")).category(this.generalCategory).category(this.colorCategory).category(this.textureCategory).build();
    }
}

