/*
 * Decompiled with CFR 0.152.
 */
package walksy.shieldstatus.manager;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;

public class ShieldCooldownManager {
    private final Map<UUID, ShieldCooldown> cooldowns = new ConcurrentHashMap<UUID, ShieldCooldown>();

    public void setCooldown(class_1657 player) {
        this.setCooldown(player.method_5667(), 100);
    }

    public void setCooldown(class_1657 player, int ticks) {
        this.setCooldown(player.method_5667(), ticks);
    }

    public void setCooldown(UUID playerUuid) {
        this.setCooldown(playerUuid, 100);
    }

    public void setCooldown(UUID playerUuid, int ticks) {
        if (playerUuid == null) {
            return;
        }
        this.cooldowns.put(playerUuid, new ShieldCooldown(Math.max(0, ticks)));
    }

    public boolean isCoolingDown(class_1657 player) {
        if (player == null) {
            return false;
        }
        return this.isCoolingDown(player.method_5667());
    }

    public boolean isCoolingDown(UUID playerUuid) {
        if (playerUuid == null) {
            return false;
        }
        ShieldCooldown cd = this.cooldowns.get(playerUuid);
        return cd != null && cd.getTicks() > 0;
    }

    public int getRemainingTicks(class_1657 player) {
        if (player == null) {
            return 0;
        }
        return this.getRemainingTicks(player.method_5667());
    }

    public int getRemainingTicks(UUID playerUuid) {
        if (playerUuid == null) {
            return 0;
        }
        ShieldCooldown cd = this.cooldowns.get(playerUuid);
        return cd == null ? 0 : Math.max(0, cd.getTicks());
    }

    public void remove(class_1657 player) {
        if (player == null) {
            return;
        }
        this.remove(player.method_5667());
    }

    public void remove(UUID playerUuid) {
        if (playerUuid == null) {
            return;
        }
        this.cooldowns.remove(playerUuid);
    }

    public void clear() {
        this.cooldowns.clear();
    }

    public void tick() {
        Iterator<Map.Entry<UUID, ShieldCooldown>> it = this.cooldowns.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, ShieldCooldown> e = it.next();
            ShieldCooldown cd = e.getValue();
            cd.tick();
            if (!cd.isDone()) continue;
            it.remove();
        }
    }

    public static final class ShieldCooldown {
        private int ticks;

        public ShieldCooldown(int ticks) {
            this.ticks = Math.max(0, ticks);
        }

        public int getTicks() {
            return this.ticks;
        }

        public void tick() {
            if (this.ticks > 0) {
                --this.ticks;
            }
        }

        public boolean isDone() {
            return this.ticks <= 0;
        }
    }
}

