/*
 * Decompiled with CFR 0.152.
 */
package com.rslover521.furnituresoplenty.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class JsonFileWriterUtil {
    private static final String[] WOOD_TYPES = new String[]{"maple", "fir", "mahogany", "jacaranda", "palm", "willow", "dead", "magic", "umbran", "hellbark", "empyreal", "pine", "redwood"};
    private static final String BASE_PATH = "src/main/resources/assets/furnituresoplenty/";
    private static int count;

    public static void main(String[] args) {
        for (String wood : WOOD_TYPES) {
            JsonFileWriterUtil.generateBlockstate(wood);
            JsonFileWriterUtil.generateBlockModel(wood);
            JsonFileWriterUtil.generateItemModel(wood);
        }
        System.out.println("Finished generating JSON files for all wood types! Wrote " + count + "files.");
    }

    private static void generateBlockstate(String wood) {
        String json = "{\n  \"variants\": {\n    \"facing=north\": { \"model\": \"furnituresoplenty:block/%s_chair\", \"y\": 0 },\n    \"facing=east\":  { \"model\": \"furnituresoplenty:block/%s_chair\", \"y\": 90 },\n    \"facing=south\": { \"model\": \"furnituresoplenty:block/%s_chair\", \"y\": 180 },\n    \"facing=west\":  { \"model\": \"furnituresoplenty:block/%s_chair\", \"y\": 270 }\n  }\n}\n".formatted(wood, wood, wood, wood);
        JsonFileWriterUtil.write("src/main/resources/assets/furnituresoplenty/blockstates/" + wood + "_chair.json", json);
    }

    private static void generateBlockModel(String wood) {
        String json = "{\n  \"parent\": \"refurbished_furniture:block/chair\",\n  \"textures\": {\n    \"particle\": \"biomesoplenty:block/%s_planks\",\n    \"texture\": \"furnituresoplenty:block/%s_chair\"\n  }\n}\n".formatted(wood, wood);
        JsonFileWriterUtil.write("src/main/resources/assets/furnituresoplenty/models/block/" + wood + "_chair.json", json);
    }

    private static void generateItemModel(String wood) {
        String json = "{\n  \"parent\": \"furnituresoplenty:block/%s_chair\"\n}\n".formatted(wood);
        JsonFileWriterUtil.write("src/main/resources/assets/furnituresoplenty/models/item/" + wood + "_chair.json", json);
    }

    private static void write(String filePath, String content) {
        try {
            File file = new File(filePath);
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
                writer.write(content);
                ++count;
            }
            System.out.println("Wrote: " + filePath);
        }
        catch (IOException e) {
            System.err.println("Failed to write: " + filePath);
            e.printStackTrace();
        }
    }
}

