/*
 * Decompiled with CFR 0.152.
 */
package com.auctionhouse;

import com.auctionhouse.discord.DiscordManager;
import com.auctionhouse.web.WebManager;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.model.user.User;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class AuctionHouse
extends JavaPlugin
implements Listener {
    private Economy economy = null;
    private LuckPerms luckPerms = null;
    private WebManager webManager = null;
    private DiscordManager discordManager = null;
    private File auctionFile;
    private HashMap<UUID, Inventory> viewingConfirmBuy = new HashMap();
    private HashMap<UUID, String> pendingPurchase = new HashMap();
    private FileConfiguration auctionData;
    private File configFile;
    private FileConfiguration config;
    private HashMap<UUID, Inventory> viewingAuction = new HashMap();
    private HashMap<UUID, Inventory> viewingShulkerBox = new HashMap();
    private HashMap<UUID, Inventory> viewingMyListings = new HashMap();
    private HashMap<UUID, Inventory> viewingConfirmCancel = new HashMap();
    private HashMap<UUID, String> pendingCancellation = new HashMap();
    private HashMap<UUID, Integer> currentPage = new HashMap();
    private HashMap<UUID, Integer> myListingsPage = new HashMap();
    private final int ITEMS_PER_PAGE = 45;
    private String prefix;
    private boolean enableTax;
    private double taxRate;
    private String currencySymbol;
    private int listingDuration;
    private int maxListingsPerPlayer;
    private Map<String, Integer> rankLimits = new HashMap<String, Integer>();
    private boolean webExpansionEnabled;
    private String webDisabledMessage;

    public void onEnable() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        this.configFile = new File(this.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            this.saveDefaultConfig();
        }
        this.config = this.getConfig();
        this.loadConfigValues();
        this.auctionFile = new File(this.getDataFolder(), "auctions.yml");
        if (!this.auctionFile.exists()) {
            try {
                this.auctionFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create auctions.yml file!");
                e.printStackTrace();
            }
        }
        this.auctionData = YamlConfiguration.loadConfiguration((File)this.auctionFile);
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault not found or no economy plugin detected! AuctionHouse disabled.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.setupLuckPerms();
        this.discordManager = new DiscordManager(this);
        if (this.discordManager.isDiscordEnabled()) {
            this.getLogger().info("Discord integration enabled!");
        }
        if (this.webExpansionEnabled) {
            try {
                this.webManager = new WebManager(this);
                this.webManager.startWebServer();
                this.getLogger().info("Web expansion enabled! Access at: http://localhost:" + this.webManager.getPort());
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to start web expansion: " + e.getMessage());
                this.webExpansionEnabled = false;
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, this::checkExpiredListings, 1200L, 1200L);
        this.getLogger().info("AuctionHouse has been enabled!");
    }

    public void onDisable() {
        for (UUID playerUUID : this.viewingAuction.keySet()) {
            Player player = Bukkit.getPlayer((UUID)playerUUID);
            if (player == null) continue;
            player.closeInventory();
        }
        if (this.webManager != null) {
            this.webManager.stopWebServer();
        }
        if (this.discordManager != null) {
            this.discordManager.shutdown();
        }
        this.saveAuctionData();
        this.getLogger().info("AuctionHouse has been disabled!");
    }

    private void loadConfigValues() {
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("prefix", "&8[&6AuctionHouse&8] &r"));
        this.enableTax = this.config.getBoolean("enable-tax", true);
        this.taxRate = this.config.getDouble("tax-rate", 0.05);
        this.currencySymbol = this.config.getString("currency-symbol", "$");
        this.listingDuration = this.config.getInt("listing-duration-hours", 48);
        this.maxListingsPerPlayer = this.config.getInt("max-listings-per-player", 10);
        this.webExpansionEnabled = this.config.getBoolean("web-expansion.enabled", false);
        this.webDisabledMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("web-expansion.disabled-message", "&cWeb expansion is currently disabled on this server."));
        this.rankLimits.clear();
        ConfigurationSection rankSection = this.config.getConfigurationSection("rank-limits");
        if (rankSection != null) {
            for (String rank : rankSection.getKeys(false)) {
                int limit = rankSection.getInt(rank);
                this.rankLimits.put(rank.toLowerCase(), limit);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.webManager != null && this.webExpansionEnabled) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                int pendingCount = this.webManager.getPendingItemCount(player);
                if (pendingCount > 0) {
                    player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "You have " + pendingCount + " pending items from web purchases!");
                    player.sendMessage(this.prefix + String.valueOf(ChatColor.GRAY) + "Use " + String.valueOf(ChatColor.YELLOW) + "/ahplus claim" + String.valueOf(ChatColor.GRAY) + " to claim them.");
                }
            }, 60L);
        }
        if (this.discordManager != null && this.discordManager.isDiscordEnabled()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                if (this.webManager != null) {
                    this.webManager.deliverPendingPurchases(player);
                }
            }, 80L);
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    private boolean setupLuckPerms() {
        try {
            this.luckPerms = LuckPermsProvider.get();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public WebManager getWebManager() {
        return this.webManager;
    }

    public DiscordManager getDiscordManager() {
        return this.discordManager;
    }

    public FileConfiguration getAuctionData() {
        return this.auctionData;
    }

    public boolean processPurchaseFromWeb(Player player, String auctionId) {
        ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
        if (auctionsSection == null || !auctionsSection.contains(auctionId)) {
            return false;
        }
        double price = auctionsSection.getDouble(auctionId + ".price");
        String sellerUUID = auctionsSection.getString(auctionId + ".seller");
        String sellerName = auctionsSection.getString(auctionId + ".sellerName");
        ItemStack item = auctionsSection.getItemStack(auctionId + ".item");
        if (sellerUUID.equals(player.getUniqueId().toString())) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You cannot buy your own listing.");
            return false;
        }
        if (this.economy.getBalance((OfflinePlayer)player) < price) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have enough money to buy this item.");
            return false;
        }
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{item.clone()});
        if (!leftover.isEmpty()) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have enough inventory space to buy this item.");
            return false;
        }
        this.economy.withdrawPlayer((OfflinePlayer)player, price);
        OfflinePlayer seller = Bukkit.getOfflinePlayer((UUID)UUID.fromString(sellerUUID));
        this.economy.depositPlayer(seller, price);
        auctionsSection.set(auctionId, null);
        this.saveAuctionData();
        player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "You purchased the item via web for " + this.currencySymbol + String.format("%.2f", price) + ".");
        Player sellerPlayer = Bukkit.getPlayer((UUID)UUID.fromString(sellerUUID));
        if (sellerPlayer != null && sellerPlayer.isOnline()) {
            sellerPlayer.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Your item was sold to " + player.getName() + " for " + this.currencySymbol + String.format("%.2f", price) + " via web interface.");
        }
        if (this.discordManager != null && this.discordManager.isDiscordEnabled()) {
            this.discordManager.logTransaction(player.getName(), sellerName, item, price, "Web");
        }
        return true;
    }

    private int getPlayerAuctionLimit(Player player) {
        if (this.luckPerms == null) {
            return this.maxListingsPerPlayer;
        }
        try {
            String groupLower;
            User user = this.luckPerms.getUserManager().getUser(player.getUniqueId());
            if (user == null) {
                return this.maxListingsPerPlayer;
            }
            CachedMetaData metaData = user.getCachedData().getMetaData();
            String primaryGroup = metaData.getPrimaryGroup();
            if (primaryGroup != null && this.rankLimits.containsKey(groupLower = primaryGroup.toLowerCase())) {
                int limit = this.rankLimits.get(groupLower);
                return limit;
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Error getting auction limit for " + player.getName() + ": " + e.getMessage());
        }
        return this.maxListingsPerPlayer;
    }

    public void saveAuctionData() {
        try {
            this.auctionData.save(this.auctionFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save auctions data!");
            e.printStackTrace();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (label.equalsIgnoreCase("auctionhouselink")) {
            this.handleDiscordLinkCommand(player, args2);
            return true;
        }
        if (label.equalsIgnoreCase("ahplus")) {
            if (args2.length == 0) {
                this.showAHPlusHelp(player);
                return true;
            }
            switch (args2[0].toLowerCase()) {
                case "verify": {
                    this.handleVerifyCommand(player, args2);
                    break;
                }
                case "status": {
                    this.handleStatusCommand(player);
                    break;
                }
                case "claim": {
                    this.handleClaimCommand(player);
                    break;
                }
                case "pending": {
                    this.handlePendingCommand(player);
                    break;
                }
                default: {
                    this.showAHPlusHelp(player);
                }
            }
            return true;
        }
        if (label.equalsIgnoreCase("ah") || label.equalsIgnoreCase("auctionhouse")) {
            if (args2.length == 0) {
                this.openAuctionHouse(player, 1);
                return true;
            }
            switch (args2[0].toLowerCase()) {
                case "sell": {
                    this.handleSellCommand(player, args2);
                    break;
                }
                case "cancel": {
                    this.handleCancelCommand(player, args2);
                    break;
                }
                case "expired": {
                    this.handleExpiredCommand(player);
                    break;
                }
                case "listings": {
                    this.openMyListings(player, 1);
                    break;
                }
                case "help": {
                    this.showHelp(player);
                    break;
                }
                case "reload": {
                    if (player.hasPermission("auctionhouse.admin")) {
                        this.handleReloadCommand(player);
                        break;
                    }
                    player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have permission to reload the configuration.");
                    break;
                }
                case "limit": {
                    this.handleLimitCommand(player);
                    break;
                }
                default: {
                    player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Unknown command. Use /ah help for a list of commands.");
                }
            }
            return true;
        }
        return false;
    }

    private void handleDiscordLinkCommand(Player player, String[] args2) {
        if (this.discordManager == null || !this.discordManager.isDiscordEnabled()) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Discord integration is not enabled on this server.");
            return;
        }
        if (args2.length < 1) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Usage: /auctionhouselink <code>");
            player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "Get your linking code by using /auctionhouselink in Discord first.");
            return;
        }
        String code = args2[0].toUpperCase();
        if (this.discordManager.linkAccount(player, code)) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Successfully linked your Discord account!");
            player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "You can now use Discord commands like /auctionhousebalance and purchase items via Discord!");
        } else {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Invalid or expired linking code. Please generate a new code in Discord.");
        }
    }

    private void handleVerifyCommand(Player player, String[] args2) {
        if (!this.webExpansionEnabled) {
            player.sendMessage(this.prefix + this.webDisabledMessage);
            return;
        }
        if (args2.length < 2) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Usage: /ahplus verify <code>");
            return;
        }
        String verificationCode = args2[1];
        if (this.webManager.verifyUser(player.getName(), verificationCode, player.getUniqueId().toString())) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Verification successful! You can now set your password on the web interface.");
            this.webManager.markUserAsVerified(player.getName(), player.getUniqueId().toString());
        } else {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Invalid or expired verification code.");
        }
    }

    private void handleStatusCommand(Player player) {
        ConfigurationSection auctionsSection;
        if (!player.hasPermission("auctionhouse.admin")) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have permission to view status.");
            return;
        }
        player.sendMessage(this.prefix + String.valueOf(ChatColor.GOLD) + "AuctionHouse Plus Status:");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Web Expansion: " + (this.webExpansionEnabled ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Discord Integration: " + (this.discordManager != null && this.discordManager.isDiscordEnabled() ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
        if (this.webExpansionEnabled && this.webManager != null) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Web Server: " + String.valueOf(ChatColor.GREEN) + "Running on port " + this.webManager.getPort());
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Web URL: " + String.valueOf(ChatColor.AQUA) + "http://localhost:" + this.webManager.getPort());
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Registered Users: " + String.valueOf(ChatColor.GREEN) + this.webManager.getRegisteredUserCount());
        }
        int totalAuctions = (auctionsSection = this.auctionData.getConfigurationSection("auctions")) != null ? auctionsSection.getKeys(false).size() : 0;
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Active Auctions: " + String.valueOf(ChatColor.GREEN) + totalAuctions);
    }

    private void showAHPlusHelp(Player player) {
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "========== " + String.valueOf(ChatColor.YELLOW) + "AuctionHouse Plus Help" + String.valueOf(ChatColor.GOLD) + " ==========");
        if (this.webExpansionEnabled) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ahplus verify <code>" + String.valueOf(ChatColor.GRAY) + " - Verify your account for web access");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ahplus pending" + String.valueOf(ChatColor.GRAY) + " - Check pending items from web purchases");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ahplus claim" + String.valueOf(ChatColor.GRAY) + " - Claim pending items (purchases/returns)");
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "Web Interface: " + String.valueOf(ChatColor.WHITE) + "http://localhost:" + String.valueOf(this.webManager != null ? Integer.valueOf(this.webManager.getPort()) : "8080"));
        }
        if (this.discordManager != null && this.discordManager.isDiscordEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.LIGHT_PURPLE) + "Discord Commands:");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/auctionhouselink <code>" + String.valueOf(ChatColor.GRAY) + " - Link your Discord account");
        }
        if (player.hasPermission("auctionhouse.admin")) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ahplus status" + String.valueOf(ChatColor.GRAY) + " - View plugin status");
        }
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "Web expansion: " + (this.webExpansionEnabled ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "Discord integration: " + (this.discordManager != null && this.discordManager.isDiscordEnabled() ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "===============================================");
    }

    private void handleReloadCommand(Player player) {
        this.reloadConfig();
        this.config = this.getConfig();
        boolean wasWebEnabled = this.webExpansionEnabled;
        this.loadConfigValues();
        if (this.discordManager != null) {
            this.discordManager.reloadConfig();
        }
        if (this.webExpansionEnabled && !wasWebEnabled) {
            try {
                this.webManager = new WebManager(this);
                this.webManager.startWebServer();
                player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Configuration reloaded! Web expansion has been enabled.");
                player.sendMessage(String.valueOf(ChatColor.AQUA) + "Web URL: " + String.valueOf(ChatColor.WHITE) + "http://localhost:" + this.webManager.getPort());
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to start web expansion: " + e.getMessage());
                this.webExpansionEnabled = false;
                player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Configuration reloaded, but web expansion failed to start.");
            }
        } else if (!this.webExpansionEnabled && wasWebEnabled) {
            if (this.webManager != null) {
                this.webManager.stopWebServer();
                this.webManager = null;
            }
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Configuration reloaded! Web expansion has been disabled.");
        } else {
            if (this.webExpansionEnabled && this.webManager != null) {
                this.webManager.reloadConfig();
            }
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Configuration reloaded successfully!");
        }
    }

    private void handleLimitCommand(Player player) {
        int currentListings = 0;
        ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
        if (auctionsSection != null) {
            for (String key : auctionsSection.getKeys(false)) {
                if (!player.getUniqueId().toString().equals(auctionsSection.getString(key + ".seller"))) continue;
                ++currentListings;
            }
        }
        int maxLimit = this.getPlayerAuctionLimit(player);
        String rank = "default";
        if (this.luckPerms != null) {
            try {
                User user = this.luckPerms.getUserManager().getUser(player.getUniqueId());
                if (user != null) {
                    CachedMetaData metaData = user.getCachedData().getMetaData();
                    rank = metaData.getPrimaryGroup();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        player.sendMessage(this.prefix + String.valueOf(ChatColor.GOLD) + "Auction Listing Information:");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your Rank: " + String.valueOf(ChatColor.GREEN) + rank);
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Current Listings: " + String.valueOf(ChatColor.GREEN) + currentListings + String.valueOf(ChatColor.YELLOW) + "/" + String.valueOf(ChatColor.GREEN) + maxLimit);
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Available Slots: " + String.valueOf(ChatColor.GREEN) + (maxLimit - currentListings));
        if (this.webExpansionEnabled) {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Tip: You can also manage auctions via web interface!");
        }
        if (this.discordManager != null && this.discordManager.isDiscordEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Tip: Link your Discord account to buy items from Discord!");
        }
    }

    private void handleSellCommand(Player player, String[] args2) {
        int playerLimit;
        double price;
        if (!player.hasPermission("auctionhouse.sell")) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have permission to sell items.");
            return;
        }
        if (args2.length < 2) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Usage: /ah sell <price>");
            return;
        }
        try {
            price = Double.parseDouble(args2[1]);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Invalid price. Please enter a valid number.");
            return;
        }
        if (price <= 0.0) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Price must be greater than 0.");
            return;
        }
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null || itemInHand.getType() == Material.AIR) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You must hold an item to sell in your main hand.");
            return;
        }
        int playerListings = 0;
        ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
        if (auctionsSection != null) {
            for (String key : auctionsSection.getKeys(false)) {
                if (!player.getUniqueId().toString().equals(auctionsSection.getString(key + ".seller"))) continue;
                ++playerListings;
            }
        }
        if (playerListings >= (playerLimit = this.getPlayerAuctionLimit(player))) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You have reached the maximum number of listings (" + playerLimit + ") for your rank.");
            return;
        }
        double taxAmount = 0.0;
        if (this.enableTax) {
            taxAmount = price * this.taxRate;
            if (this.economy.getBalance((OfflinePlayer)player) < taxAmount) {
                player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have enough money to pay the listing tax of " + this.currencySymbol + String.format("%.2f", taxAmount) + ".");
                return;
            }
            this.economy.withdrawPlayer((OfflinePlayer)player, taxAmount);
            player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "You paid " + this.currencySymbol + String.format("%.2f", taxAmount) + " as a listing tax (" + this.taxRate * 100.0 + "% of the price).");
        }
        String auctionId = UUID.randomUUID().toString();
        long currentTime = System.currentTimeMillis();
        long expirationTime = currentTime + (long)(this.listingDuration * 60 * 60 * 1000);
        this.auctionData.set("auctions." + auctionId + ".item", (Object)itemInHand);
        this.auctionData.set("auctions." + auctionId + ".price", (Object)price);
        this.auctionData.set("auctions." + auctionId + ".seller", (Object)player.getUniqueId().toString());
        this.auctionData.set("auctions." + auctionId + ".sellerName", (Object)player.getName());
        this.auctionData.set("auctions." + auctionId + ".listedAt", (Object)currentTime);
        this.auctionData.set("auctions." + auctionId + ".expiresAt", (Object)expirationTime);
        this.saveAuctionData();
        player.getInventory().setItemInMainHand(null);
        player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Your item has been listed for " + this.currencySymbol + String.format("%.2f", price) + ".");
        player.sendMessage(this.prefix + String.valueOf(ChatColor.GRAY) + "You now have " + (playerListings + 1) + "/" + playerLimit + " listings active.");
    }

    private void handleCancelCommand(Player player, String[] args2) {
        if (!player.hasPermission("auctionhouse.cancel")) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have permission to cancel listings.");
            return;
        }
        if (args2.length < 2) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Usage: /ah cancel <listing-id>");
            return;
        }
        String listingId = args2[1];
        ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
        if (auctionsSection == null || !auctionsSection.contains(listingId)) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Listing not found.");
            return;
        }
        String sellerId = auctionsSection.getString(listingId + ".seller");
        if (!sellerId.equals(player.getUniqueId().toString()) && !player.hasPermission("auctionhouse.admin")) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You can only cancel your own listings.");
            return;
        }
        ItemStack item = auctionsSection.getItemStack(listingId + ".item");
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
        if (!leftover.isEmpty()) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have enough inventory space to cancel this listing.");
            return;
        }
        auctionsSection.set(listingId, null);
        this.saveAuctionData();
        player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Listing cancelled successfully. The item has been returned to your inventory.");
    }

    private void handleExpiredCommand(Player player) {
        if (!player.hasPermission("auctionhouse.expired")) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have permission to view expired listings.");
            return;
        }
        ArrayList<ItemStack> expiredItems = new ArrayList<ItemStack>();
        ConfigurationSection expiredSection = this.auctionData.getConfigurationSection("expired");
        if (expiredSection != null) {
            for (String key : expiredSection.getKeys(false)) {
                ConfigurationSection playerSection = expiredSection.getConfigurationSection(key);
                if (playerSection == null || !key.equals(player.getUniqueId().toString())) continue;
                for (String itemKey : playerSection.getKeys(false)) {
                    ItemStack item = playerSection.getItemStack(itemKey);
                    if (item == null) continue;
                    expiredItems.add(item);
                }
            }
        }
        if (expiredItems.isEmpty()) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "You have no expired listings to collect.");
            return;
        }
        HashMap leftoverItems = new HashMap();
        for (ItemStack item : expiredItems) {
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
            leftoverItems.putAll(leftover);
        }
        if (leftoverItems.isEmpty()) {
            expiredSection.set(player.getUniqueId().toString(), null);
            this.saveAuctionData();
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "All expired items have been returned to your inventory.");
        } else {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "Some items couldn't fit in your inventory. Please free up some space and try again.");
        }
    }

    private void showHelp(Player player) {
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "========== " + String.valueOf(ChatColor.YELLOW) + "AuctionHouse Help" + String.valueOf(ChatColor.GOLD) + " ==========");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ah" + String.valueOf(ChatColor.GRAY) + " - Open the auction house");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ah sell <price>" + String.valueOf(ChatColor.GRAY) + " - Sell the item in your hand");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ah cancel <listing-id>" + String.valueOf(ChatColor.GRAY) + " - Cancel one of your listings");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ah listings" + String.valueOf(ChatColor.GRAY) + " - View and manage your listings");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ah expired" + String.valueOf(ChatColor.GRAY) + " - Retrieve your expired listings");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ah limit" + String.valueOf(ChatColor.GRAY) + " - Check your auction limit and current usage");
        if (player.hasPermission("auctionhouse.admin")) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ah reload" + String.valueOf(ChatColor.GRAY) + " - Reload the configuration");
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ah help" + String.valueOf(ChatColor.GRAY) + " - Show this help menu");
        if (this.webExpansionEnabled) {
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "Web Commands:");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ahplus verify <code>" + String.valueOf(ChatColor.GRAY) + " - Verify web account");
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "Web Interface: " + String.valueOf(ChatColor.WHITE) + "http://localhost:" + String.valueOf(this.webManager != null ? Integer.valueOf(this.webManager.getPort()) : "8080"));
        }
        if (this.discordManager != null && this.discordManager.isDiscordEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.LIGHT_PURPLE) + "Discord Commands:");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/auctionhouselink <code>" + String.valueOf(ChatColor.GRAY) + " - Link your Discord account");
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "====================================");
    }

    private void openAuctionHouse(Player player, int page) {
        if (!player.hasPermission("auctionhouse.use")) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have permission to use the auction house.");
            return;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.GOLD) + "Auction House - Page " + page));
        ArrayList activeAuctions = new ArrayList();
        ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
        if (auctionsSection != null) {
            for (String key : auctionsSection.getKeys(false)) {
                HashMap<String, Object> auctionInfo = new HashMap<String, Object>();
                auctionInfo.put("id", key);
                auctionInfo.put("item", auctionsSection.getItemStack(key + ".item").clone());
                auctionInfo.put("price", auctionsSection.getDouble(key + ".price"));
                auctionInfo.put("seller", auctionsSection.getString(key + ".seller"));
                auctionInfo.put("sellerName", auctionsSection.getString(key + ".sellerName"));
                auctionInfo.put("expiresAt", auctionsSection.getLong(key + ".expiresAt"));
                activeAuctions.add(auctionInfo);
            }
        }
        activeAuctions.sort((a1, a2) -> Long.compare((Long)a2.get("expiresAt"), (Long)a1.get("expiresAt")));
        int totalPages = (int)Math.ceil((double)activeAuctions.size() / 45.0);
        if (totalPages == 0) {
            totalPages = 1;
        }
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages) {
            page = totalPages;
        }
        int startIndex = (page - 1) * 45;
        int endIndex = Math.min(startIndex + 45, activeAuctions.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Map auction = (Map)activeAuctions.get(i);
            ItemStack item = (ItemStack)auction.get("item");
            ItemMeta meta = item.getItemMeta();
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("");
            lore.add(String.valueOf(ChatColor.GOLD) + "Price: " + String.valueOf(ChatColor.GREEN) + this.currencySymbol + String.format("%.2f", (Double)auction.get("price")));
            lore.add(String.valueOf(ChatColor.GOLD) + "Seller: " + String.valueOf(ChatColor.GRAY) + String.valueOf(auction.get("sellerName")));
            long expiresAt = (Long)auction.get("expiresAt");
            long currentTime = System.currentTimeMillis();
            long timeUntilExpiry = expiresAt - currentTime;
            if (timeUntilExpiry > 0L) {
                String timeLeft = this.formatTimeLeft(timeUntilExpiry);
                lore.add(String.valueOf(ChatColor.GOLD) + "Expires in: " + String.valueOf(ChatColor.GRAY) + timeLeft);
            } else {
                lore.add(String.valueOf(ChatColor.GOLD) + "Expires in: " + String.valueOf(ChatColor.RED) + "Expired");
            }
            lore.add("");
            if (this.isShulkerBox(item)) {
                lore.add(String.valueOf(ChatColor.AQUA) + "Right-click to preview contents");
                lore.add(String.valueOf(ChatColor.YELLOW) + "Left-click to purchase");
            } else {
                lore.add(String.valueOf(ChatColor.YELLOW) + "Click to purchase");
            }
            lore.add(String.valueOf(ChatColor.DARK_GRAY) + "ID: " + String.valueOf(auction.get("id")));
            meta.setLore(lore);
            item.setItemMeta(meta);
            inventory.setItem(i - startIndex, item);
        }
        if (totalPages > 1) {
            if (page > 1) {
                ItemStack prevButton = new ItemStack(Material.ARROW);
                ItemMeta prevMeta = prevButton.getItemMeta();
                prevMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Previous Page");
                prevButton.setItemMeta(prevMeta);
                inventory.setItem(45, prevButton);
            }
            if (page < totalPages) {
                ItemStack nextButton = new ItemStack(Material.ARROW);
                ItemMeta nextMeta = nextButton.getItemMeta();
                nextMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Next Page");
                nextButton.setItemMeta(nextMeta);
                inventory.setItem(53, nextButton);
            }
            ItemStack pageIndicator = new ItemStack(Material.PAPER);
            ItemMeta pageMeta = pageIndicator.getItemMeta();
            pageMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Page " + page + "/" + totalPages);
            pageIndicator.setItemMeta(pageMeta);
            inventory.setItem(49, pageIndicator);
        }
        ItemStack myListingsButton = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta myListingsMeta = myListingsButton.getItemMeta();
        myListingsMeta.setDisplayName(String.valueOf(ChatColor.LIGHT_PURPLE) + "My Listings");
        ArrayList<CallSite> myListingsLore = new ArrayList<CallSite>();
        myListingsLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "View and manage your listings")));
        myListingsMeta.setLore(myListingsLore);
        myListingsButton.setItemMeta(myListingsMeta);
        inventory.setItem(47, myListingsButton);
        ItemStack refreshButton = new ItemStack(Material.COMPASS);
        ItemMeta refreshMeta = refreshButton.getItemMeta();
        refreshMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Refresh");
        refreshButton.setItemMeta(refreshMeta);
        inventory.setItem(48, refreshButton);
        ItemStack helpButton = new ItemStack(Material.BOOK);
        ItemMeta helpMeta = helpButton.getItemMeta();
        helpMeta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Help");
        ArrayList<CallSite> helpLore = new ArrayList<CallSite>();
        helpLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Click to view commands and instructions")));
        helpMeta.setLore(helpLore);
        helpButton.setItemMeta(helpMeta);
        inventory.setItem(50, helpButton);
        player.openInventory(inventory);
        this.viewingAuction.put(player.getUniqueId(), inventory);
        this.currentPage.put(player.getUniqueId(), page);
    }

    private void openMyListings(Player player, int page) {
        if (!player.hasPermission("auctionhouse.cancel")) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have permission to view your listings.");
            return;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.LIGHT_PURPLE) + "My Listings - Page " + page));
        ArrayList playerAuctions = new ArrayList();
        ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
        if (auctionsSection != null) {
            for (String key : auctionsSection.getKeys(false)) {
                String sellerId = auctionsSection.getString(key + ".seller");
                if (!sellerId.equals(player.getUniqueId().toString())) continue;
                HashMap<String, Object> auctionInfo = new HashMap<String, Object>();
                auctionInfo.put("id", key);
                auctionInfo.put("item", auctionsSection.getItemStack(key + ".item").clone());
                auctionInfo.put("price", auctionsSection.getDouble(key + ".price"));
                auctionInfo.put("expiresAt", auctionsSection.getLong(key + ".expiresAt"));
                auctionInfo.put("listedAt", auctionsSection.getLong(key + ".listedAt"));
                playerAuctions.add(auctionInfo);
            }
        }
        playerAuctions.sort((a1, a2) -> Long.compare((Long)a2.get("listedAt"), (Long)a1.get("listedAt")));
        int totalPages = (int)Math.ceil((double)playerAuctions.size() / 45.0);
        if (totalPages == 0) {
            totalPages = 1;
        }
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages) {
            page = totalPages;
        }
        int startIndex = (page - 1) * 45;
        int endIndex = Math.min(startIndex + 45, playerAuctions.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Map auction = (Map)playerAuctions.get(i);
            ItemStack item = (ItemStack)auction.get("item");
            ItemMeta meta = item.getItemMeta();
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("");
            lore.add(String.valueOf(ChatColor.GOLD) + "Price: " + String.valueOf(ChatColor.GREEN) + this.currencySymbol + String.format("%.2f", (Double)auction.get("price")));
            long expiresAt = (Long)auction.get("expiresAt");
            long currentTime = System.currentTimeMillis();
            long timeUntilExpiry = expiresAt - currentTime;
            if (timeUntilExpiry > 0L) {
                String timeLeft = this.formatTimeLeft(timeUntilExpiry);
                lore.add(String.valueOf(ChatColor.GOLD) + "Expires in: " + String.valueOf(ChatColor.GRAY) + timeLeft);
            } else {
                lore.add(String.valueOf(ChatColor.GOLD) + "Expires in: " + String.valueOf(ChatColor.RED) + "Expired");
            }
            lore.add("");
            if (this.isShulkerBox(item)) {
                lore.add(String.valueOf(ChatColor.AQUA) + "Right-click to preview contents");
                lore.add(String.valueOf(ChatColor.RED) + "Left-click to cancel listing");
            } else {
                lore.add(String.valueOf(ChatColor.RED) + "Click to cancel listing");
            }
            lore.add(String.valueOf(ChatColor.DARK_GRAY) + "ID: " + String.valueOf(auction.get("id")));
            meta.setLore(lore);
            item.setItemMeta(meta);
            inventory.setItem(i - startIndex, item);
        }
        if (totalPages > 1) {
            if (page > 1) {
                ItemStack prevButton = new ItemStack(Material.ARROW);
                ItemMeta prevMeta = prevButton.getItemMeta();
                prevMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Previous Page");
                prevButton.setItemMeta(prevMeta);
                inventory.setItem(45, prevButton);
            }
            if (page < totalPages) {
                ItemStack nextButton = new ItemStack(Material.ARROW);
                ItemMeta nextMeta = nextButton.getItemMeta();
                nextMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Next Page");
                nextButton.setItemMeta(nextMeta);
                inventory.setItem(53, nextButton);
            }
            ItemStack pageIndicator = new ItemStack(Material.PAPER);
            ItemMeta pageMeta = pageIndicator.getItemMeta();
            pageMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Page " + page + "/" + totalPages);
            pageIndicator.setItemMeta(pageMeta);
            inventory.setItem(49, pageIndicator);
        }
        ItemStack backButton = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = backButton.getItemMeta();
        backMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Back to Auction House");
        backButton.setItemMeta(backMeta);
        inventory.setItem(48, backButton);
        player.openInventory(inventory);
        this.viewingMyListings.put(player.getUniqueId(), inventory);
        this.myListingsPage.put(player.getUniqueId(), page);
    }

    private void openShulkerBoxViewer(Player player, ItemStack shulkerBox, String returnTo) {
        if (!this.isShulkerBox(shulkerBox)) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "This is not a shulker box!");
            return;
        }
        BlockStateMeta blockMeta = (BlockStateMeta)shulkerBox.getItemMeta();
        ShulkerBox shulkerBoxState = (ShulkerBox)blockMeta.getBlockState();
        Inventory shulkerInventory = Bukkit.createInventory(null, (int)36, (String)(String.valueOf(ChatColor.AQUA) + "Shulker Box Preview"));
        for (int i = 0; i < 27; ++i) {
            ItemStack item = shulkerBoxState.getInventory().getItem(i);
            if (item == null) continue;
            shulkerInventory.setItem(i, item.clone());
        }
        ItemStack backButton = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backButton.getItemMeta();
        backMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Back");
        ArrayList<CallSite> backLore = new ArrayList<CallSite>();
        backLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Return to " + returnTo)));
        backMeta.setLore(backLore);
        backButton.setItemMeta(backMeta);
        shulkerInventory.setItem(35, backButton);
        player.openInventory(shulkerInventory);
        this.viewingShulkerBox.put(player.getUniqueId(), shulkerInventory);
    }

    private void openConfirmCancelGUI(Player player, String auctionId) {
        ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
        if (auctionsSection == null || !auctionsSection.contains(auctionId)) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Listing not found.");
            return;
        }
        ItemStack item = auctionsSection.getItemStack(auctionId + ".item");
        double price = auctionsSection.getDouble(auctionId + ".price");
        Inventory confirmInventory = Bukkit.createInventory(null, (int)27, (String)(String.valueOf(ChatColor.RED) + "Confirm Cancellation"));
        ItemStack confirmButton = new ItemStack(Material.LIME_CONCRETE);
        ItemMeta confirmMeta = confirmButton.getItemMeta();
        confirmMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Confirm Cancellation");
        ArrayList<CallSite> confirmLore = new ArrayList<CallSite>();
        confirmLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Click to confirm cancellation")));
        confirmLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "The item will be returned to your inventory")));
        confirmMeta.setLore(confirmLore);
        confirmButton.setItemMeta(confirmMeta);
        confirmInventory.setItem(11, confirmButton);
        ItemStack cancelButton = new ItemStack(Material.RED_CONCRETE);
        ItemMeta cancelMeta = cancelButton.getItemMeta();
        cancelMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Cancel");
        ArrayList<CallSite> cancelLore = new ArrayList<CallSite>();
        cancelLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Click to go back without cancelling")));
        cancelMeta.setLore(cancelLore);
        cancelButton.setItemMeta(cancelMeta);
        confirmInventory.setItem(15, cancelButton);
        ItemStack displayItem = item.clone();
        ItemMeta displayMeta = displayItem.getItemMeta();
        ArrayList<Object> displayLore = new ArrayList<Object>();
        if (displayMeta.hasLore()) {
            displayLore.addAll(displayMeta.getLore());
        }
        displayLore.add("");
        displayLore.add(String.valueOf(ChatColor.GOLD) + "Price: " + String.valueOf(ChatColor.GREEN) + this.currencySymbol + String.format("%.2f", price));
        displayLore.add("");
        displayLore.add(String.valueOf(ChatColor.RED) + "Are you sure you want to cancel this listing?");
        displayMeta.setLore(displayLore);
        displayItem.setItemMeta(displayMeta);
        confirmInventory.setItem(13, displayItem);
        player.openInventory(confirmInventory);
        this.viewingConfirmCancel.put(player.getUniqueId(), confirmInventory);
        this.pendingCancellation.put(player.getUniqueId(), auctionId);
    }

    private void openConfirmBuyGUI(Player player, String auctionId) {
        ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
        if (auctionsSection == null || !auctionsSection.contains(auctionId)) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "This item is no longer available.");
            return;
        }
        ItemStack item = auctionsSection.getItemStack(auctionId + ".item");
        double price = auctionsSection.getDouble(auctionId + ".price");
        String sellerName = auctionsSection.getString(auctionId + ".sellerName");
        Inventory confirmInventory = Bukkit.createInventory(null, (int)27, (String)(String.valueOf(ChatColor.GREEN) + "Confirm Purchase"));
        ItemStack confirmButton = new ItemStack(Material.LIME_CONCRETE);
        ItemMeta confirmMeta = confirmButton.getItemMeta();
        confirmMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Confirm Purchase");
        ArrayList<CallSite> confirmLore = new ArrayList<CallSite>();
        confirmLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Click to confirm purchase")));
        confirmLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Price: " + String.valueOf(ChatColor.GREEN) + this.currencySymbol + String.format("%.2f", price))));
        confirmLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Your balance: " + String.valueOf(ChatColor.YELLOW) + this.currencySymbol + String.format("%.2f", this.economy.getBalance((OfflinePlayer)player)))));
        confirmMeta.setLore(confirmLore);
        confirmButton.setItemMeta(confirmMeta);
        confirmInventory.setItem(11, confirmButton);
        ItemStack cancelButton = new ItemStack(Material.RED_CONCRETE);
        ItemMeta cancelMeta = cancelButton.getItemMeta();
        cancelMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Cancel");
        ArrayList<CallSite> cancelLore = new ArrayList<CallSite>();
        cancelLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Click to go back without purchasing")));
        cancelMeta.setLore(cancelLore);
        cancelButton.setItemMeta(cancelMeta);
        confirmInventory.setItem(15, cancelButton);
        ItemStack displayItem = item.clone();
        ItemMeta displayMeta = displayItem.getItemMeta();
        ArrayList<Object> displayLore = new ArrayList<Object>();
        if (displayMeta.hasLore()) {
            displayLore.addAll(displayMeta.getLore());
        }
        displayLore.add("");
        displayLore.add(String.valueOf(ChatColor.GOLD) + "Price: " + String.valueOf(ChatColor.GREEN) + this.currencySymbol + String.format("%.2f", price));
        displayLore.add(String.valueOf(ChatColor.GOLD) + "Seller: " + String.valueOf(ChatColor.GRAY) + sellerName);
        displayLore.add("");
        displayLore.add(String.valueOf(ChatColor.GREEN) + "Are you sure you want to buy this item?");
        displayMeta.setLore(displayLore);
        displayItem.setItemMeta(displayMeta);
        confirmInventory.setItem(13, displayItem);
        player.openInventory(confirmInventory);
        this.viewingConfirmBuy.put(player.getUniqueId(), confirmInventory);
        this.pendingPurchase.put(player.getUniqueId(), auctionId);
    }

    private void purchaseItem(Player player, String auctionId) {
        ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
        if (auctionsSection == null || !auctionsSection.contains(auctionId)) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "This item is no longer available.");
            this.openAuctionHouse(player, this.currentPage.get(player.getUniqueId()));
            return;
        }
        String sellerUUID = auctionsSection.getString(auctionId + ".seller");
        if (sellerUUID.equals(player.getUniqueId().toString())) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You cannot buy your own listing.");
            return;
        }
        this.openConfirmBuyGUI(player, auctionId);
    }

    private void processPurchase(Player player, String auctionId) {
        ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
        if (auctionsSection == null || !auctionsSection.contains(auctionId)) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "This item is no longer available.");
            this.openAuctionHouse(player, this.currentPage.getOrDefault(player.getUniqueId(), 1));
            return;
        }
        double price = auctionsSection.getDouble(auctionId + ".price");
        String sellerUUID = auctionsSection.getString(auctionId + ".seller");
        String sellerName = auctionsSection.getString(auctionId + ".sellerName");
        ItemStack item = auctionsSection.getItemStack(auctionId + ".item");
        if (this.economy.getBalance((OfflinePlayer)player) < price) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have enough money to buy this item.");
            return;
        }
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{item.clone()});
        if (!leftover.isEmpty()) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have enough inventory space to buy this item.");
            return;
        }
        this.economy.withdrawPlayer((OfflinePlayer)player, price);
        OfflinePlayer seller = Bukkit.getOfflinePlayer((UUID)UUID.fromString(sellerUUID));
        this.economy.depositPlayer(seller, price);
        auctionsSection.set(auctionId, null);
        this.saveAuctionData();
        player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "You purchased the item for " + this.currencySymbol + String.format("%.2f", price) + ".");
        Player sellerPlayer = Bukkit.getPlayer((UUID)UUID.fromString(sellerUUID));
        if (sellerPlayer != null && sellerPlayer.isOnline()) {
            sellerPlayer.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Your item was sold to " + player.getName() + " for " + this.currencySymbol + String.format("%.2f", price) + ".");
        }
        if (this.discordManager != null && this.discordManager.isDiscordEnabled()) {
            this.discordManager.logTransaction(player.getName(), sellerName, item, price, "In-Game");
        }
    }

    private void cancelListingById(Player player, String auctionId) {
        ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
        if (auctionsSection == null || !auctionsSection.contains(auctionId)) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Listing not found.");
            return;
        }
        String sellerId = auctionsSection.getString(auctionId + ".seller");
        if (!sellerId.equals(player.getUniqueId().toString()) && !player.hasPermission("auctionhouse.admin")) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You can only cancel your own listings.");
            return;
        }
        ItemStack item = auctionsSection.getItemStack(auctionId + ".item");
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
        if (!leftover.isEmpty()) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have enough inventory space to cancel this listing.");
            return;
        }
        auctionsSection.set(auctionId, null);
        this.saveAuctionData();
        player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Listing cancelled successfully. The item has been returned to your inventory.");
    }

    private boolean isShulkerBox(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material type = item.getType();
        return type == Material.SHULKER_BOX || type == Material.WHITE_SHULKER_BOX || type == Material.ORANGE_SHULKER_BOX || type == Material.MAGENTA_SHULKER_BOX || type == Material.LIGHT_BLUE_SHULKER_BOX || type == Material.YELLOW_SHULKER_BOX || type == Material.LIME_SHULKER_BOX || type == Material.PINK_SHULKER_BOX || type == Material.GRAY_SHULKER_BOX || type == Material.LIGHT_GRAY_SHULKER_BOX || type == Material.CYAN_SHULKER_BOX || type == Material.PURPLE_SHULKER_BOX || type == Material.BLUE_SHULKER_BOX || type == Material.BROWN_SHULKER_BOX || type == Material.GREEN_SHULKER_BOX || type == Material.RED_SHULKER_BOX || type == Material.BLACK_SHULKER_BOX;
    }

    private String formatTimeLeft(long milliseconds) {
        long days = TimeUnit.MILLISECONDS.toDays(milliseconds);
        long hours = TimeUnit.MILLISECONDS.toHours(milliseconds) % 24L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(milliseconds) % 60L;
        if (days > 0L) {
            return days + "d " + hours + "h " + minutes + "m";
        }
        if (hours > 0L) {
            return hours + "h " + minutes + "m";
        }
        return minutes + "m";
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID playerUUID = player.getUniqueId();
        if (this.viewingAuction.containsKey(playerUUID)) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            int slot = event.getRawSlot();
            int page = this.currentPage.get(playerUUID);
            if (slot >= 0 && slot < 45) {
                ItemStack clickedItem = event.getCurrentItem();
                ItemMeta meta = clickedItem.getItemMeta();
                if (meta == null || !meta.hasLore()) {
                    return;
                }
                List lore = meta.getLore();
                String idLine = null;
                for (String line : lore) {
                    if (!line.startsWith(String.valueOf(ChatColor.DARK_GRAY) + "ID: ")) continue;
                    idLine = line.substring((String.valueOf(ChatColor.DARK_GRAY) + "ID: ").length());
                    break;
                }
                if (idLine == null) {
                    return;
                }
                if (this.isShulkerBox(clickedItem) && event.getClick().isRightClick()) {
                    this.openShulkerBoxViewer(player, clickedItem, "Auction House");
                } else {
                    this.purchaseItem(player, idLine);
                }
            } else if (slot == 45 && page > 1) {
                this.openAuctionHouse(player, page - 1);
            } else if (slot == 53) {
                ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
                int totalItems = auctionsSection != null ? auctionsSection.getKeys(false).size() : 0;
                int totalPages = (int)Math.ceil((double)totalItems / 45.0);
                if (page < totalPages) {
                    this.openAuctionHouse(player, page + 1);
                }
            } else if (slot == 47) {
                this.openMyListings(player, 1);
            } else if (slot == 48) {
                this.openAuctionHouse(player, page);
            } else if (slot == 50) {
                player.closeInventory();
                this.showHelp(player);
            }
        } else if (this.viewingMyListings.containsKey(playerUUID)) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            int slot = event.getRawSlot();
            int page = this.myListingsPage.get(playerUUID);
            if (slot >= 0 && slot < 45) {
                ItemStack clickedItem = event.getCurrentItem();
                ItemMeta meta = clickedItem.getItemMeta();
                if (meta == null || !meta.hasLore()) {
                    return;
                }
                List lore = meta.getLore();
                String idLine = null;
                for (String line : lore) {
                    if (!line.startsWith(String.valueOf(ChatColor.DARK_GRAY) + "ID: ")) continue;
                    idLine = line.substring((String.valueOf(ChatColor.DARK_GRAY) + "ID: ").length());
                    break;
                }
                if (idLine == null) {
                    return;
                }
                if (this.isShulkerBox(clickedItem) && event.getClick().isRightClick()) {
                    this.openShulkerBoxViewer(player, clickedItem, "My Listings");
                } else {
                    this.openConfirmCancelGUI(player, idLine);
                }
            } else if (slot == 45 && page > 1) {
                this.openMyListings(player, page - 1);
            } else if (slot == 53) {
                int totalPages;
                ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
                int playerListings = 0;
                if (auctionsSection != null) {
                    for (String key : auctionsSection.getKeys(false)) {
                        if (!player.getUniqueId().toString().equals(auctionsSection.getString(key + ".seller"))) continue;
                        ++playerListings;
                    }
                }
                if (page < (totalPages = (int)Math.ceil((double)playerListings / 45.0))) {
                    this.openMyListings(player, page + 1);
                }
            } else if (slot == 48) {
                this.openAuctionHouse(player, 1);
            }
        } else if (this.viewingShulkerBox.containsKey(playerUUID)) {
            List lore;
            ItemStack backButton;
            ItemMeta backMeta;
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            int slot = event.getRawSlot();
            if (slot == 35 && (backMeta = (backButton = event.getCurrentItem()).getItemMeta()) != null && backMeta.hasLore() && !(lore = backMeta.getLore()).isEmpty()) {
                String returnLocation = (String)lore.get(0);
                if (returnLocation.contains("Auction House")) {
                    this.openAuctionHouse(player, this.currentPage.getOrDefault(playerUUID, 1));
                } else if (returnLocation.contains("My Listings")) {
                    this.openMyListings(player, this.myListingsPage.getOrDefault(playerUUID, 1));
                }
            }
        } else if (this.viewingConfirmCancel.containsKey(playerUUID)) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            int slot = event.getRawSlot();
            if (slot == 11) {
                String auctionId = this.pendingCancellation.get(playerUUID);
                if (auctionId != null) {
                    this.cancelListingById(player, auctionId);
                    this.pendingCancellation.remove(playerUUID);
                    player.closeInventory();
                    this.openMyListings(player, this.myListingsPage.getOrDefault(playerUUID, 1));
                }
            } else if (slot == 15) {
                this.pendingCancellation.remove(playerUUID);
                player.closeInventory();
                this.openMyListings(player, this.myListingsPage.getOrDefault(playerUUID, 1));
            }
        } else if (this.viewingConfirmBuy.containsKey(playerUUID)) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            int slot = event.getRawSlot();
            if (slot == 11) {
                String auctionId = this.pendingPurchase.get(playerUUID);
                if (auctionId != null) {
                    this.processPurchase(player, auctionId);
                    this.pendingPurchase.remove(playerUUID);
                    player.closeInventory();
                    this.openAuctionHouse(player, this.currentPage.getOrDefault(playerUUID, 1));
                }
            } else if (slot == 15) {
                this.pendingPurchase.remove(playerUUID);
                player.closeInventory();
                this.openAuctionHouse(player, this.currentPage.getOrDefault(playerUUID, 1));
            }
        }
    }

    private void handleClaimCommand(Player player) {
        if (!this.webExpansionEnabled) {
            player.sendMessage(this.prefix + this.webDisabledMessage);
            return;
        }
        if (this.webManager == null) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Web manager is not available.");
            return;
        }
        int pendingCount = this.webManager.getPendingItemCount(player);
        if (pendingCount == 0) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "You have no pending items to claim.");
            return;
        }
        player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "Claiming " + pendingCount + " pending items...");
        this.webManager.claimPendingItems(player);
    }

    private void handlePendingCommand(Player player) {
        if (!this.webExpansionEnabled) {
            player.sendMessage(this.prefix + this.webDisabledMessage);
            return;
        }
        if (this.webManager == null) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Web manager is not available.");
            return;
        }
        int pendingCount = this.webManager.getPendingItemCount(player);
        if (pendingCount == 0) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "You have no pending items.");
        } else {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "You have " + pendingCount + " pending items to claim.");
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GRAY) + "Use " + String.valueOf(ChatColor.YELLOW) + "/ahplus claim" + String.valueOf(ChatColor.GRAY) + " to claim them.");
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        this.viewingAuction.remove(playerUUID);
        this.viewingShulkerBox.remove(playerUUID);
        this.viewingMyListings.remove(playerUUID);
        this.viewingConfirmCancel.remove(playerUUID);
        this.viewingConfirmBuy.remove(playerUUID);
        this.currentPage.remove(playerUUID);
        this.myListingsPage.remove(playerUUID);
        this.pendingCancellation.remove(playerUUID);
        this.pendingPurchase.remove(playerUUID);
    }

    private void checkExpiredListings() {
        ConfigurationSection auctionsSection = this.auctionData.getConfigurationSection("auctions");
        if (auctionsSection == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        ArrayList<String> expiredAuctions = new ArrayList<String>();
        for (String key : auctionsSection.getKeys(false)) {
            long expiresAt = auctionsSection.getLong(key + ".expiresAt");
            if (currentTime <= expiresAt) continue;
            String sellerUUID = auctionsSection.getString(key + ".seller");
            ItemStack item = auctionsSection.getItemStack(key + ".item");
            String expiredPath = "expired." + sellerUUID + "." + UUID.randomUUID().toString();
            this.auctionData.set(expiredPath, (Object)item);
            expiredAuctions.add(key);
            Player seller = Bukkit.getPlayer((UUID)UUID.fromString(sellerUUID));
            if (seller == null || !seller.isOnline()) continue;
            seller.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "Your auction listing has expired. Use /ah expired to retrieve your items.");
        }
        for (String key : expiredAuctions) {
            auctionsSection.set(key, null);
        }
        if (!expiredAuctions.isEmpty()) {
            this.saveAuctionData();
        }
    }
}

