/*
 * Decompiled with CFR 0.152.
 */
package com.auctionhouse.discord;

import com.auctionhouse.AuctionHouse;
import com.auctionhouse.discord.DiscordManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DiscordBotHandler {
    private final AuctionHouse plugin;
    private final DiscordManager discordManager;
    private final ScheduledExecutorService scheduler;
    private final String botToken;

    public DiscordBotHandler(AuctionHouse plugin, DiscordManager discordManager, String botToken) {
        this.plugin = plugin;
        this.discordManager = discordManager;
        this.botToken = botToken;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }

    public boolean handleSlashCommand(String commandName, String userId, String[] args2, String channelId) {
        switch (commandName.toLowerCase()) {
            case "auctionhouselink": {
                return this.handleLinkCommand(userId, channelId);
            }
            case "auctionhousebalance": {
                return this.handleBalanceCommand(userId, channelId);
            }
        }
        return false;
    }

    public boolean handleButtonInteraction(String customId, String userId) {
        if (customId.startsWith("buy_")) {
            String auctionId = customId.substring(4);
            return this.handlePurchaseButton(userId, auctionId);
        }
        return false;
    }

    private boolean handleLinkCommand(String userId, String channelId) {
        try {
            String existingUuid = this.discordManager.getLinkedMinecraftUuid(userId);
            if (existingUuid != null) {
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(existingUuid));
                this.sendEphemeralResponse(userId, channelId, "\u274c Your Discord account is already linked to **" + player.getName() + "**!");
                return true;
            }
            String code = this.discordManager.generateLinkCode(userId);
            JSONObject embed = new JSONObject();
            embed.put((Object)"title", (Object)"\ud83d\udd17 Link Your Minecraft Account");
            embed.put((Object)"color", (Object)3900150);
            embed.put((Object)"description", (Object)("To link your Discord account with your Minecraft account:\n\n**1.** Join the Minecraft server\n**2.** Run this command in-game:\n```/auctionhouselink " + code + "```\n\n\u23f0 This code expires in **5 minutes**"));
            JSONObject footer = new JSONObject();
            footer.put((Object)"text", (Object)"Make sure you're logged into the correct Minecraft account!");
            embed.put((Object)"footer", (Object)footer);
            this.sendEphemeralEmbed(userId, channelId, embed);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error handling Discord link command: " + e.getMessage());
            this.sendEphemeralResponse(userId, channelId, "\u274c An error occurred. Please try again later.");
            return false;
        }
    }

    private boolean handleBalanceCommand(String userId, String channelId) {
        try {
            String minecraftUuid = this.discordManager.getLinkedMinecraftUuid(userId);
            if (minecraftUuid == null) {
                this.sendEphemeralResponse(userId, channelId, "\u274c Your Discord account is not linked! Use `/auctionhouselink` first.");
                return true;
            }
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(minecraftUuid));
            double balance = this.plugin.getEconomy().getBalance(player);
            String currencySymbol = this.plugin.getConfig().getString("currency-symbol", "$");
            JSONObject embed = new JSONObject();
            embed.put((Object)"title", (Object)"\ud83d\udcb0 Your Balance");
            embed.put((Object)"color", (Object)1096065);
            embed.put((Object)"description", (Object)String.format("**Player:** %s\n**Balance:** %s%.2f", player.getName(), currencySymbol, balance));
            JSONObject footer = new JSONObject();
            footer.put((Object)"text", (Object)"Balance synced with in-game economy");
            embed.put((Object)"footer", (Object)footer);
            this.sendEphemeralEmbed(userId, channelId, embed);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error handling Discord balance command: " + e.getMessage());
            this.sendEphemeralResponse(userId, channelId, "\u274c An error occurred. Please try again later.");
            return false;
        }
    }

    private boolean handlePurchaseButton(String userId, String auctionId) {
        try {
            String minecraftUuid = this.discordManager.getLinkedMinecraftUuid(userId);
            if (minecraftUuid == null) {
                this.sendButtonResponse(userId, "\u274c You need to link your account first! Use `/auctionhouselink`");
                return true;
            }
            boolean success = this.discordManager.processDiscordPurchase(userId, auctionId);
            if (success) {
                this.sendButtonResponse(userId, "\u2705 Purchase successful! Check in-game for your item.");
                this.scheduler.execute(() -> {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            } else {
                this.sendButtonResponse(userId, "\u274c Purchase failed. Item may no longer be available or you don't have enough money.");
            }
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error handling Discord purchase button: " + e.getMessage());
            this.sendButtonResponse(userId, "\u274c An error occurred. Please try again later.");
            return false;
        }
    }

    private void sendEphemeralResponse(String userId, String channelId, String message) {
        try {
            JSONObject response = new JSONObject();
            response.put((Object)"type", (Object)4);
            JSONObject data = new JSONObject();
            data.put((Object)"content", (Object)message);
            data.put((Object)"flags", (Object)64);
            response.put((Object)"data", (Object)data);
            this.sendInteractionResponse(response);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error sending ephemeral response: " + e.getMessage());
        }
    }

    private void sendEphemeralEmbed(String userId, String channelId, JSONObject embed) {
        try {
            JSONObject response = new JSONObject();
            response.put((Object)"type", (Object)4);
            JSONObject data = new JSONObject();
            JSONArray embeds = new JSONArray();
            embeds.add((Object)embed);
            data.put((Object)"embeds", (Object)embeds);
            data.put((Object)"flags", (Object)64);
            response.put((Object)"data", (Object)data);
            this.sendInteractionResponse(response);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error sending ephemeral embed: " + e.getMessage());
        }
    }

    private void sendButtonResponse(String userId, String message) {
        try {
            JSONObject response = new JSONObject();
            response.put((Object)"type", (Object)4);
            JSONObject data = new JSONObject();
            data.put((Object)"content", (Object)message);
            data.put((Object)"flags", (Object)64);
            response.put((Object)"data", (Object)data);
            this.sendInteractionResponse(response);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error sending button response: " + e.getMessage());
        }
    }

    private void sendInteractionResponse(JSONObject response) {
    }

    public void registerSlashCommands(String guildId) {
        try {
            JSONArray commands = new JSONArray();
            JSONObject linkCommand = new JSONObject();
            linkCommand.put((Object)"name", (Object)"auctionhouselink");
            linkCommand.put((Object)"description", (Object)"Link your Discord account with your Minecraft account");
            commands.add((Object)linkCommand);
            JSONObject balanceCommand = new JSONObject();
            balanceCommand.put((Object)"name", (Object)"auctionhousebalance");
            balanceCommand.put((Object)"description", (Object)"Check your in-game balance");
            commands.add((Object)balanceCommand);
            String url = guildId != null ? "https://discord.com/api/v10/applications/" + this.getBotApplicationId() + "/guilds/" + guildId + "/commands" : "https://discord.com/api/v10/applications/" + this.getBotApplicationId() + "/commands";
            this.sendDiscordApiRequest("PUT", url, commands.toJSONString());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error registering slash commands: " + e.getMessage());
        }
    }

    private String getBotApplicationId() {
        return "YOUR_BOT_APPLICATION_ID";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sendDiscordApiRequest(String method, String url, String jsonPayload) {
        try {
            int responseCode;
            URL apiUrl = new URL(url);
            HttpsURLConnection connection = (HttpsURLConnection)apiUrl.openConnection();
            connection.setRequestMethod(method);
            connection.setRequestProperty("Authorization", "Bot " + this.botToken);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            if (jsonPayload != null) {
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
            }
            if ((responseCode = connection.getResponseCode()) >= 200 && responseCode < 300) {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line;
                    StringBuilder response = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        response.append(line);
                    }
                    String string = response.toString();
                    return string;
                }
            }
            this.plugin.getLogger().warning("Discord API request failed with code: " + responseCode);
            return null;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Discord API request failed: " + e.getMessage());
        }
        return null;
    }
}

