/*
 * Decompiled with CFR 0.152.
 */
package com.auctionhouse.discord;

import com.auctionhouse.AuctionHouse;
import java.awt.Color;
import java.io.File;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.messages.AbstractMessageBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageEditBuilder;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class DiscordManager
extends ListenerAdapter {
    private final AuctionHouse plugin;
    private JDA jda;
    private final Map<String, String> pendingLinks = new ConcurrentHashMap<String, String>();
    private final Map<String, Long> linkExpiry = new ConcurrentHashMap<String, Long>();
    private Connection database;
    private ScheduledExecutorService scheduler;
    private boolean discordEnabled;
    private String transactionWebhookUrl;
    private String linkingChannelId;
    private String auctionChannelId;
    private String botToken;
    private int auctionUpdateInterval;
    private int maxItemsPerEmbed;
    private String auctionMessageId = null;

    public DiscordManager(AuctionHouse plugin) {
        this.plugin = plugin;
        this.loadDiscordConfig();
        if (this.discordEnabled && !this.botToken.isEmpty()) {
            this.initializeDatabase();
            this.startBot();
            this.startScheduler();
        }
    }

    private void loadDiscordConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.discordEnabled = config.getBoolean("discord.enabled", false);
        this.transactionWebhookUrl = config.getString("discord.transaction-webhook-url", "");
        this.linkingChannelId = config.getString("discord.linking-channel-id", "");
        this.auctionChannelId = config.getString("discord.auction-channel-id", "");
        this.botToken = config.getString("discord.bot-token", "");
        this.auctionUpdateInterval = config.getInt("discord.auction-update-interval", 1);
        this.maxItemsPerEmbed = config.getInt("discord.max-items-per-embed", 10);
    }

    public void reloadConfig() {
        this.loadDiscordConfig();
        if (this.discordEnabled && this.jda == null && !this.botToken.isEmpty()) {
            this.initializeDatabase();
            this.startBot();
            this.startScheduler();
        } else if (!this.discordEnabled && this.jda != null) {
            this.stopBot();
            this.stopScheduler();
        }
    }

    public boolean isDiscordEnabled() {
        return this.discordEnabled && this.jda != null;
    }

    private void startBot() {
        try {
            this.jda = JDABuilder.createDefault(this.botToken).addEventListeners(this).enableIntents(GatewayIntent.MESSAGE_CONTENT, new GatewayIntent[0]).build();
            this.jda.awaitReady();
            this.plugin.getLogger().info("Discord bot connected successfully!");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to start Discord bot: " + e.getMessage());
            this.discordEnabled = false;
        }
    }

    private void stopBot() {
        if (this.jda != null) {
            this.jda.shutdown();
            this.jda = null;
        }
    }

    private void initializeDatabase() {
        try {
            File dbFile = new File(this.plugin.getDataFolder(), "discord_links.db");
            this.database = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
            String createLinksTable = "CREATE TABLE IF NOT EXISTS discord_links (id INTEGER PRIMARY KEY AUTOINCREMENT,minecraft_uuid TEXT UNIQUE NOT NULL,discord_user_id TEXT UNIQUE NOT NULL,minecraft_username TEXT NOT NULL,linked_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)";
            Statement stmt = this.database.createStatement();
            stmt.executeUpdate(createLinksTable);
            stmt.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to initialize Discord database: " + e.getMessage());
            this.discordEnabled = false;
        }
    }

    private void startScheduler() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
        this.scheduler = Executors.newScheduledThreadPool(2);
        if (!this.auctionChannelId.isEmpty()) {
            this.scheduler.scheduleAtFixedRate(this::updateAuctionEmbed, 30L, this.auctionUpdateInterval * 60, TimeUnit.SECONDS);
        }
        this.scheduler.scheduleAtFixedRate(this::cleanupExpiredLinks, 5L, 5L, TimeUnit.MINUTES);
    }

    private void stopScheduler() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
    }

    public void shutdown() {
        this.stopScheduler();
        this.stopBot();
        try {
            if (this.database != null && !this.database.isClosed()) {
                this.database.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error closing Discord database: " + e.getMessage());
        }
    }

    @Override
    public void onMessageReceived(MessageReceivedEvent event) {
        if (event.getAuthor().isBot()) {
            return;
        }
        String message = event.getMessage().getContentRaw();
        String channelId = event.getChannel().getId();
        String userId = event.getAuthor().getId();
        if (this.linkingChannelId.equals(channelId)) {
            if (message.startsWith("!auctionhouselink")) {
                this.handleLinkCommand(event);
            } else if (message.startsWith("!auctionhousebalance")) {
                this.handleBalanceCommand(event);
            }
        }
    }

    @Override
    public void onButtonInteraction(ButtonInteractionEvent event) {
        if (event.getComponentId().startsWith("buy_")) {
            String auctionId = event.getComponentId().substring(4);
            this.handlePurchaseButton(event, auctionId);
        }
    }

    private void handleLinkCommand(MessageReceivedEvent event) {
        String userId = event.getAuthor().getId();
        String existingUuid = this.getLinkedMinecraftUuid(userId);
        if (existingUuid != null) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(existingUuid));
            event.getChannel().sendMessage("\u274c Your Discord account is already linked to **" + player.getName() + "**!").queue();
            return;
        }
        String code = this.generateLinkCode(userId);
        EmbedBuilder embed = new EmbedBuilder();
        embed.setTitle("\ud83d\udd17 Link Your Minecraft Account");
        embed.setColor(Color.BLUE);
        embed.setDescription("To link your Discord account with your Minecraft account:\n\n**1.** Join the Minecraft server\n**2.** Run this command in-game:\n```/auctionhouselink " + code + "```\n\n\u23f0 This code expires in **5 minutes**");
        embed.setFooter("Make sure you're logged into the correct Minecraft account!");
        event.getChannel().sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
    }

    private void handleBalanceCommand(MessageReceivedEvent event) {
        String userId = event.getAuthor().getId();
        String minecraftUuid = this.getLinkedMinecraftUuid(userId);
        if (minecraftUuid == null) {
            event.getChannel().sendMessage("\u274c Your Discord account is not linked! Use `!auctionhouselink` first.").queue();
            return;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(minecraftUuid));
        double balance = this.plugin.getEconomy().getBalance(player);
        String currencySymbol = this.plugin.getConfig().getString("currency-symbol", "$");
        EmbedBuilder embed = new EmbedBuilder();
        embed.setTitle("\ud83d\udcb0 Your Balance");
        embed.setColor(Color.GREEN);
        embed.setDescription(String.format("**Player:** %s\n**Balance:** %s%.2f", player.getName(), currencySymbol, balance));
        embed.setFooter("Balance synced with in-game economy");
        event.getChannel().sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
    }

    private void handlePurchaseButton(ButtonInteractionEvent event, String auctionId) {
        String userId = event.getUser().getId();
        String minecraftUuid = this.getLinkedMinecraftUuid(userId);
        if (minecraftUuid == null) {
            event.reply("\u274c You need to link your account first! Use `!auctionhouselink`").setEphemeral(true).queue();
            return;
        }
        boolean success = this.processDiscordPurchase(userId, auctionId);
        if (success) {
            event.reply("\u2705 Purchase successful! Check in-game for your item.").setEphemeral(true).queue();
            this.scheduler.schedule(this::updateAuctionEmbed, 2L, TimeUnit.SECONDS);
        } else {
            event.reply("\u274c Purchase failed. Item may no longer be available or you don't have enough money.").setEphemeral(true).queue();
        }
    }

    public String generateLinkCode(String discordUserId) {
        String code = this.generateRandomString(8);
        this.pendingLinks.put(discordUserId, code);
        this.linkExpiry.put(discordUserId, System.currentTimeMillis() + 300000L);
        return code;
    }

    public boolean linkAccount(Player player, String code) {
        for (Map.Entry<String, String> entry : this.pendingLinks.entrySet()) {
            String discordUserId;
            Long expiry;
            if (!entry.getValue().equals(code) || (expiry = this.linkExpiry.get(discordUserId = entry.getKey())) == null || System.currentTimeMillis() >= expiry) continue;
            try {
                String checkExisting = "SELECT discord_user_id FROM discord_links WHERE minecraft_uuid = ? OR discord_user_id = ?";
                PreparedStatement checkStmt = this.database.prepareStatement(checkExisting);
                checkStmt.setString(1, player.getUniqueId().toString());
                checkStmt.setString(2, discordUserId);
                ResultSet rs = checkStmt.executeQuery();
                if (rs.next()) {
                    rs.close();
                    checkStmt.close();
                    return false;
                }
                rs.close();
                checkStmt.close();
                String insertLink = "INSERT INTO discord_links (minecraft_uuid, discord_user_id, minecraft_username) VALUES (?, ?, ?)";
                PreparedStatement stmt = this.database.prepareStatement(insertLink);
                stmt.setString(1, player.getUniqueId().toString());
                stmt.setString(2, discordUserId);
                stmt.setString(3, player.getName());
                stmt.executeUpdate();
                stmt.close();
                this.pendingLinks.remove(discordUserId);
                this.linkExpiry.remove(discordUserId);
                return true;
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error linking Discord account: " + e.getMessage());
            }
        }
        return false;
    }

    public String getLinkedDiscordId(String minecraftUuid) {
        try {
            String query = "SELECT discord_user_id FROM discord_links WHERE minecraft_uuid = ?";
            PreparedStatement stmt = this.database.prepareStatement(query);
            stmt.setString(1, minecraftUuid);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String discordId = rs.getString("discord_user_id");
                rs.close();
                stmt.close();
                return discordId;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error getting linked Discord ID: " + e.getMessage());
        }
        return null;
    }

    public String getLinkedMinecraftUuid(String discordUserId) {
        try {
            String query = "SELECT minecraft_uuid FROM discord_links WHERE discord_user_id = ?";
            PreparedStatement stmt = this.database.prepareStatement(query);
            stmt.setString(1, discordUserId);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String uuid = rs.getString("minecraft_uuid");
                rs.close();
                stmt.close();
                return uuid;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error getting linked Minecraft UUID: " + e.getMessage());
        }
        return null;
    }

    public boolean processDiscordPurchase(String discordUserId, String auctionId) {
        String minecraftUuid = this.getLinkedMinecraftUuid(discordUserId);
        if (minecraftUuid == null) {
            return false;
        }
        ConfigurationSection auctionsSection = this.plugin.getAuctionData().getConfigurationSection("auctions");
        if (auctionsSection == null || !auctionsSection.contains(auctionId)) {
            return false;
        }
        String sellerUUID = auctionsSection.getString(auctionId + ".seller");
        if (sellerUUID.equals(minecraftUuid)) {
            return false;
        }
        double price = auctionsSection.getDouble(auctionId + ".price");
        String sellerName = auctionsSection.getString(auctionId + ".sellerName");
        ItemStack item = auctionsSection.getItemStack(auctionId + ".item");
        OfflinePlayer buyer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(minecraftUuid));
        if (this.plugin.getEconomy().getBalance(buyer) < price) {
            return false;
        }
        this.plugin.getEconomy().withdrawPlayer(buyer, price);
        this.plugin.getEconomy().depositPlayer(Bukkit.getOfflinePlayer((UUID)UUID.fromString(sellerUUID)), price);
        Player onlinePlayer = Bukkit.getPlayer((UUID)UUID.fromString(minecraftUuid));
        if (onlinePlayer != null) {
            HashMap leftover = onlinePlayer.getInventory().addItem(new ItemStack[]{item});
            if (!leftover.isEmpty()) {
                for (ItemStack leftoverItem : leftover.values()) {
                    onlinePlayer.getWorld().dropItemNaturally(onlinePlayer.getLocation(), leftoverItem);
                }
            }
            onlinePlayer.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7aYou purchased an item via Discord for " + this.plugin.getConfig().getString("currency-symbol", "$") + String.format("%.2f", price) + "!");
        } else if (this.plugin.getWebManager() != null) {
            this.plugin.getWebManager().storePendingPurchase(minecraftUuid, item, price);
        }
        auctionsSection.set(auctionId, null);
        this.plugin.saveAuctionData();
        Player sellerPlayer = Bukkit.getPlayer((UUID)UUID.fromString(sellerUUID));
        if (sellerPlayer != null && sellerPlayer.isOnline()) {
            sellerPlayer.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7aYour item was sold via Discord for " + this.plugin.getConfig().getString("currency-symbol", "$") + String.format("%.2f", price) + ".");
        }
        this.logTransaction(buyer.getName(), sellerName, item, price, "Discord");
        return true;
    }

    public void logTransaction(String buyerName, String sellerName, ItemStack item, double price) {
        this.logTransaction(buyerName, sellerName, item, price, "In-Game");
    }

    public void logTransaction(String buyerName, String sellerName, ItemStack item, double price, String source2) {
        if (!this.isDiscordEnabled() || this.auctionChannelId.isEmpty()) {
            return;
        }
        TextChannel channel = this.jda.getTextChannelById(this.auctionChannelId);
        if (channel == null) {
            this.plugin.getLogger().warning("Transaction log channel not found: " + this.auctionChannelId);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                EmbedBuilder embed = new EmbedBuilder();
                embed.setTitle("\ud83d\udcb0 Transaction Completed");
                embed.setColor(this.getSourceColorInt(source2));
                embed.setTimestamp(Instant.now());
                String itemName = this.getItemDisplayName(item);
                String currencySymbol = this.plugin.getConfig().getString("currency-symbol", "$");
                StringBuilder description = new StringBuilder();
                description.append(String.format("**%s** purchased **%s** x%d from **%s**\n\n", buyerName, itemName, item.getAmount(), sellerName));
                description.append(String.format("\ud83d\udcb0 **Price:** %s%.2f\n", currencySymbol, price));
                description.append(String.format("\ud83d\udcf1 **Source:** %s %s", this.getSourceEmoji(source2), source2));
                ItemMeta meta = item.getItemMeta();
                if (meta != null && meta.hasLore() && meta.getLore().size() <= 5) {
                    description.append("\n\n**Item Details:**\n");
                    for (String loreLine : meta.getLore()) {
                        if (description.length() > 1800) break;
                        description.append(loreLine).append("\n");
                    }
                }
                embed.setDescription(description.toString());
                embed.setFooter("AuctionHouse Plus \u2022 Transaction Log", null);
                channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue(success -> this.plugin.getLogger().info("Transaction logged to Discord: " + buyerName + " -> " + sellerName), error -> this.plugin.getLogger().warning("Failed to log transaction to Discord: " + error.getMessage()));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to send Discord transaction log: " + e.getMessage());
            }
        });
    }

    private int getSourceColorInt(String source2) {
        switch (source2.toLowerCase()) {
            case "in-game": {
                return 1096065;
            }
            case "web": {
                return 3900150;
            }
            case "discord": {
                return 8141549;
            }
        }
        return 7041664;
    }

    private int getSourceColor(String source2) {
        switch (source2.toLowerCase()) {
            case "in-game": {
                return 1096065;
            }
            case "web": {
                return 3900150;
            }
            case "discord": {
                return 8141549;
            }
        }
        return 7041664;
    }

    private String getSourceEmoji(String source2) {
        switch (source2.toLowerCase()) {
            case "in-game": {
                return "\ud83c\udfae";
            }
            case "web": {
                return "\ud83c\udf10";
            }
            case "discord": {
                return "\ud83d\udcac";
            }
        }
        return "\u2753";
    }

    private void updateAuctionEmbed() {
        if (!this.isDiscordEnabled() || this.auctionChannelId.isEmpty()) {
            return;
        }
        TextChannel channel = this.jda.getTextChannelById(this.auctionChannelId);
        if (channel == null) {
            this.plugin.getLogger().warning("Auction channel not found: " + this.auctionChannelId);
            return;
        }
        try {
            ConfigurationSection auctionsSection = this.plugin.getAuctionData().getConfigurationSection("auctions");
            EmbedBuilder embed = new EmbedBuilder();
            embed.setTitle("\ud83c\udfdb\ufe0f Live Auction House");
            embed.setColor(Color.BLUE);
            embed.setTimestamp(Instant.now());
            StringBuilder description = new StringBuilder();
            ArrayList<Button> buttons = new ArrayList<Button>();
            if (auctionsSection == null || auctionsSection.getKeys(false).isEmpty()) {
                description.append("*No items currently listed*");
            } else {
                description.append("**Active Listings:**\n\n");
                ArrayList auctionIds = new ArrayList(auctionsSection.getKeys(false));
                int itemCount = 0;
                for (String string : auctionIds) {
                    if (itemCount >= this.maxItemsPerEmbed) break;
                    ItemStack item = auctionsSection.getItemStack(string + ".item");
                    double price = auctionsSection.getDouble(string + ".price");
                    String sellerName = auctionsSection.getString(string + ".sellerName");
                    long expiresAt = auctionsSection.getLong(string + ".expiresAt");
                    String itemName = this.getItemDisplayName(item);
                    String timeLeft = this.formatTimeLeft(expiresAt - System.currentTimeMillis());
                    description.append(String.format("**%d. %s** x%d\n", ++itemCount, itemName, item.getAmount()));
                    description.append(String.format("\ud83d\udcb0 %s%.2f | \ud83d\udc64 %s | \u23f0 %s\n\n", this.plugin.getConfig().getString("currency-symbol", "$"), price, sellerName, timeLeft));
                    Button button = Button.success("buy_" + string, String.valueOf(itemCount)).withEmoji(Emoji.fromUnicode("\ud83d\udcb0"));
                    buttons.add(button);
                }
                if (auctionIds.size() > this.maxItemsPerEmbed) {
                    description.append(String.format("*... and %d more items*", auctionIds.size() - this.maxItemsPerEmbed));
                }
            }
            embed.setDescription(description.toString());
            embed.setFooter("Updates every " + this.auctionUpdateInterval + " minute(s) \u2022 Use buttons to purchase");
            MessageCreateBuilder messageBuilder = (MessageCreateBuilder)new MessageCreateBuilder().setEmbeds(embed.build());
            if (!buttons.isEmpty()) {
                ArrayList buttonRows = new ArrayList();
                for (int i = 0; i < buttons.size(); i += 5) {
                    buttonRows.add(buttons.subList(i, Math.min(i + 5, buttons.size())));
                }
                for (List list : buttonRows) {
                    messageBuilder.addActionRow(list);
                }
            }
            if (this.auctionMessageId == null) {
                channel.sendMessage(messageBuilder.build()).queue(message -> {
                    this.auctionMessageId = message.getId();
                });
            } else {
                channel.retrieveMessageById(this.auctionMessageId).queue(message -> {
                    AbstractMessageBuilder editBuilder = ((MessageEditBuilder)new MessageEditBuilder().setEmbeds(embed.build())).setComponents(messageBuilder.getComponents());
                    message.editMessage(((MessageEditBuilder)editBuilder).build()).queue();
                }, throwable -> {
                    this.auctionMessageId = null;
                    this.updateAuctionEmbed();
                });
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to update auction embed: " + e.getMessage());
        }
    }

    private void sendWebhookRequest(String webhookUrl, Map<String, Object> payload) {
        try {
            URL url = new URL(webhookUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            String jsonPayload = this.convertMapToJson(payload);
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            if (responseCode < 200 || responseCode >= 300) {
                this.plugin.getLogger().warning("Webhook request failed with response code: " + responseCode);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to send webhook request: " + e.getMessage());
        }
    }

    private String convertMapToJson(Map<String, Object> map) {
        try {
            StringBuilder json = new StringBuilder("{");
            boolean first = true;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (!first) {
                    json.append(",");
                }
                first = false;
                json.append("\"").append(entry.getKey()).append("\":");
                Object value = entry.getValue();
                if (value instanceof String) {
                    String stringValue = (String)value;
                    json.append("\"").append(stringValue.replace("\"", "\\\"")).append("\"");
                    continue;
                }
                if (value instanceof Number) {
                    json.append(value.toString());
                    continue;
                }
                if (value instanceof List) {
                    json.append("[");
                    List list = (List)value;
                    for (int i = 0; i < list.size(); ++i) {
                        Object item;
                        if (i > 0) {
                            json.append(",");
                        }
                        if ((item = list.get(i)) instanceof Map) {
                            Map mapItem = (Map)item;
                            json.append(this.convertMapToJson(mapItem));
                            continue;
                        }
                        if (item instanceof String) {
                            json.append("\"").append(item.toString()).append("\"");
                            continue;
                        }
                        json.append("\"").append(item.toString()).append("\"");
                    }
                    json.append("]");
                    continue;
                }
                if (value instanceof Map) {
                    Map mapValue = (Map)value;
                    json.append(this.convertMapToJson(mapValue));
                    continue;
                }
                json.append("\"").append(value.toString()).append("\"");
            }
            json.append("}");
            return json.toString();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error converting map to JSON: " + e.getMessage());
            return "{}";
        }
    }

    private String getItemDisplayName(ItemStack item) {
        if (item == null) {
            return "Unknown Item";
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            return meta.getDisplayName();
        }
        String[] words = item.getType().name().toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String word;
            if (i > 0) {
                result.append(" ");
            }
            if ((word = words[i]).length() <= 0) continue;
            result.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() <= 1) continue;
            result.append(word.substring(1));
        }
        return result.toString();
    }

    private String formatTimeLeft(long milliseconds) {
        if (milliseconds <= 0L) {
            return "Expired";
        }
        long days = TimeUnit.MILLISECONDS.toDays(milliseconds);
        long hours = TimeUnit.MILLISECONDS.toHours(milliseconds) % 24L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(milliseconds) % 60L;
        if (days > 0L) {
            return String.format("%dd %dh", days, hours);
        }
        if (hours > 0L) {
            return String.format("%dh %dm", hours, minutes);
        }
        return String.format("%dm", minutes);
    }

    private String generateRandomString(int length) {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(chars.charAt(random.nextInt(chars.length())));
        }
        return sb.toString();
    }

    private void cleanupExpiredLinks() {
        long currentTime = System.currentTimeMillis();
        this.linkExpiry.entrySet().removeIf(entry -> {
            if (currentTime > (Long)entry.getValue()) {
                this.pendingLinks.remove(entry.getKey());
                return true;
            }
            return false;
        });
    }
}

