/*
 * Decompiled with CFR 0.152.
 */
package com.auctionhouse.web;

import com.auctionhouse.AuctionHouse;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.ShulkerBox;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class WebManager {
    private final AuctionHouse plugin;
    private HttpServer server;
    private Connection database;
    private final Map<String, String> pendingVerifications = new ConcurrentHashMap<String, String>();
    private final Map<String, Long> verificationExpiry = new ConcurrentHashMap<String, Long>();
    private final Map<String, String> verifiedUsers = new ConcurrentHashMap<String, String>();
    private FileConfiguration webConfig;
    private int port;
    private String webTitle;
    private String primaryColor;
    private String secondaryColor;
    private String backgroundColor;
    private String textColor;
    private int sessionTimeout;
    private int verificationTimeout;
    private boolean allowRegistration;
    private boolean allowWebPurchase;
    private boolean enableTextures;
    private String textureSource;
    private String blockTextureSource;
    private int autoRefreshInterval;
    private String currencySymbol;

    public WebManager(AuctionHouse plugin) {
        this.plugin = plugin;
        this.loadWebConfig();
        this.initializeDatabase();
    }

    private void loadWebConfig() {
        File webConfigFile = new File(this.plugin.getDataFolder(), "web-config.yml");
        if (!webConfigFile.exists()) {
            this.plugin.saveResource("web-config.yml", false);
        }
        this.webConfig = YamlConfiguration.loadConfiguration((File)webConfigFile);
        this.port = this.webConfig.getInt("web.port", 8080);
        this.webTitle = this.webConfig.getString("web.title", "AuctionHouse Plus");
        this.primaryColor = this.webConfig.getString("web.theme.primary-color", "#3b82f6");
        this.secondaryColor = this.webConfig.getString("web.theme.secondary-color", "#1e40af");
        this.backgroundColor = this.webConfig.getString("web.theme.background-color", "#0f172a");
        this.textColor = this.webConfig.getString("web.theme.text-color", "#f1f5f9");
        this.sessionTimeout = this.webConfig.getInt("security.session-timeout", 24);
        this.verificationTimeout = this.webConfig.getInt("security.verification-timeout", 5);
        this.allowRegistration = this.webConfig.getBoolean("features.allow-registration", true);
        this.allowWebPurchase = this.webConfig.getBoolean("features.allow-web-purchase", true);
        this.enableTextures = this.webConfig.getBoolean("items.enable-textures", true);
        this.textureSource = this.webConfig.getString("items.texture-source", "https://raw.githubusercontent.com/InventivetalentDev/minecraft-assets/1.21/assets/minecraft/textures/item/");
        this.blockTextureSource = this.webConfig.getString("items.block-texture-source", "https://raw.githubusercontent.com/InventivetalentDev/minecraft-assets/1.21/assets/minecraft/textures/block/");
        this.autoRefreshInterval = this.webConfig.getInt("features.auto-refresh-interval", 30);
        this.currencySymbol = this.plugin.getConfig().getString("currency-symbol", "$");
    }

    public void reloadConfig() {
        this.loadWebConfig();
    }

    public int getPort() {
        return this.port;
    }

    public int getRegisteredUserCount() {
        try {
            String query = "SELECT COUNT(*) FROM users";
            PreparedStatement stmt = this.database.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                return rs.getInt(1);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error getting user count: " + e.getMessage());
        }
        return 0;
    }

    private void initializeDatabase() {
        try {
            File dbFile = new File(this.plugin.getDataFolder(), "web_users.db");
            this.database = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
            String createUsersTable = "CREATE TABLE IF NOT EXISTS users (id INTEGER PRIMARY KEY AUTOINCREMENT,username TEXT UNIQUE NOT NULL,password_hash TEXT NOT NULL,minecraft_uuid TEXT UNIQUE NOT NULL,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,last_login TIMESTAMP DEFAULT CURRENT_TIMESTAMP)";
            String createSessionsTable = "CREATE TABLE IF NOT EXISTS sessions (id INTEGER PRIMARY KEY AUTOINCREMENT,user_id INTEGER,session_token TEXT UNIQUE NOT NULL,expires_at TIMESTAMP NOT NULL,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,FOREIGN KEY (user_id) REFERENCES users (id))";
            String createPendingPurchasesTable = "CREATE TABLE IF NOT EXISTS pending_purchases (id INTEGER PRIMARY KEY AUTOINCREMENT,player_uuid TEXT NOT NULL,item_data BLOB NOT NULL,price REAL NOT NULL,purchase_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP)";
            String createPendingReturnsTable = "CREATE TABLE IF NOT EXISTS pending_returns (id INTEGER PRIMARY KEY AUTOINCREMENT,player_uuid TEXT NOT NULL,item_data BLOB NOT NULL,reason TEXT NOT NULL,return_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP)";
            Statement stmt = this.database.createStatement();
            stmt.executeUpdate(createUsersTable);
            stmt.executeUpdate(createSessionsTable);
            stmt.executeUpdate(createPendingPurchasesTable);
            stmt.executeUpdate(createPendingReturnsTable);
            stmt.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to initialize web database: " + e.getMessage());
        }
    }

    public void deliverPendingPurchases(Player player) {
        try {
            String selectPurchases = "SELECT id, item_data, price FROM pending_purchases WHERE player_uuid = ?";
            PreparedStatement selectStmt = this.database.prepareStatement(selectPurchases);
            selectStmt.setString(1, player.getUniqueId().toString());
            ResultSet rs = selectStmt.executeQuery();
            ArrayList<Integer> deliveredIds = new ArrayList<Integer>();
            while (rs.next()) {
                int id = rs.getInt("id");
                byte[] itemData = rs.getBytes("item_data");
                double price = rs.getDouble("price");
                try {
                    ItemStack item = this.deserializeItemStack(itemData);
                    HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
                    if (leftover.isEmpty()) {
                        deliveredIds.add(id);
                        player.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7aYou received an item purchased via web interface for " + this.currencySymbol + String.format("%.2f", price) + "!");
                        continue;
                    }
                    player.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7eYou have pending web purchases! Free up inventory space to receive them.");
                    break;
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to deliver pending purchase " + id + " to " + player.getName() + ": " + e.getMessage());
                    deliveredIds.add(id);
                }
            }
            rs.close();
            selectStmt.close();
            if (!deliveredIds.isEmpty()) {
                String deletePurchases = "DELETE FROM pending_purchases WHERE id IN (" + String.join((CharSequence)",", Collections.nCopies(deliveredIds.size(), "?")) + ")";
                PreparedStatement deleteStmt = this.database.prepareStatement(deletePurchases);
                for (int i = 0; i < deliveredIds.size(); ++i) {
                    deleteStmt.setInt(i + 1, (Integer)deliveredIds.get(i));
                }
                deleteStmt.executeUpdate();
                deleteStmt.close();
            }
            String selectReturns = "SELECT id, item_data, reason FROM pending_returns WHERE player_uuid = ?";
            PreparedStatement returnStmt = this.database.prepareStatement(selectReturns);
            returnStmt.setString(1, player.getUniqueId().toString());
            ResultSet returnRs = returnStmt.executeQuery();
            ArrayList<Integer> returnedIds = new ArrayList<Integer>();
            while (returnRs.next()) {
                int id = returnRs.getInt("id");
                byte[] itemData = returnRs.getBytes("item_data");
                String reason = returnRs.getString("reason");
                try {
                    ItemStack item = this.deserializeItemStack(itemData);
                    HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
                    if (leftover.isEmpty()) {
                        returnedIds.add(id);
                        player.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7aYour listing was cancelled via web interface. Item returned to inventory.");
                        continue;
                    }
                    player.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7eYou have pending returned items! Free up inventory space to receive them.");
                    break;
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to deliver pending return " + id + " to " + player.getName() + ": " + e.getMessage());
                    returnedIds.add(id);
                }
            }
            returnRs.close();
            returnStmt.close();
            if (!returnedIds.isEmpty()) {
                String deleteReturns = "DELETE FROM pending_returns WHERE id IN (" + String.join((CharSequence)",", Collections.nCopies(returnedIds.size(), "?")) + ")";
                PreparedStatement deleteReturnStmt = this.database.prepareStatement(deleteReturns);
                for (int i = 0; i < returnedIds.size(); ++i) {
                    deleteReturnStmt.setInt(i + 1, (Integer)returnedIds.get(i));
                }
                deleteReturnStmt.executeUpdate();
                deleteReturnStmt.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error delivering pending items: " + e.getMessage());
        }
    }

    private byte[] serializeItemStack(ItemStack item) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(item.serialize());
            oos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Error serializing item: " + e.getMessage());
            return null;
        }
    }

    private ItemStack deserializeItemStack(byte[] data) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Map serialized = (Map)ois.readObject();
            ois.close();
            return ItemStack.deserialize((Map)serialized);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error deserializing item: " + e.getMessage());
            return null;
        }
    }

    public void startWebServer() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            this.server.setExecutor(Executors.newFixedThreadPool(10));
            this.server.createContext("/api/register", new RegisterHandler());
            this.server.createContext("/api/verify", new VerifyHandler());
            this.server.createContext("/api/login", new LoginHandler());
            this.server.createContext("/api/logout", new LogoutHandler());
            this.server.createContext("/api/auctions", new AuctionsHandler());
            this.server.createContext("/api/purchase", new PurchaseHandler());
            this.server.createContext("/api/user", new UserHandler());
            this.server.createContext("/api/my-listings", new MyListingsHandler());
            this.server.createContext("/api/cancel-listing", new CancelListingHandler());
            this.server.createContext("/favicon.ico", new FaviconHandler());
            this.server.createContext("/", new StaticFileHandler());
            this.server.start();
            this.plugin.getLogger().info("Web server started on port " + this.port);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to start web server: " + e.getMessage());
        }
    }

    public void stopWebServer() {
        if (this.server != null) {
            this.server.stop(0);
            this.plugin.getLogger().info("Web server stopped");
        }
        try {
            if (this.database != null && !this.database.isClosed()) {
                this.database.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error closing database: " + e.getMessage());
        }
    }

    public String generateVerificationCode(String username) {
        String code = this.generateRandomString(16);
        this.pendingVerifications.put(username.toLowerCase(), code);
        this.verificationExpiry.put(username.toLowerCase(), System.currentTimeMillis() + (long)(this.verificationTimeout * 60 * 1000));
        return code;
    }

    public void storePendingPurchase(String playerUuid, ItemStack item, double price) {
        try {
            byte[] itemData = this.serializeItemStack(item);
            if (itemData != null) {
                String insertPurchase = "INSERT INTO pending_purchases (player_uuid, item_data, price) VALUES (?, ?, ?)";
                PreparedStatement stmt = this.database.prepareStatement(insertPurchase);
                stmt.setString(1, playerUuid);
                stmt.setBytes(2, itemData);
                stmt.setDouble(3, price);
                stmt.executeUpdate();
                stmt.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error storing pending purchase: " + e.getMessage());
        }
    }

    public boolean verifyUser(String username, String code, String uuid) {
        String storedCode = this.pendingVerifications.get(username.toLowerCase());
        Long expiry = this.verificationExpiry.get(username.toLowerCase());
        if (storedCode == null || expiry == null || System.currentTimeMillis() > expiry) {
            return false;
        }
        if (storedCode.equals(code)) {
            this.pendingVerifications.remove(username.toLowerCase());
            this.verificationExpiry.remove(username.toLowerCase());
            this.verifiedUsers.put(username.toLowerCase(), uuid);
            return true;
        }
        return false;
    }

    public void markUserAsVerified(String username, String uuid) {
        this.verifiedUsers.put(username.toLowerCase(), uuid);
    }

    private String generateRandomString(int length) {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(chars.charAt(random.nextInt(chars.length())));
        }
        return sb.toString();
    }

    private String hashPassword(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(password.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error hashing password: " + e.getMessage());
            return null;
        }
    }

    private String formatCurrency(double amount) {
        return this.currencySymbol + String.format("%.2f", amount);
    }

    private String getItemTexture(String itemType) {
        if (!this.enableTextures) {
            return null;
        }
        String itemName = itemType.toLowerCase();
        return this.textureSource + itemName + ".png";
    }

    private String getUserUUIDFromSession(String sessionToken) {
        try {
            String selectUser = "SELECT u.minecraft_uuid FROM users u JOIN sessions s ON u.id = s.user_id WHERE s.session_token = ? AND s.expires_at > ?";
            PreparedStatement stmt = this.database.prepareStatement(selectUser);
            stmt.setString(1, sessionToken);
            stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String uuid = rs.getString("minecraft_uuid");
                rs.close();
                stmt.close();
                return uuid;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error getting UUID from session: " + e.getMessage());
        }
        return null;
    }

    private String getSessionToken(HttpExchange exchange) {
        String authHeader = exchange.getRequestHeaders().getFirst("Authorization");
        if (authHeader != null && authHeader.startsWith("Bearer ")) {
            return authHeader.substring(7);
        }
        return null;
    }

    private void sendResponse(HttpExchange exchange, int statusCode, String response) throws IOException {
        byte[] responseBytes = response.getBytes(StandardCharsets.UTF_8);
        exchange.sendResponseHeaders(statusCode, responseBytes.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(responseBytes);
        }
    }

    private void sendJsonResponse(HttpExchange exchange, int statusCode, String jsonResponse) throws IOException {
        exchange.getResponseHeaders().set("Content-Type", "application/json");
        exchange.getResponseHeaders().set("Access-Control-Allow-Origin", "*");
        exchange.getResponseHeaders().set("Access-Control-Allow-Methods", "GET, POST, OPTIONS");
        exchange.getResponseHeaders().set("Access-Control-Allow-Headers", "Content-Type, Authorization");
        this.sendResponse(exchange, statusCode, jsonResponse);
    }

    public int getPendingItemCount(Player player) {
        try {
            int total = 0;
            String countPurchases = "SELECT COUNT(*) FROM pending_purchases WHERE player_uuid = ?";
            PreparedStatement stmt1 = this.database.prepareStatement(countPurchases);
            stmt1.setString(1, player.getUniqueId().toString());
            ResultSet rs1 = stmt1.executeQuery();
            if (rs1.next()) {
                total += rs1.getInt(1);
            }
            rs1.close();
            stmt1.close();
            String countReturns = "SELECT COUNT(*) FROM pending_returns WHERE player_uuid = ?";
            PreparedStatement stmt2 = this.database.prepareStatement(countReturns);
            stmt2.setString(1, player.getUniqueId().toString());
            ResultSet rs2 = stmt2.executeQuery();
            if (rs2.next()) {
                total += rs2.getInt(1);
            }
            rs2.close();
            stmt2.close();
            return total;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error getting pending item count: " + e.getMessage());
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void claimPendingItems(Player player) {
        try {
            this.database.setAutoCommit(false);
            int totalClaimed = 0;
            int totalDropped = 0;
            ArrayList<Integer> claimedPurchases = new ArrayList<Integer>();
            ArrayList<Integer> claimedReturns = new ArrayList<Integer>();
            String selectPurchases = "SELECT id, item_data, price FROM pending_purchases WHERE player_uuid = ? ORDER BY id";
            PreparedStatement purchaseStmt = this.database.prepareStatement(selectPurchases);
            purchaseStmt.setString(1, player.getUniqueId().toString());
            ResultSet purchaseRs = purchaseStmt.executeQuery();
            while (purchaseRs.next()) {
                int id = purchaseRs.getInt("id");
                byte[] itemData = purchaseRs.getBytes("item_data");
                double price = purchaseRs.getDouble("price");
                try {
                    ItemStack item = this.deserializeItemStack(itemData);
                    if (item == null || item.getType().name().equals("AIR")) {
                        claimedPurchases.add(id);
                        continue;
                    }
                    HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
                    if (leftover.isEmpty()) {
                        ++totalClaimed;
                    } else {
                        for (ItemStack leftoverItem : leftover.values()) {
                            player.getWorld().dropItemNaturally(player.getLocation(), leftoverItem);
                        }
                        ++totalDropped;
                    }
                    claimedPurchases.add(id);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to process purchase claim ID " + id + ": " + e.getMessage());
                    claimedPurchases.add(id);
                }
            }
            purchaseRs.close();
            purchaseStmt.close();
            String selectReturns = "SELECT id, item_data FROM pending_returns WHERE player_uuid = ? ORDER BY id";
            PreparedStatement returnStmt = this.database.prepareStatement(selectReturns);
            returnStmt.setString(1, player.getUniqueId().toString());
            ResultSet returnRs = returnStmt.executeQuery();
            while (returnRs.next()) {
                int id = returnRs.getInt("id");
                byte[] itemData = returnRs.getBytes("item_data");
                try {
                    ItemStack item = this.deserializeItemStack(itemData);
                    if (item == null || item.getType().name().equals("AIR")) {
                        claimedReturns.add(id);
                        continue;
                    }
                    HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
                    if (leftover.isEmpty()) {
                        ++totalClaimed;
                    } else {
                        for (ItemStack leftoverItem : leftover.values()) {
                            player.getWorld().dropItemNaturally(player.getLocation(), leftoverItem);
                        }
                        ++totalDropped;
                    }
                    claimedReturns.add(id);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to process return claim ID " + id + ": " + e.getMessage());
                    claimedReturns.add(id);
                }
            }
            returnRs.close();
            returnStmt.close();
            if (!claimedPurchases.isEmpty()) {
                StringBuilder deletePurchases = new StringBuilder("DELETE FROM pending_purchases WHERE id IN (");
                for (int i = 0; i < claimedPurchases.size(); ++i) {
                    if (i > 0) {
                        deletePurchases.append(",");
                    }
                    deletePurchases.append("?");
                }
                deletePurchases.append(")");
                PreparedStatement deleteStmt = this.database.prepareStatement(deletePurchases.toString());
                for (int i = 0; i < claimedPurchases.size(); ++i) {
                    deleteStmt.setInt(i + 1, (Integer)claimedPurchases.get(i));
                }
                deleteStmt.executeUpdate();
                deleteStmt.close();
            }
            if (!claimedReturns.isEmpty()) {
                StringBuilder deleteReturns = new StringBuilder("DELETE FROM pending_returns WHERE id IN (");
                for (int i = 0; i < claimedReturns.size(); ++i) {
                    if (i > 0) {
                        deleteReturns.append(",");
                    }
                    deleteReturns.append("?");
                }
                deleteReturns.append(")");
                PreparedStatement deleteStmt = this.database.prepareStatement(deleteReturns.toString());
                for (int i = 0; i < claimedReturns.size(); ++i) {
                    deleteStmt.setInt(i + 1, (Integer)claimedReturns.get(i));
                }
                deleteStmt.executeUpdate();
                deleteStmt.close();
            }
            this.database.commit();
            if (totalClaimed > 0 || totalDropped > 0) {
                player.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7aClaimed " + (totalClaimed + totalDropped) + " items!");
                if (totalClaimed > 0) {
                    player.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7a" + totalClaimed + " items added to inventory.");
                }
                if (totalDropped > 0) {
                    player.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7e" + totalDropped + " items dropped on ground (inventory full).");
                }
            } else {
                player.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7cNo pending items to claim.");
            }
        }
        catch (SQLException e) {
            try {
                this.database.rollback();
            }
            catch (SQLException ex) {
                this.plugin.getLogger().severe("Failed to rollback claim transaction: " + ex.getMessage());
            }
            this.plugin.getLogger().severe("Error claiming pending items: " + e.getMessage());
            player.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7cError claiming items. Contact an administrator.");
        }
        finally {
            try {
                this.database.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error resetting auto-commit: " + e.getMessage());
            }
        }
    }

    private boolean isShulkerBox(ItemStack item) {
        if (item == null) {
            return false;
        }
        String type = item.getType().name();
        return type.equals("SHULKER_BOX") || type.equals("WHITE_SHULKER_BOX") || type.equals("ORANGE_SHULKER_BOX") || type.equals("MAGENTA_SHULKER_BOX") || type.equals("LIGHT_BLUE_SHULKER_BOX") || type.equals("YELLOW_SHULKER_BOX") || type.equals("LIME_SHULKER_BOX") || type.equals("PINK_SHULKER_BOX") || type.equals("GRAY_SHULKER_BOX") || type.equals("LIGHT_GRAY_SHULKER_BOX") || type.equals("CYAN_SHULKER_BOX") || type.equals("PURPLE_SHULKER_BOX") || type.equals("BLUE_SHULKER_BOX") || type.equals("BROWN_SHULKER_BOX") || type.equals("GREEN_SHULKER_BOX") || type.equals("RED_SHULKER_BOX") || type.equals("BLACK_SHULKER_BOX");
    }

    private void send404(HttpExchange exchange) throws IOException {
        String notFound = "<html><body><h1>404 Not Found</h1></body></html>";
        exchange.getResponseHeaders().set("Content-Type", "text/html");
        this.sendResponse(exchange, 404, notFound);
    }

    private class RegisterHandler
    implements HttpHandler {
        private RegisterHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if ("POST".equals(exchange.getRequestMethod())) {
                this.handleRegisterPost(exchange);
            } else {
                WebManager.this.sendResponse(exchange, 405, "{\"success\":false,\"error\":\"Method not allowed\"}");
            }
        }

        private void handleRegisterPost(HttpExchange exchange) throws IOException {
            try {
                String requestBody = new String(exchange.getRequestBody().readAllBytes(), StandardCharsets.UTF_8);
                JSONParser parser = new JSONParser();
                JSONObject json = (JSONObject)parser.parse(requestBody);
                String username = (String)json.get((Object)"username");
                if (username == null || username.trim().isEmpty()) {
                    WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"Username is required\"}");
                    return;
                }
                Player player = Bukkit.getPlayer((String)username);
                if (player == null) {
                    WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"Player not found online. Please make sure you are logged into the server.\"}");
                    return;
                }
                String verificationCode = WebManager.this.generateVerificationCode(username);
                player.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7eWeb verification requested!");
                player.sendMessage("\u00a7eRun this command: \u00a7a/ahplus verify " + verificationCode);
                player.sendMessage("\u00a77This code expires in " + WebManager.this.verificationTimeout + " minutes.");
                JSONObject response = new JSONObject();
                response.put((Object)"success", (Object)true);
                response.put((Object)"verificationCode", (Object)verificationCode);
                response.put((Object)"message", (Object)"Verification code sent to player. Check in-game chat for the command.");
                WebManager.this.sendJsonResponse(exchange, 200, response.toJSONString());
            }
            catch (Exception e) {
                WebManager.this.sendJsonResponse(exchange, 500, "{\"success\":false,\"error\":\"Internal server error\"}");
            }
        }
    }

    private class VerifyHandler
    implements HttpHandler {
        private VerifyHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if ("POST".equals(exchange.getRequestMethod())) {
                this.handleVerifyPost(exchange);
            } else {
                WebManager.this.sendResponse(exchange, 405, "{\"success\":false,\"error\":\"Method not allowed\"}");
            }
        }

        private void handleVerifyPost(HttpExchange exchange) throws IOException {
            try {
                String requestBody = new String(exchange.getRequestBody().readAllBytes(), StandardCharsets.UTF_8);
                JSONParser parser = new JSONParser();
                JSONObject json = (JSONObject)parser.parse(requestBody);
                String username = (String)json.get((Object)"username");
                String password = (String)json.get((Object)"password");
                if (username == null || password == null) {
                    WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"Username and password are required\"}");
                    return;
                }
                String uuid = WebManager.this.verifiedUsers.get(username.toLowerCase());
                if (uuid == null) {
                    WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"User not verified. Please run the verification command in-game first.\"}");
                    return;
                }
                String passwordHash = WebManager.this.hashPassword(password);
                String insertUser = "INSERT INTO users (username, password_hash, minecraft_uuid) VALUES (?, ?, ?)";
                PreparedStatement stmt = WebManager.this.database.prepareStatement(insertUser);
                stmt.setString(1, username);
                stmt.setString(2, passwordHash);
                stmt.setString(3, uuid);
                stmt.executeUpdate();
                stmt.close();
                WebManager.this.verifiedUsers.remove(username.toLowerCase());
                JSONObject response = new JSONObject();
                response.put((Object)"success", (Object)true);
                response.put((Object)"message", (Object)"Account created successfully! You can now login.");
                WebManager.this.sendJsonResponse(exchange, 200, response.toJSONString());
            }
            catch (SQLException e) {
                if (e.getMessage().contains("UNIQUE constraint failed")) {
                    WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"Username or player already registered\"}");
                } else {
                    WebManager.this.sendJsonResponse(exchange, 500, "{\"success\":false,\"error\":\"Database error\"}");
                }
            }
            catch (Exception e) {
                WebManager.this.sendJsonResponse(exchange, 500, "{\"success\":false,\"error\":\"Internal server error\"}");
            }
        }
    }

    private class LoginHandler
    implements HttpHandler {
        private LoginHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if ("POST".equals(exchange.getRequestMethod())) {
                this.handleLoginPost(exchange);
            } else {
                WebManager.this.sendResponse(exchange, 405, "{\"success\":false,\"error\":\"Method not allowed\"}");
            }
        }

        private void handleLoginPost(HttpExchange exchange) throws IOException {
            try {
                String requestBody = new String(exchange.getRequestBody().readAllBytes(), StandardCharsets.UTF_8);
                JSONParser parser = new JSONParser();
                JSONObject json = (JSONObject)parser.parse(requestBody);
                String username = (String)json.get((Object)"username");
                String password = (String)json.get((Object)"password");
                if (username == null || password == null) {
                    WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"Username and password required\"}");
                    return;
                }
                String passwordHash = WebManager.this.hashPassword(password);
                String selectUser = "SELECT id, minecraft_uuid FROM users WHERE username = ? AND password_hash = ?";
                PreparedStatement stmt = WebManager.this.database.prepareStatement(selectUser);
                stmt.setString(1, username);
                stmt.setString(2, passwordHash);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    int userId = rs.getInt("id");
                    String uuid = rs.getString("minecraft_uuid");
                    String sessionToken = WebManager.this.generateRandomString(32);
                    long expiresAt = System.currentTimeMillis() + (long)(WebManager.this.sessionTimeout * 60 * 60 * 1000);
                    String insertSession = "INSERT INTO sessions (user_id, session_token, expires_at) VALUES (?, ?, ?)";
                    PreparedStatement sessionStmt = WebManager.this.database.prepareStatement(insertSession);
                    sessionStmt.setInt(1, userId);
                    sessionStmt.setString(2, sessionToken);
                    sessionStmt.setTimestamp(3, new Timestamp(expiresAt));
                    sessionStmt.executeUpdate();
                    sessionStmt.close();
                    JSONObject response = new JSONObject();
                    response.put((Object)"success", (Object)true);
                    response.put((Object)"sessionToken", (Object)sessionToken);
                    response.put((Object)"username", (Object)username);
                    WebManager.this.sendJsonResponse(exchange, 200, response.toJSONString());
                } else {
                    WebManager.this.sendJsonResponse(exchange, 401, "{\"success\":false,\"error\":\"Invalid username or password\"}");
                }
                rs.close();
                stmt.close();
            }
            catch (Exception e) {
                WebManager.this.sendJsonResponse(exchange, 500, "{\"success\":false,\"error\":\"Internal server error\"}");
            }
        }
    }

    private class LogoutHandler
    implements HttpHandler {
        private LogoutHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if ("POST".equals(exchange.getRequestMethod())) {
                String sessionToken = WebManager.this.getSessionToken(exchange);
                if (sessionToken != null) {
                    try {
                        String deleteSession = "DELETE FROM sessions WHERE session_token = ?";
                        PreparedStatement stmt = WebManager.this.database.prepareStatement(deleteSession);
                        stmt.setString(1, sessionToken);
                        stmt.executeUpdate();
                        stmt.close();
                    }
                    catch (SQLException deleteSession) {
                        // empty catch block
                    }
                }
                JSONObject response = new JSONObject();
                response.put((Object)"success", (Object)true);
                WebManager.this.sendJsonResponse(exchange, 200, response.toJSONString());
            } else {
                WebManager.this.sendResponse(exchange, 405, "{\"success\":false,\"error\":\"Method not allowed\"}");
            }
        }
    }

    private class AuctionsHandler
    implements HttpHandler {
        private AuctionsHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if ("GET".equals(exchange.getRequestMethod())) {
                try {
                    JSONArray auctionsArray = new JSONArray();
                    ConfigurationSection auctionsSection = WebManager.this.plugin.getAuctionData().getConfigurationSection("auctions");
                    if (auctionsSection != null) {
                        for (String key : auctionsSection.getKeys(false)) {
                            JSONObject auction = new JSONObject();
                            auction.put((Object)"id", (Object)key);
                            auction.put((Object)"price", (Object)WebManager.this.formatCurrency(auctionsSection.getDouble(key + ".price")));
                            auction.put((Object)"priceRaw", (Object)auctionsSection.getDouble(key + ".price"));
                            auction.put((Object)"seller", (Object)auctionsSection.getString(key + ".sellerName"));
                            auction.put((Object)"expiresAt", (Object)auctionsSection.getLong(key + ".expiresAt"));
                            ItemStack item = auctionsSection.getItemStack(key + ".item");
                            if (item != null) {
                                BlockStateMeta blockMeta;
                                ItemMeta meta;
                                JSONObject itemData = new JSONObject();
                                itemData.put((Object)"type", (Object)item.getType().name());
                                itemData.put((Object)"amount", (Object)item.getAmount());
                                boolean isShulkerBox = WebManager.this.isShulkerBox(item);
                                itemData.put((Object)"isShulkerBox", (Object)isShulkerBox);
                                if (WebManager.this.enableTextures) {
                                    itemData.put((Object)"texture", (Object)WebManager.this.getItemTexture(item.getType().name()));
                                }
                                if ((meta = item.getItemMeta()) != null) {
                                    if (meta.hasDisplayName()) {
                                        itemData.put((Object)"displayName", (Object)meta.getDisplayName());
                                    }
                                    if (meta.hasLore()) {
                                        JSONArray loreArray = new JSONArray();
                                        meta.getLore().forEach(arg_0 -> loreArray.add(arg_0));
                                        itemData.put((Object)"lore", (Object)loreArray);
                                    }
                                }
                                if (isShulkerBox && meta instanceof BlockStateMeta && (blockMeta = (BlockStateMeta)meta).getBlockState() instanceof ShulkerBox) {
                                    ShulkerBox shulkerBox = (ShulkerBox)blockMeta.getBlockState();
                                    JSONArray contentsArray = new JSONArray();
                                    for (int i = 0; i < 27; ++i) {
                                        ItemMeta contentMeta;
                                        ItemStack contentItem = shulkerBox.getInventory().getItem(i);
                                        if (contentItem == null || contentItem.getType().name().equals("AIR")) continue;
                                        JSONObject contentData = new JSONObject();
                                        contentData.put((Object)"slot", (Object)i);
                                        contentData.put((Object)"type", (Object)contentItem.getType().name());
                                        contentData.put((Object)"amount", (Object)contentItem.getAmount());
                                        if (WebManager.this.enableTextures) {
                                            contentData.put((Object)"texture", (Object)WebManager.this.getItemTexture(contentItem.getType().name()));
                                        }
                                        if ((contentMeta = contentItem.getItemMeta()) != null) {
                                            if (contentMeta.hasDisplayName()) {
                                                contentData.put((Object)"displayName", (Object)contentMeta.getDisplayName());
                                            }
                                            if (contentMeta.hasLore()) {
                                                JSONArray contentLore = new JSONArray();
                                                contentMeta.getLore().forEach(arg_0 -> contentLore.add(arg_0));
                                                contentData.put((Object)"lore", (Object)contentLore);
                                            }
                                        }
                                        contentsArray.add((Object)contentData);
                                    }
                                    itemData.put((Object)"shulkerContents", (Object)contentsArray);
                                }
                                auction.put((Object)"item", (Object)itemData);
                            }
                            auctionsArray.add((Object)auction);
                        }
                    }
                    WebManager.this.sendJsonResponse(exchange, 200, auctionsArray.toJSONString());
                }
                catch (Exception e) {
                    WebManager.this.sendJsonResponse(exchange, 500, "{\"success\":false,\"error\":\"Internal server error\"}");
                }
            } else {
                WebManager.this.sendResponse(exchange, 405, "{\"success\":false,\"error\":\"Method not allowed\"}");
            }
        }
    }

    private class PurchaseHandler
    implements HttpHandler {
        private PurchaseHandler() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"POST".equals(exchange.getRequestMethod())) {
                WebManager.this.sendResponse(exchange, 405, "{\"success\":false,\"error\":\"Method not allowed\"}");
                return;
            }
            String sessionToken = WebManager.this.getSessionToken(exchange);
            if (sessionToken == null) {
                WebManager.this.sendJsonResponse(exchange, 401, "{\"success\":false,\"error\":\"Not authenticated\"}");
                return;
            }
            try {
                String requestBody = new String(exchange.getRequestBody().readAllBytes(), StandardCharsets.UTF_8);
                JSONParser parser = new JSONParser();
                JSONObject json = (JSONObject)parser.parse(requestBody);
                String auctionId = (String)json.get((Object)"auctionId");
                if (auctionId == null) {
                    WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"Auction ID required\"}");
                    return;
                }
                String selectUser = "SELECT u.username, u.minecraft_uuid FROM users u JOIN sessions s ON u.id = s.user_id WHERE s.session_token = ? AND s.expires_at > ?";
                PreparedStatement stmt = WebManager.this.database.prepareStatement(selectUser);
                stmt.setString(1, sessionToken);
                stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    String uuid = rs.getString("minecraft_uuid");
                    Player player = Bukkit.getPlayer((UUID)UUID.fromString(uuid));
                    ConfigurationSection auctionsSection = WebManager.this.plugin.getAuctionData().getConfigurationSection("auctions");
                    if (auctionsSection == null || !auctionsSection.contains(auctionId)) {
                        WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"This item is no longer available\"}");
                        return;
                    }
                    double price = auctionsSection.getDouble(auctionId + ".price");
                    String sellerUUID = auctionsSection.getString(auctionId + ".seller");
                    String sellerName = auctionsSection.getString(auctionId + ".sellerName");
                    ItemStack item = auctionsSection.getItemStack(auctionId + ".item");
                    if (sellerUUID.equals(uuid)) {
                        WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"You cannot buy your own listing\"}");
                        return;
                    }
                    if (player != null) {
                        Bukkit.getScheduler().runTask((Plugin)WebManager.this.plugin, () -> {
                            boolean success = WebManager.this.plugin.processPurchaseFromWeb(player, auctionId);
                            try {
                                JSONObject response = new JSONObject();
                                if (success) {
                                    response.put((Object)"success", (Object)true);
                                    response.put((Object)"message", (Object)"Purchase successful!");
                                } else {
                                    response.put((Object)"success", (Object)false);
                                    response.put((Object)"error", (Object)"Purchase failed. Check in-game messages for details.");
                                }
                                WebManager.this.sendJsonResponse(exchange, success ? 200 : 400, response.toJSONString());
                            }
                            catch (IOException e) {
                                WebManager.this.plugin.getLogger().severe("Error sending purchase response: " + e.getMessage());
                            }
                        });
                        return;
                    }
                    if (WebManager.this.plugin.getEconomy().getBalance(Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid))) < price) {
                        WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"You don't have enough money to buy this item\"}");
                        return;
                    }
                    WebManager.this.plugin.getEconomy().withdrawPlayer(Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid)), price);
                    WebManager.this.plugin.getEconomy().depositPlayer(Bukkit.getOfflinePlayer((UUID)UUID.fromString(sellerUUID)), price);
                    byte[] itemData = WebManager.this.serializeItemStack(item);
                    if (itemData != null) {
                        String insertPurchase = "INSERT INTO pending_purchases (player_uuid, item_data, price) VALUES (?, ?, ?)";
                        PreparedStatement purchaseStmt = WebManager.this.database.prepareStatement(insertPurchase);
                        purchaseStmt.setString(1, uuid);
                        purchaseStmt.setBytes(2, itemData);
                        purchaseStmt.setDouble(3, price);
                        purchaseStmt.executeUpdate();
                        purchaseStmt.close();
                        auctionsSection.set(auctionId, null);
                        WebManager.this.plugin.saveAuctionData();
                        Player sellerPlayer = Bukkit.getPlayer((UUID)UUID.fromString(sellerUUID));
                        if (sellerPlayer != null && sellerPlayer.isOnline()) {
                            sellerPlayer.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7aYour item was sold via web interface for " + WebManager.this.formatCurrency(price) + ".");
                        }
                        JSONObject response = new JSONObject();
                        response.put((Object)"success", (Object)true);
                        response.put((Object)"message", (Object)"Purchase successful! Item will be delivered when you join the server.");
                        WebManager.this.sendJsonResponse(exchange, 200, response.toJSONString());
                    } else {
                        WebManager.this.sendJsonResponse(exchange, 500, "{\"success\":false,\"error\":\"Failed to process purchase\"}");
                    }
                } else {
                    WebManager.this.sendJsonResponse(exchange, 401, "{\"success\":false,\"error\":\"Invalid session\"}");
                }
                rs.close();
                stmt.close();
                return;
            }
            catch (Exception e) {
                WebManager.this.sendJsonResponse(exchange, 500, "{\"success\":false,\"error\":\"Internal server error\"}");
                return;
            }
        }
    }

    private class UserHandler
    implements HttpHandler {
        private UserHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if ("GET".equals(exchange.getRequestMethod())) {
                String sessionToken = WebManager.this.getSessionToken(exchange);
                if (sessionToken == null) {
                    WebManager.this.sendJsonResponse(exchange, 401, "{\"success\":false,\"error\":\"Not authenticated\"}");
                    return;
                }
                try {
                    String selectUser = "SELECT u.username, u.minecraft_uuid FROM users u JOIN sessions s ON u.id = s.user_id WHERE s.session_token = ? AND s.expires_at > ?";
                    PreparedStatement stmt = WebManager.this.database.prepareStatement(selectUser);
                    stmt.setString(1, sessionToken);
                    stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        String username = rs.getString("username");
                        String uuid = rs.getString("minecraft_uuid");
                        Player player = Bukkit.getPlayer((UUID)UUID.fromString(uuid));
                        double balance = 0.0;
                        if (player != null && WebManager.this.plugin.getEconomy() != null) {
                            balance = WebManager.this.plugin.getEconomy().getBalance((OfflinePlayer)player);
                        }
                        JSONObject response = new JSONObject();
                        response.put((Object)"success", (Object)true);
                        response.put((Object)"username", (Object)username);
                        response.put((Object)"balance", (Object)WebManager.this.formatCurrency(balance));
                        response.put((Object)"balanceRaw", (Object)balance);
                        WebManager.this.sendJsonResponse(exchange, 200, response.toJSONString());
                    } else {
                        WebManager.this.sendJsonResponse(exchange, 401, "{\"success\":false,\"error\":\"Invalid session\"}");
                    }
                    rs.close();
                    stmt.close();
                }
                catch (Exception e) {
                    WebManager.this.sendJsonResponse(exchange, 500, "{\"success\":false,\"error\":\"Internal server error\"}");
                }
            } else {
                WebManager.this.sendResponse(exchange, 405, "{\"success\":false,\"error\":\"Method not allowed\"}");
            }
        }
    }

    private class MyListingsHandler
    implements HttpHandler {
        private MyListingsHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if ("GET".equals(exchange.getRequestMethod())) {
                String sessionToken = WebManager.this.getSessionToken(exchange);
                if (sessionToken == null) {
                    WebManager.this.sendJsonResponse(exchange, 401, "{\"success\":false,\"error\":\"Not authenticated\"}");
                    return;
                }
                try {
                    String uuid = WebManager.this.getUserUUIDFromSession(sessionToken);
                    if (uuid == null) {
                        WebManager.this.sendJsonResponse(exchange, 401, "{\"success\":false,\"error\":\"Invalid session\"}");
                        return;
                    }
                    JSONArray listingsArray = new JSONArray();
                    ConfigurationSection auctionsSection = WebManager.this.plugin.getAuctionData().getConfigurationSection("auctions");
                    if (auctionsSection != null) {
                        for (String key : auctionsSection.getKeys(false)) {
                            String sellerId = auctionsSection.getString(key + ".seller");
                            if (!uuid.equals(sellerId)) continue;
                            JSONObject auction = new JSONObject();
                            auction.put((Object)"id", (Object)key);
                            auction.put((Object)"price", (Object)WebManager.this.formatCurrency(auctionsSection.getDouble(key + ".price")));
                            auction.put((Object)"priceRaw", (Object)auctionsSection.getDouble(key + ".price"));
                            auction.put((Object)"expiresAt", (Object)auctionsSection.getLong(key + ".expiresAt"));
                            auction.put((Object)"listedAt", (Object)auctionsSection.getLong(key + ".listedAt"));
                            ItemStack item = auctionsSection.getItemStack(key + ".item");
                            if (item != null) {
                                ItemMeta meta;
                                JSONObject itemData = new JSONObject();
                                itemData.put((Object)"type", (Object)item.getType().name());
                                itemData.put((Object)"amount", (Object)item.getAmount());
                                if (WebManager.this.enableTextures) {
                                    itemData.put((Object)"texture", (Object)WebManager.this.getItemTexture(item.getType().name()));
                                }
                                if ((meta = item.getItemMeta()) != null) {
                                    if (meta.hasDisplayName()) {
                                        itemData.put((Object)"displayName", (Object)meta.getDisplayName());
                                    }
                                    if (meta.hasLore()) {
                                        JSONArray loreArray = new JSONArray();
                                        meta.getLore().forEach(arg_0 -> loreArray.add(arg_0));
                                        itemData.put((Object)"lore", (Object)loreArray);
                                    }
                                }
                                auction.put((Object)"item", (Object)itemData);
                            }
                            listingsArray.add((Object)auction);
                        }
                    }
                    WebManager.this.sendJsonResponse(exchange, 200, listingsArray.toJSONString());
                }
                catch (Exception e) {
                    WebManager.this.sendJsonResponse(exchange, 500, "{\"success\":false,\"error\":\"Internal server error\"}");
                }
            } else {
                WebManager.this.sendResponse(exchange, 405, "{\"success\":false,\"error\":\"Method not allowed\"}");
            }
        }
    }

    private class CancelListingHandler
    implements HttpHandler {
        private CancelListingHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if ("POST".equals(exchange.getRequestMethod())) {
                String sessionToken = WebManager.this.getSessionToken(exchange);
                if (sessionToken == null) {
                    WebManager.this.sendJsonResponse(exchange, 401, "{\"success\":false,\"error\":\"Not authenticated\"}");
                    return;
                }
                try {
                    String requestBody = new String(exchange.getRequestBody().readAllBytes(), StandardCharsets.UTF_8);
                    JSONParser parser = new JSONParser();
                    JSONObject json = (JSONObject)parser.parse(requestBody);
                    String auctionId = (String)json.get((Object)"auctionId");
                    if (auctionId == null) {
                        WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"Auction ID required\"}");
                        return;
                    }
                    String uuid = WebManager.this.getUserUUIDFromSession(sessionToken);
                    if (uuid == null) {
                        WebManager.this.sendJsonResponse(exchange, 401, "{\"success\":false,\"error\":\"Invalid session\"}");
                        return;
                    }
                    Player player = Bukkit.getPlayer((UUID)UUID.fromString(uuid));
                    if (player == null) {
                        ConfigurationSection auctionsSection = WebManager.this.plugin.getAuctionData().getConfigurationSection("auctions");
                        if (auctionsSection == null || !auctionsSection.contains(auctionId)) {
                            WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"Listing not found\"}");
                            return;
                        }
                        String sellerId = auctionsSection.getString(auctionId + ".seller");
                        if (!uuid.equals(sellerId)) {
                            WebManager.this.sendJsonResponse(exchange, 403, "{\"success\":false,\"error\":\"You can only cancel your own listings\"}");
                            return;
                        }
                        ItemStack item = auctionsSection.getItemStack(auctionId + ".item");
                        byte[] itemData = WebManager.this.serializeItemStack(item);
                        if (itemData != null) {
                            String insertReturn = "INSERT INTO pending_returns (player_uuid, item_data, reason) VALUES (?, ?, ?)";
                            PreparedStatement returnStmt = WebManager.this.database.prepareStatement(insertReturn);
                            returnStmt.setString(1, uuid);
                            returnStmt.setBytes(2, itemData);
                            returnStmt.setString(3, "Cancelled via web interface");
                            returnStmt.executeUpdate();
                            returnStmt.close();
                            auctionsSection.set(auctionId, null);
                            WebManager.this.plugin.saveAuctionData();
                            JSONObject response = new JSONObject();
                            response.put((Object)"success", (Object)true);
                            response.put((Object)"message", (Object)"Listing cancelled successfully! Item will be returned when you join the server.");
                            WebManager.this.sendJsonResponse(exchange, 200, response.toJSONString());
                        } else {
                            WebManager.this.sendJsonResponse(exchange, 500, "{\"success\":false,\"error\":\"Failed to process cancellation\"}");
                        }
                        return;
                    }
                    Bukkit.getScheduler().runTask((Plugin)WebManager.this.plugin, () -> {
                        ConfigurationSection auctionsSection = WebManager.this.plugin.getAuctionData().getConfigurationSection("auctions");
                        if (auctionsSection == null || !auctionsSection.contains(auctionId)) {
                            try {
                                WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"Listing not found\"}");
                            }
                            catch (IOException e) {
                                WebManager.this.plugin.getLogger().severe("Error sending cancel response: " + e.getMessage());
                            }
                            return;
                        }
                        String sellerId = auctionsSection.getString(auctionId + ".seller");
                        if (!uuid.equals(sellerId)) {
                            try {
                                WebManager.this.sendJsonResponse(exchange, 403, "{\"success\":false,\"error\":\"You can only cancel your own listings\"}");
                            }
                            catch (IOException e) {
                                WebManager.this.plugin.getLogger().severe("Error sending cancel response: " + e.getMessage());
                            }
                            return;
                        }
                        ItemStack item = auctionsSection.getItemStack(auctionId + ".item");
                        HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
                        if (!leftover.isEmpty()) {
                            try {
                                WebManager.this.sendJsonResponse(exchange, 400, "{\"success\":false,\"error\":\"You don't have enough inventory space to cancel this listing\"}");
                            }
                            catch (IOException e) {
                                WebManager.this.plugin.getLogger().severe("Error sending cancel response: " + e.getMessage());
                            }
                            return;
                        }
                        auctionsSection.set(auctionId, null);
                        WebManager.this.plugin.saveAuctionData();
                        player.sendMessage("\u00a78[\u00a76AuctionHouse\u00a78] \u00a7aListing cancelled successfully via web interface. The item has been returned to your inventory.");
                        try {
                            JSONObject response = new JSONObject();
                            response.put((Object)"success", (Object)true);
                            response.put((Object)"message", (Object)"Listing cancelled successfully!");
                            WebManager.this.sendJsonResponse(exchange, 200, response.toJSONString());
                        }
                        catch (IOException e) {
                            WebManager.this.plugin.getLogger().severe("Error sending cancel response: " + e.getMessage());
                        }
                    });
                    return;
                }
                catch (Exception e) {
                    WebManager.this.sendJsonResponse(exchange, 500, "{\"success\":false,\"error\":\"Internal server error\"}");
                }
            } else {
                WebManager.this.sendResponse(exchange, 405, "{\"success\":false,\"error\":\"Method not allowed\"}");
            }
        }
    }

    private class FaviconHandler
    implements HttpHandler {
        private FaviconHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String faviconBase64 = "AAABAAEAEBAAAAAAAABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////ADMzM/8zMzP/MzMz/zMzM/8zMzP/MzMz/////wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8AMzMz/5mZmf+ZmZn/mZmZ/5mZmf+ZmZn/MzMz/////wD///8A////AP///wD///8A////AP///wD///8A////ADMzM/+ZmZn/mZmZ/5mZmf+ZmZn/mZmZ/5mZmf8zMzP/////AP///wD///8A////AP///wD///8A////AP///wAzMzP/mZmZ/5mZmf+ZmZn/mZmZ/5mZmf+ZmZn/MzMz/////wD///8A////AP///wD///8A////AP///wD///8AMzMz/5mZmf+ZmZn/mZmZ/5mZmf+ZmZn/mZmZ/zMzM/////8A////AP///wD///8A////AP///wD///8A////ADMzM/+ZmZn/mZmZ/5mZmf+ZmZn/mZmZ/5mZmf8zMzP/////AP///wD///8A////AP///wD///8A////AP///wAzMzP/MzMz/zMzM/8zMzP/MzMz/zMzM/8zMzP/MzMz/////wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A";
            byte[] faviconBytes = Base64.getDecoder().decode(faviconBase64);
            exchange.getResponseHeaders().set("Content-Type", "image/x-icon");
            exchange.getResponseHeaders().set("Cache-Control", "public, max-age=86400");
            exchange.sendResponseHeaders(200, faviconBytes.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(faviconBytes);
            }
        }
    }

    private class StaticFileHandler
    implements HttpHandler {
        private StaticFileHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String path = exchange.getRequestURI().getPath();
            if (path.equals("/")) {
                this.serveIndexHtml(exchange);
            } else {
                WebManager.this.send404(exchange);
            }
        }

        private void serveIndexHtml(HttpExchange exchange) throws IOException {
            String html = this.generateIndexHtml();
            exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
            WebManager.this.sendResponse(exchange, 200, html);
        }

        private String generateIndexHtml() {
            return "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <title>" + WebManager.this.webTitle + "</title>\n    <link rel=\"icon\" type=\"image/x-icon\" href=\"/favicon.ico\">\n    <style>\n        * { margin: 0; padding: 0; box-sizing: border-box; }\n        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background: linear-gradient(135deg, " + WebManager.this.backgroundColor + ", #1e293b); color: " + WebManager.this.textColor + "; min-height: 100vh; }\n        .header { background: rgba(30, 41, 59, 0.8); backdrop-filter: blur(10px); padding: 1rem 2rem; display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid #334155; }\n        .header h1 { color: " + WebManager.this.primaryColor + "; font-size: 1.8rem; font-weight: bold; }\n        .user-info { display: none; align-items: center; gap: 1rem; }\n        .balance { background: " + WebManager.this.primaryColor + "; color: white; padding: 0.5rem 1rem; border-radius: 8px; font-weight: bold; }\n        .auth-section { max-width: 400px; margin: 2rem auto; padding: 2rem; background: rgba(30, 41, 59, 0.8); border-radius: 12px; box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3); }\n        .main-content { display: none; }\n        .nav-tabs { display: flex; gap: 1rem; margin: 2rem; justify-content: center; }\n        .nav-tab { padding: 0.75rem 1.5rem; background: rgba(30, 41, 59, 0.6); border: 1px solid #334155; border-radius: 8px; cursor: pointer; transition: all 0.3s ease; color: " + WebManager.this.textColor + "; }\n        .nav-tab.active { background: " + WebManager.this.primaryColor + "; border-color: " + WebManager.this.primaryColor + "; }\n        .tab-content { display: none; }\n        .tab-content.active { display: block; }\n        .auction-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 1.5rem; padding: 2rem; max-width: 1200px; margin: 0 auto; }\n        .auction-item { background: rgba(30, 41, 59, 0.8); border-radius: 12px; padding: 1.5rem; border: 1px solid #334155; transition: all 0.3s ease; cursor: pointer; }\n        .auction-item:hover { transform: translateY(-4px); box-shadow: 0 12px 24px rgba(0, 0, 0, 0.4); border-color: " + WebManager.this.primaryColor + "; }\n        .item-header { display: flex; align-items: center; gap: 1rem; margin-bottom: 1rem; }\n        .item-icon { width: 32px; height: 32px; background: " + WebManager.this.primaryColor + "; border-radius: 4px; display: flex; align-items: center; justify-content: center; font-weight: bold; color: white; }\n        .item-icon img { width: 100%; height: 100%; object-fit: contain; }\n        .item-name { font-size: 1.1rem; font-weight: bold; color: " + WebManager.this.textColor + "; }\n        .item-price { font-size: 1.3rem; font-weight: bold; color: #10b981; margin-bottom: 0.5rem; }\n        .item-seller { color: #94a3b8; font-size: 0.9rem; margin-bottom: 0.5rem; }\n        .item-time { color: #fbbf24; font-size: 0.8rem; }\n        .form-group { margin-bottom: 1rem; }\n        .form-group label { display: block; margin-bottom: 0.5rem; color: " + WebManager.this.textColor + "; }\n        .form-group input { width: 100%; padding: 0.75rem; border: 1px solid #334155; border-radius: 8px; background: rgba(15, 23, 42, 0.8); color: " + WebManager.this.textColor + "; font-size: 1rem; }\n        .form-group input:focus { outline: none; border-color: " + WebManager.this.primaryColor + "; box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1); }\n        .btn { background: " + WebManager.this.primaryColor + "; color: white; border: none; padding: 0.75rem 1.5rem; border-radius: 8px; font-size: 1rem; cursor: pointer; transition: all 0.3s ease; }\n        .btn:hover { background: " + WebManager.this.secondaryColor + "; transform: translateY(-1px); }\n        .btn:disabled { opacity: 0.6; cursor: not-allowed; }\n        .btn-danger { background: #ef4444; }\n        .btn-danger:hover { background: #dc2626; }\n        .error { color: #ef4444; background: rgba(239, 68, 68, 0.1); padding: 0.75rem; border-radius: 8px; margin-bottom: 1rem; border: 1px solid rgba(239, 68, 68, 0.3); }\n        .success { color: #10b981; background: rgba(16, 185, 129, 0.1); padding: 0.75rem; border-radius: 8px; margin-bottom: 1rem; border: 1px solid rgba(16, 185, 129, 0.3); }\n        .tabs { display: flex; gap: 1rem; margin-bottom: 2rem; }\n        .tab { padding: 0.75rem 1.5rem; background: rgba(30, 41, 59, 0.6); border: 1px solid #334155; border-radius: 8px; cursor: pointer; transition: all 0.3s ease; }\n        .tab.active { background: " + WebManager.this.primaryColor + "; border-color: " + WebManager.this.primaryColor + "; }\n        .loading { text-align: center; padding: 2rem; color: #94a3b8; }\n        .modal { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.8); display: none; align-items: center; justify-content: center; z-index: 1000; }\n        .modal-content { background: " + WebManager.this.backgroundColor + "; border-radius: 12px; padding: 2rem; max-width: 500px; width: 90%; max-height: 80vh; overflow-y: auto; border: 1px solid #334155; }\n        .modal-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem; }\n        .close-btn { background: none; border: none; color: " + WebManager.this.textColor + "; font-size: 1.5rem; cursor: pointer; }\n        .item-lore { margin-top: 1rem; padding-top: 1rem; border-top: 1px solid #334155; }\n        .lore-line { color: #94a3b8; font-size: 0.9rem; margin-bottom: 0.25rem; }\n        .verification-display { background: rgba(15, 23, 42, 0.8); padding: 1rem; border-radius: 8px; margin: 1rem 0; border: 1px solid #334155; }\n        .verification-code { color: " + WebManager.this.primaryColor + "; font-family: monospace; font-size: 1.1rem; font-weight: bold; }\n        .listing-actions { display: flex; gap: 0.5rem; margin-top: 1rem; }\n        @media (max-width: 768px) { .auction-grid { grid-template-columns: 1fr; padding: 1rem; } .header { padding: 1rem; flex-direction: column; gap: 1rem; } }\n    </style>\n</head>\n<body>\n    <div class=\"header\">\n        <h1>" + WebManager.this.webTitle + "</h1>\n        <div class=\"user-info\" id=\"userInfo\">\n            <span id=\"username\"></span>\n            <div class=\"balance\">Balance: <span id=\"balance\">$0.00</span></div>\n            <button class=\"btn\" onclick=\"logout()\">Logout</button>\n        </div>\n    </div>\n    \n    <div class=\"auth-section\" id=\"authSection\">\n        <div class=\"tabs\">\n            <div class=\"tab active\" onclick=\"showAuthTab('login')\">Login</div>\n            <div class=\"tab\" onclick=\"showAuthTab('register')\">Register</div>\n        </div>\n        \n        <div id=\"loginForm\">\n            <h2 style=\"margin-bottom: 1.5rem; text-align: center;\">Login to Your Account</h2>\n            <form onsubmit=\"login(event)\">\n                <div class=\"form-group\">\n                    <label for=\"loginUsername\">Username</label>\n                    <input type=\"text\" id=\"loginUsername\" required>\n                </div>\n                <div class=\"form-group\">\n                    <label for=\"loginPassword\">Password</label>\n                    <input type=\"password\" id=\"loginPassword\" required>\n                </div>\n                <button type=\"submit\" class=\"btn\">Login</button>\n            </form>\n        </div>\n        \n        <div id=\"registerForm\" style=\"display: none;\">\n            <h2 style=\"margin-bottom: 1.5rem; text-align: center;\">Create Account</h2>\n            <div id=\"registerStep1\">\n                <p style=\"margin-bottom: 1rem; color: #94a3b8;\">Enter your Minecraft username. You must be online on the server to register.</p>\n                <form onsubmit=\"requestVerification(event)\">\n                    <div class=\"form-group\">\n                        <label for=\"regUsername\">Minecraft Username</label>\n                        <input type=\"text\" id=\"regUsername\" required>\n                    </div>\n                    <button type=\"submit\" class=\"btn\">Send Verification</button>\n                </form>\n            </div>\n            \n            <div id=\"registerStep2\" style=\"display: none;\">\n                <div class=\"verification-display\">\n                    <p style=\"margin-bottom: 0.5rem; color: #fbbf24;\">Run this command in-game:</p>\n                    <div class=\"verification-code\">/ahplus verify <span id=\"verificationCodeDisplay\"></span></div>\n                </div>\n                <p style=\"margin-bottom: 1rem; color: #94a3b8;\">After running the command, set your password below:</p>\n                <form onsubmit=\"completeRegistration(event)\">\n                    <div class=\"form-group\">\n                        <label for=\"regPassword\">Password</label>\n                        <input type=\"password\" id=\"regPassword\" required>\n                    </div>\n                    <div class=\"form-group\">\n                        <label for=\"regPasswordConfirm\">Confirm Password</label>\n                        <input type=\"password\" id=\"regPasswordConfirm\" required>\n                    </div>\n                    <button type=\"submit\" class=\"btn\">Complete Registration</button>\n                </form>\n            </div>\n        </div>\n        \n        <div id=\"message\"></div>\n    </div>\n    \n    <div class=\"main-content\" id=\"mainContent\">\n        <div class=\"nav-tabs\">\n            <div class=\"nav-tab active\" onclick=\"showTab('auctions')\">Browse Auctions</div>\n            <div class=\"nav-tab\" onclick=\"showTab('listings')\">My Listings</div>\n        </div>\n        \n        <div id=\"auctionsTab\" class=\"tab-content active\">\n            <div class=\"auction-grid\" id=\"auctionGrid\">\n                <div class=\"loading\" id=\"loading\">Loading auctions...</div>\n            </div>\n        </div>\n        \n        <div id=\"listingsTab\" class=\"tab-content\">\n            <div class=\"auction-grid\" id=\"myListingsGrid\">\n                <div class=\"loading\" id=\"myListingsLoading\">Loading your listings...</div>\n            </div>\n        </div>\n    </div>\n    \n    <div class=\"modal\" id=\"purchaseModal\">\n        <div class=\"modal-content\">\n            <div class=\"modal-header\">\n                <h3>Confirm Purchase</h3>\n                <button class=\"close-btn\" onclick=\"closePurchaseModal()\">&times;</button>\n            </div>\n            <div id=\"purchaseDetails\"></div>\n            <button class=\"btn\" onclick=\"confirmPurchase()\" style=\"margin-top: 1rem;\">Confirm Purchase</button>\n        </div>\n    </div>\n    \n    <div class=\"modal\" id=\"cancelModal\">\n        <div class=\"modal-content\">\n            <div class=\"modal-header\">\n                <h3>Confirm Cancellation</h3>\n                <button class=\"close-btn\" onclick=\"closeCancelModal()\">&times;</button>\n            </div>\n            <div id=\"cancelDetails\"></div>\n            <button class=\"btn btn-danger\" onclick=\"confirmCancel()\" style=\"margin-top: 1rem;\">Cancel Listing</button>\n        </div>\n    </div>\n    \n    <div class=\"modal\" id=\"shulkerModal\">\n        <div class=\"modal-content\" style=\"max-width: 800px; width: 95%;\">\n            <div class=\"modal-header\">\n                <h3>\ud83d\udce6 Shulker Box Contents</h3>\n                <button class=\"close-btn\" onclick=\"closeShulkerModal()\">&times;</button>\n            </div>\n            <div id=\"shulkerGrid\"></div>\n            <div style=\"margin-top: 1rem; text-align: center; color: #94a3b8; font-size: 0.9rem;\">Preview of shulker box contents \u2022 Click outside to close</div>\n        </div>\n    </div>\n    \n    <script>\n        let currentUser = null;\n        let sessionToken = localStorage.getItem('sessionToken');\n        let selectedAuction = null;\n        let selectedListing = null;\n        const autoRefreshInterval = " + WebManager.this.autoRefreshInterval * 1000 + ";\n        \n        if (sessionToken) { checkSession(); }\n        \n        function showAuthTab(tab) {\n            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));\n            event.target.classList.add('active');\n            document.getElementById('loginForm').style.display = tab === 'login' ? 'block' : 'none';\n            document.getElementById('registerForm').style.display = tab === 'register' ? 'block' : 'none';\n        }\n        \n        function showTab(tab) {\n            document.querySelectorAll('.nav-tab').forEach(t => t.classList.remove('active'));\n            event.target.classList.add('active');\n            document.querySelectorAll('.tab-content').forEach(t => t.classList.remove('active'));\n            \n            if (tab === 'auctions') {\n                document.getElementById('auctionsTab').classList.add('active');\n                loadAuctions();\n            } else if (tab === 'listings') {\n                document.getElementById('listingsTab').classList.add('active');\n                loadMyListings();\n            }\n        }\n        \n        async function requestVerification(event) {\n            event.preventDefault();\n            const username = document.getElementById('regUsername').value;\n            try {\n                const response = await fetch('/api/register', {\n                    method: 'POST',\n                    headers: { 'Content-Type': 'application/json' },\n                    body: JSON.stringify({ username })\n                });\n                const data = await response.json();\n                if (data.success) {\n                    document.getElementById('verificationCodeDisplay').textContent = data.verificationCode;\n                    document.getElementById('registerStep1').style.display = 'none';\n                    document.getElementById('registerStep2').style.display = 'block';\n                    showMessage(data.message, 'success');\n                } else {\n                    showMessage(data.error, 'error');\n                }\n            } catch (error) {\n                showMessage('Network error. Please try again.', 'error');\n            }\n        }\n        \n        async function completeRegistration(event) {\n            event.preventDefault();\n            const username = document.getElementById('regUsername').value;\n            const password = document.getElementById('regPassword').value;\n            const passwordConfirm = document.getElementById('regPasswordConfirm').value;\n            if (password !== passwordConfirm) {\n                showMessage('Passwords do not match', 'error');\n                return;\n            }\n            if (password.length < 6) {\n                showMessage('Password must be at least 6 characters long', 'error');\n                return;\n            }\n            try {\n                const response = await fetch('/api/verify', {\n                    method: 'POST',\n                    headers: { 'Content-Type': 'application/json' },\n                    body: JSON.stringify({ username, password })\n                });\n                const data = await response.json();\n                if (data.success) {\n                    showMessage('Account created successfully! You can now login.', 'success');\n                    showAuthTab('login');\n                    document.getElementById('registerStep1').style.display = 'block';\n                    document.getElementById('registerStep2').style.display = 'none';\n                    document.getElementById('regUsername').value = '';\n                    document.getElementById('regPassword').value = '';\n                    document.getElementById('regPasswordConfirm').value = '';\n                    document.getElementById('loginUsername').value = username;\n                } else {\n                    showMessage(data.error, 'error');\n                }\n            } catch (error) {\n                showMessage('Network error. Please try again.', 'error');\n            }\n        }\n        \n        async function login(event) {\n            event.preventDefault();\n            const username = document.getElementById('loginUsername').value;\n            const password = document.getElementById('loginPassword').value;\n            try {\n                const response = await fetch('/api/login', {\n                    method: 'POST',\n                    headers: { 'Content-Type': 'application/json' },\n                    body: JSON.stringify({ username, password })\n                });\n                const data = await response.json();\n                if (data.success) {\n                    sessionToken = data.sessionToken;\n                    localStorage.setItem('sessionToken', sessionToken);\n                    currentUser = data.username;\n                    showAuctionHouse();\n                    loadUserInfo();\n                    loadAuctions();\n                } else {\n                    showMessage(data.error, 'error');\n                }\n            } catch (error) {\n                showMessage('Network error. Please try again.', 'error');\n            }\n        }\n        \n        async function logout() {\n            try {\n                await fetch('/api/logout', {\n                    method: 'POST',\n                    headers: { 'Authorization': 'Bearer ' + sessionToken }\n                });\n            } catch (error) {}\n            sessionToken = null;\n            currentUser = null;\n            localStorage.removeItem('sessionToken');\n            showAuthSection();\n        }\n        \n        async function checkSession() {\n            try {\n                const response = await fetch('/api/user', {\n                    headers: { 'Authorization': 'Bearer ' + sessionToken }\n                });\n                if (response.ok) {\n                    const data = await response.json();\n                    if (data.success) {\n                        currentUser = data.username;\n                        showAuctionHouse();\n                        loadUserInfo();\n                        loadAuctions();\n                    } else {\n                        localStorage.removeItem('sessionToken');\n                        sessionToken = null;\n                    }\n                } else {\n                    localStorage.removeItem('sessionToken');\n                    sessionToken = null;\n                }\n            } catch (error) {\n                localStorage.removeItem('sessionToken');\n                sessionToken = null;\n            }\n        }\n        \n        async function loadUserInfo() {\n            try {\n                const response = await fetch('/api/user', {\n                    headers: { 'Authorization': 'Bearer ' + sessionToken }\n                });\n                if (response.ok) {\n                    const data = await response.json();\n                    if (data.success) {\n                        document.getElementById('username').textContent = data.username;\n                        document.getElementById('balance').textContent = data.balance;\n                    }\n                }\n            } catch (error) {\n                console.error('Error loading user info:', error);\n            }\n        }\n        \n        async function loadAuctions() {\n            document.getElementById('loading').style.display = 'block';\n            try {\n                const response = await fetch('/api/auctions');\n                const auctions = await response.json();\n                displayAuctions(auctions);\n            } catch (error) {\n                console.error('Error loading auctions:', error);\n                document.getElementById('loading').textContent = 'Error loading auctions';\n            }\n        }\n        \n        async function loadMyListings() {\n            document.getElementById('myListingsLoading').style.display = 'block';\n            try {\n                const response = await fetch('/api/my-listings', {\n                    headers: { 'Authorization': 'Bearer ' + sessionToken }\n                });\n                if (response.ok) {\n                    const listings = await response.json();\n                    displayMyListings(listings);\n                } else {\n                    document.getElementById('myListingsLoading').textContent = 'Error loading listings';\n                }\n            } catch (error) {\n                console.error('Error loading listings:', error);\n                document.getElementById('myListingsLoading').textContent = 'Error loading listings';\n            }\n        }\n        \n        function displayAuctions(auctions) {\n            const grid = document.getElementById('auctionGrid');\n            document.getElementById('loading').style.display = 'none';\n            if (auctions.length === 0) {\n                grid.innerHTML = '<div class=\"loading\">No auctions available</div>';\n                return;\n            }\n            grid.innerHTML = auctions.map(auction => {\n                const timeLeft = formatTimeLeft(auction.expiresAt - Date.now());\n                const displayName = auction.item.displayName;\n                const baseType = auction.item.type.replace(/_/g, ' ').toLowerCase().replace(/\\\\b\\\\w/g, l => l.toUpperCase());\n                const itemName = displayName || baseType;\n                const isRenamed = displayName && displayName !== baseType;\n                const itemIcon = getItemIcon(auction.item);\n                \n                // Check if this is the current user's auction\n                const isMyAuction = auction.seller === currentUser;\n                const borderClass = isMyAuction ? 'style=\"border: 2px solid #10b981;\"' : '';\n                const ownerLabel = isMyAuction ? '<div style=\"color: #10b981; font-weight: bold; font-size: 0.8rem; margin-bottom: 0.5rem;\">\ud83d\udfe2 YOUR LISTING</div>' : '';\n                \n                // Add renamed item warning\n                const renamedWarning = isRenamed ? '<div style=\"color: #fbbf24; font-size: 0.8rem; margin-bottom: 0.5rem;\">\u26a0\ufe0f Renamed Item</div>' : '';\n                \n                // Add base type display\n                const baseTypeDisplay = isRenamed ? `<div style=\"color: #94a3b8; font-size: 0.8rem; margin-bottom: 0.5rem;\">Base Type: ${baseType}</div>` : '';\n                \n                // Add shulker box preview button if it's a shulker box\n                const isShulkerBox = auction.item.isShulkerBox;\n                const shulkerButton = isShulkerBox ? `<button class=\"btn\" style=\"margin-top: 0.5rem; padding: 0.25rem 0.5rem; font-size: 0.8rem;\" onclick=\"event.stopPropagation(); showShulkerPreview('${auction.id}')\">\ud83d\udce6 View Contents</button>` : '';\n                \n                const clickAction = isMyAuction ? `onclick=\"showCancelModalFromMain('${auction.id}')\"` : `onclick=\"showPurchaseModal('${auction.id}')\"`;\n                \n                return `<div class=\"auction-item\" ${clickAction} ${borderClass}>${ownerLabel}${renamedWarning}<div class=\"item-header\"><div class=\"item-icon\">${itemIcon}</div><div class=\"item-name\">${itemName} x${auction.item.amount}</div></div>${baseTypeDisplay}<div class=\"item-price\">${auction.price}</div><div class=\"item-seller\">by ${auction.seller}</div><div class=\"item-time\">Expires in ${timeLeft}</div>${auction.item.lore ? `<div class=\"item-lore\">${auction.item.lore.map(line => `<div class=\"lore-line\">${line}</div>`).join('')}</div>` : ''}${shulkerButton}</div>`;\n            }).join('');\n        }\n        \n        function showCancelModalFromMain(listingId) {\n            selectedListing = listingId;\n            loadListingDetails(listingId);\n            document.getElementById('cancelModal').style.display = 'flex';\n        }\n        \n        function showShulkerPreview(auctionId) {\n            fetch('/api/auctions')\n                .then(response => response.json())\n                .then(auctions => {\n                    const auction = auctions.find(a => a.id === auctionId);\n                    if (auction && auction.item.isShulkerBox && auction.item.shulkerContents) {\n                        displayShulkerContents(auction.item.shulkerContents);\n                        document.getElementById('shulkerModal').style.display = 'flex';\n                    } else {\n                        showMessage('Unable to load shulker box contents', 'error');\n                    }\n                })\n                .catch(error => {\n                    console.error('Error loading shulker contents:', error);\n                    showMessage('Error loading shulker box contents', 'error');\n                });\n        }\n        \n        function displayShulkerContents(contents) {\n            const grid = document.getElementById('shulkerGrid');\n            \n            // Create 27 slots (3x9 grid) with uniform sizing\n            let slotsHtml = '';\n            for (let i = 0; i < 27; i++) {\n                const item = contents.find(c => c.slot === i);\n                if (item) {\n                    const displayName = item.displayName;\n                    const baseType = item.type.replace(/_/g, ' ').toLowerCase().replace(/\\\\b\\\\w/g, l => l.toUpperCase());\n                    const itemName = displayName || baseType;\n                    const isRenamed = displayName && displayName !== baseType;\n                    \n                    // Create comprehensive tooltip\n                    let tooltip = '';\n                    if (isRenamed) {\n                        tooltip = `Custom Name: ${displayName}\\\\nBase Type: ${baseType}\\\\nQuantity: ${item.amount}`;\n                    } else {\n                        tooltip = `${baseType}\\\\nQuantity: ${item.amount}`;\n                    }\n                    \n                    // Fixed slot styling with uniform width and height\n                    slotsHtml += `<div style=\"background: rgba(30, 41, 59, 0.9); border: 2px solid #334155; border-radius: 8px; padding: 8px; width: 80px; height: 80px; display: flex; flex-direction: column; align-items: center; justify-content: space-between; position: relative; cursor: pointer;\" title=\"${tooltip}\">`;\n                    \n                    // Renamed indicator\n                    if (isRenamed) {\n                        slotsHtml += '<div style=\"position: absolute; top: 2px; left: 2px; width: 6px; height: 6px; background: #fbbf24; border-radius: 50%; border: 1px solid #000; z-index: 10;\" title=\"Renamed Item\"></div>';\n                    }\n                    \n                    // Item icon with better error handling - show nothing if texture fails\n                    if (item.texture) {\n                        slotsHtml += `<div style=\"font-size: 20px; margin-bottom: 4px; width: 32px; height: 32px; display: flex; align-items: center; justify-content: center;\"><img src=\"${item.texture}\" alt=\"\" style=\"width: 100%; height: 100%; object-fit: contain;\" onerror=\"this.style.display='none'; this.parentNode.style.display='none';\"/></div>`;\n                    } else {\n                        // No texture available, show nothing for icon\n                        slotsHtml += '<div style=\"font-size: 20px; margin-bottom: 4px; width: 32px; height: 32px;\"></div>';\n                    }\n                    \n                    // Display name (if renamed) or base type\n                    if (isRenamed) {\n                        slotsHtml += `<div style=\"font-size: 9px; color: #fbbf24; text-align: center; line-height: 1.1; margin-bottom: 2px; font-weight: bold; max-width: 100%; overflow: hidden; text-overflow: ellipsis;\">${displayName.length > 12 ? displayName.substring(0, 12) + '...' : displayName}</div>`;\n                    }\n                    \n                    // Base type (always show)\n                    slotsHtml += `<div style=\"font-size: 8px; color: #94a3b8; text-align: center; line-height: 1; margin-bottom: 2px; max-width: 100%; overflow: hidden; text-overflow: ellipsis;\">${baseType.length > 15 ? baseType.substring(0, 15) + '...' : baseType}</div>`;\n                    \n                    // Quantity (bottom right, more prominent)\n                    slotsHtml += `<div style=\"position: absolute; bottom: 2px; right: 2px; font-size: 10px; color: #ffffff; background: rgba(0,0,0,0.8); border-radius: 3px; padding: 1px 3px; font-weight: bold; border: 1px solid #fbbf24;\">${item.amount}</div>`;\n                    \n                    slotsHtml += '</div>';\n                } else {\n                    // Empty slot with uniform sizing\n                    slotsHtml += '<div style=\"background: rgba(15, 23, 42, 0.5); border: 2px solid #1e293b; border-radius: 8px; width: 80px; height: 80px;\"></div>';\n                }\n            }\n            \n            // Update the grid CSS to use fixed column sizing\n            grid.style.display = 'grid';\n            grid.style.gridTemplateColumns = 'repeat(9, 80px)';\n            grid.style.gap = '8px';\n            grid.style.padding = '1.5rem';\n            grid.style.background = 'rgba(15, 23, 42, 0.8)';\n            grid.style.borderRadius = '8px';\n            grid.style.justifyContent = 'center';\n            \n            grid.innerHTML = slotsHtml;\n        }\n        \n        function closeShulkerModal() {\n            document.getElementById('shulkerModal').style.display = 'none';\n        }\n        \n        function displayMyListings(listings) {\n            const grid = document.getElementById('myListingsGrid');\n            document.getElementById('myListingsLoading').style.display = 'none';\n            if (listings.length === 0) {\n                grid.innerHTML = '<div class=\"loading\">You have no active listings</div>';\n                return;\n            }\n            grid.innerHTML = listings.map(listing => {\n                const timeLeft = formatTimeLeft(listing.expiresAt - Date.now());\n                const displayName = listing.item.displayName;\n                const baseType = listing.item.type.replace(/_/g, ' ').toLowerCase().replace(/\\\\b\\\\w/g, l => l.toUpperCase());\n                const itemName = displayName || baseType;\n                const isRenamed = displayName && displayName !== baseType;\n                const itemIcon = getItemIcon(listing.item);\n                \n                // Add renamed item warning\n                const renamedWarning = isRenamed ? '<div style=\"color: #fbbf24; font-size: 0.8rem; margin-bottom: 0.5rem;\">\u26a0\ufe0f Renamed Item</div>' : '';\n                \n                // Add base type display\n                const baseTypeDisplay = isRenamed ? `<div style=\"color: #94a3b8; font-size: 0.8rem; margin-bottom: 0.5rem;\">Base Type: ${baseType}</div>` : '';\n                \n                return `<div class=\"auction-item\">${renamedWarning}<div class=\"item-header\"><div class=\"item-icon\">${itemIcon}</div><div class=\"item-name\">${itemName} x${listing.item.amount}</div></div>${baseTypeDisplay}<div class=\"item-price\">${listing.price}</div><div class=\"item-time\">Expires in ${timeLeft}</div>${listing.item.lore ? `<div class=\"item-lore\">${listing.item.lore.map(line => `<div class=\"lore-line\">${line}</div>`).join('')}</div>` : ''}<div class=\"listing-actions\"><button class=\"btn btn-danger\" onclick=\"showCancelModal('${listing.id}')\">Cancel Listing</button></div></div>`;\n            }).join('');\n        }\n        \n        function getItemIcon(item) {\n            // Only show texture if it exists, otherwise show nothing\n            if (item.texture) {\n                const primaryImg = `<img src=\"${item.texture}\" alt=\"\" style=\"width: 100%; height: 100%; object-fit: contain;\" onerror=\"this.style.display='none'; this.parentNode.innerHTML='';\"/>`;\n                return primaryImg;\n            }\n            \n            // No texture available, return empty\n            return '';\n        }\n        \n        function showPurchaseModal(auctionId) {\n            selectedAuction = auctionId;\n            loadAuctionDetails(auctionId);\n            document.getElementById('purchaseModal').style.display = 'flex';\n        }\n        \n        function closePurchaseModal() {\n            document.getElementById('purchaseModal').style.display = 'none';\n            selectedAuction = null;\n        }\n        \n        function showCancelModal(listingId) {\n            selectedListing = listingId;\n            loadListingDetails(listingId);\n            document.getElementById('cancelModal').style.display = 'flex';\n        }\n        \n        function closeCancelModal() {\n            document.getElementById('cancelModal').style.display = 'none';\n            selectedListing = null;\n        }\n        \n        async function loadAuctionDetails(auctionId) {\n            try {\n                const response = await fetch('/api/auctions');\n                const auctions = await response.json();\n                const auction = auctions.find(a => a.id === auctionId);\n                if (auction) {\n                    const itemName = auction.item.displayName || auction.item.type.replace(/_/g, ' ').toLowerCase().replace(/\\\\b\\\\w/g, l => l.toUpperCase());\n                    const itemIcon = getItemIcon(auction.item);\n                    document.getElementById('purchaseDetails').innerHTML = `<div class=\"item-header\"><div class=\"item-icon\">${itemIcon}</div><div class=\"item-name\">${itemName} x${auction.item.amount}</div></div><div class=\"item-price\">${auction.price}</div><div class=\"item-seller\">Sold by ${auction.seller}</div>${auction.item.lore ? `<div class=\"item-lore\">${auction.item.lore.map(line => `<div class=\"lore-line\">${line}</div>`).join('')}</div>` : ''}`;\n                }\n            } catch (error) {\n                console.error('Error loading auction details:', error);\n            }\n        }\n        \n        async function loadListingDetails(listingId) {\n            try {\n                const response = await fetch('/api/my-listings', {\n                    headers: { 'Authorization': 'Bearer ' + sessionToken }\n                });\n                if (response.ok) {\n                    const listings = await response.json();\n                    const listing = listings.find(l => l.id === listingId);\n                    if (listing) {\n                        const itemName = listing.item.displayName || listing.item.type.replace(/_/g, ' ').toLowerCase().replace(/\\\\b\\\\w/g, l => l.toUpperCase());\n                        const itemIcon = getItemIcon(listing.item);\n                        document.getElementById('cancelDetails').innerHTML = `<div class=\"item-header\"><div class=\"item-icon\">${itemIcon}</div><div class=\"item-name\">${itemName} x${listing.item.amount}</div></div><div class=\"item-price\">${listing.price}</div><p style=\"margin-top: 1rem; color: #fbbf24;\">Are you sure you want to cancel this listing? The item will be returned to your inventory.</p>${listing.item.lore ? `<div class=\"item-lore\">${listing.item.lore.map(line => `<div class=\"lore-line\">${line}</div>`).join('')}</div>` : ''}`;\n                    }\n                }\n            } catch (error) {\n                console.error('Error loading listing details:', error);\n            }\n        }\n        \n        async function confirmPurchase() {\n            if (!selectedAuction) return;\n            const button = event.target;\n            const originalText = button.textContent;\n            button.disabled = true;\n            button.textContent = 'Processing...';\n            try {\n                const response = await fetch('/api/purchase', {\n                    method: 'POST',\n                    headers: { 'Content-Type': 'application/json', 'Authorization': 'Bearer ' + sessionToken },\n                    body: JSON.stringify({ auctionId: selectedAuction })\n                });\n                const data = await response.json();\n                console.log('Purchase response:', data);\n                if (data.success) {\n                    showMessage(data.message, 'success');\n                    closePurchaseModal();\n                    // Force immediate refresh of both tabs\n                    await refreshAllData();\n                } else {\n                    showMessage(data.error || 'Purchase failed', 'error');\n                }\n            } catch (error) {\n                console.error('Purchase error:', error);\n                showMessage('Network error. Please try again.', 'error');\n            } finally {\n                button.disabled = false;\n                button.textContent = originalText;\n            }\n        }\n        \n        async function confirmCancel() {\n            if (!selectedListing) return;\n            const button = event.target;\n            const originalText = button.textContent;\n            button.disabled = true;\n            button.textContent = 'Processing...';\n            try {\n                const response = await fetch('/api/cancel-listing', {\n                    method: 'POST',\n                    headers: { 'Content-Type': 'application/json', 'Authorization': 'Bearer ' + sessionToken },\n                    body: JSON.stringify({ auctionId: selectedListing })\n                });\n                const data = await response.json();\n                console.log('Cancel response:', data);\n                if (data.success) {\n                    showMessage(data.message, 'success');\n                    closeCancelModal();\n                    // Force immediate refresh of both tabs\n                    await refreshAllData();\n                } else {\n                    showMessage(data.error || 'Cancellation failed', 'error');\n                }\n            } catch (error) {\n                console.error('Cancel error:', error);\n                showMessage('Network error. Please try again.', 'error');\n            } finally {\n                button.disabled = false;\n                button.textContent = originalText;\n            }\n        }\n        \n        async function refreshAllData() {\n            console.log('Refreshing all data...');\n            try {\n                // Always refresh both auction data and user info\n                await Promise.all([\n                    loadAuctions(),\n                    loadMyListings(),\n                    loadUserInfo()\n                ]);\n                console.log('Data refresh completed');\n            } catch (error) {\n                console.error('Error refreshing data:', error);\n            }\n        }\n        \n        function formatTimeLeft(milliseconds) {\n            if (milliseconds <= 0) return 'Expired';\n            const days = Math.floor(milliseconds / (1000 * 60 * 60 * 24));\n            const hours = Math.floor((milliseconds % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));\n            const minutes = Math.floor((milliseconds % (1000 * 60 * 60)) / (1000 * 60));\n            if (days > 0) return `${days}d ${hours}h`;\n            if (hours > 0) return `${hours}h ${minutes}m`;\n            return `${minutes}m`;\n        }\n        \n        function showAuthSection() {\n            document.getElementById('authSection').style.display = 'block';\n            document.getElementById('mainContent').style.display = 'none';\n            document.getElementById('userInfo').style.display = 'none';\n        }\n        \n        function showAuctionHouse() {\n            document.getElementById('authSection').style.display = 'none';\n            document.getElementById('mainContent').style.display = 'block';\n            document.getElementById('userInfo').style.display = 'flex';\n        }\n        \n        function showMessage(message, type) {\n            const messageDiv = document.getElementById('message');\n            messageDiv.className = type;\n            messageDiv.textContent = message;\n            messageDiv.style.display = 'block';\n            setTimeout(() => { messageDiv.style.display = 'none'; }, 5000);\n        }\n        \n        setInterval(() => {\n            if (currentUser) {\n                console.log('Auto-refreshing data...');\n                refreshAllData();\n            }\n        }, 3000); // Auto-update every 3 seconds\n    </script>\n</body>\n</html>";
        }
    }
}

