/*
 * Decompiled with CFR 0.152.
 */
package net.sn0wix_.modobserver.detection;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.sn0wix_.modobserver.ModObserver;
import net.sn0wix_.modobserver.detection.ModEntry;

public class Utils {
    public static String getModsJson() {
        return Utils.toJson(Utils.getModsList());
    }

    private static LinkedHashMap<String, Object> toJsonMap(LinkedHashMap<ModEntry, Object> map) {
        LinkedHashMap<String, Object> jsonReadyMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<ModEntry, Object> mapEntry : map.entrySet()) {
            LinkedHashMap linkedHashMap;
            Object object = mapEntry.getValue();
            if (object instanceof LinkedHashMap && !(linkedHashMap = (LinkedHashMap)object).isEmpty()) {
                jsonReadyMap.put(mapEntry.getKey().getId() + " " + mapEntry.getKey().getHash(), Utils.toJsonMap(linkedHashMap));
                continue;
            }
            jsonReadyMap.put(mapEntry.getKey().getId(), mapEntry.getKey().getHash());
        }
        return jsonReadyMap;
    }

    public static String toJson(LinkedHashMap<ModEntry, Object> map) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(Utils.toJsonMap(map));
    }

    public static LinkedHashMap<ModEntry, Object> getModsList() {
        LinkedHashMap<ModEntry, Object> mods = new LinkedHashMap<ModEntry, Object>();
        FabricLoader.getInstance().getAllMods().forEach(modContainer -> {
            if (modContainer.getContainingMod().isEmpty()) {
                mods.put(new ModEntry((ModContainer)modContainer, Utils.getHash(modContainer)), Utils.getChildren(modContainer));
            }
        });
        return mods;
    }

    private static LinkedHashMap<ModEntry, Object> getChildren(ModContainer entry) {
        LinkedHashMap<ModEntry, Object> result = new LinkedHashMap<ModEntry, Object>();
        if (entry.getContainedMods().isEmpty()) {
            return result;
        }
        entry.getContainedMods().forEach(container -> {
            if (!container.getContainedMods().isEmpty()) {
                result.put(new ModEntry((ModContainer)container), Utils.getChildren(container));
            } else {
                result.put(new ModEntry((ModContainer)container), List.of());
            }
        });
        return result;
    }

    public static String getHash(ModContainer container) {
        if (container.getOrigin().getPaths().isEmpty() || ((Path)container.getOrigin().getPaths().getFirst()).toFile().isDirectory()) {
            return "";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (FileInputStream fis = new FileInputStream(((Path)container.getOrigin().getPaths().getFirst()).toFile());){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = ((InputStream)fis).read(buffer)) != -1) {
                    digest.update(buffer, 0, bytesRead);
                }
            }
            byte[] hashBytes = digest.digest();
            return Utils.bytesToHex(hashBytes);
        }
        catch (Exception e) {
            ModObserver.LOGGER.error("Can not create hash of " + container.getMetadata().getId());
            throw new RuntimeException(e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }

    public static boolean isFabricApi(String modid) {
        if (List.of("mixinextras", "minecraft", "fabric-api", "fabric-api-base", "fabricloader", "java", "fabric-renderer-indigo").contains(modid)) {
            return true;
        }
        try {
            Integer.parseInt(String.valueOf(modid.charAt(modid.length() - 1)));
        }
        catch (NumberFormatException ignored) {
            return false;
        }
        return modid.startsWith("fabric-") && modid.lastIndexOf("-v") == modid.length() - 3;
    }
}

